/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.JavaProcessManager;
import org.epics.ca.impl.repeater.CARepeater;
import org.epics.ca.impl.repeater.CARepeaterStatusChecker;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.impl.repeater.UdpSocketReserver;
import org.epics.ca.impl.repeater.UdpSocketUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class CARepeaterStatusCheckerTest {
    private static final int TEST_PORT = 45783;
    private static final Logger logger = LibraryLogManager.getLogger(CARepeaterStatusCheckerTest.class);
    private ThreadWatcher threadWatcher;

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat(NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), Is.is(true));
        if (NetworkUtilities.isVpnActive()) {
            Assertions.fail("This test is not supported when a VPN connection is active on the local network interface.");
        }
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
        MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(45783), Is.is(false));
    }

    @AfterEach
    void afterEach() {
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(45783), Is.is(true));
        Assertions.assertDoesNotThrow(() -> this.threadWatcher.verify(), "Thread leak detected !");
    }

    @Test
    void testNothingShouldBeRunningOnRepeaterPort() {
    }

    @Test
    void testIsRepeaterRunning_detectsShareableSocketWhenReservedInSameJvm() throws Throwable {
        try (DatagramSocket ignored = UdpSocketUtilities.createBroadcastAwareListeningSocket(45783, true);){
            MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(45783), Is.is(true));
        }
        MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(45783), Is.is(false));
    }

    @Test
    void testIsRepeaterRunning_detectsNonShareableSocketWhenReservedInSameJvm() throws Throwable {
        try (DatagramSocket ignored = UdpSocketUtilities.createBroadcastAwareListeningSocket(45783, true);){
            MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(45783), Is.is(true));
        }
        MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(45783), Is.is(false));
    }

    @MethodSource(value={"getArgumentsForTestIsRepeaterRunning_detectsSocketReservedInDifferentJvmOnDifferentLocalAddresses"})
    @ParameterizedTest
    void testIsRepeaterRunning_detectsSocketReservedInDifferentJvmOnDifferentLocalAddress(String localAddress) throws Throwable {
        Validate.notNull(localAddress, "The localAddress was not provided.", new Object[0]);
        logger.info("Checking whether repeater instance detected on local address: '" + localAddress + "'");
        int portToReserve = 5065;
        int reservationTimeInMillis = 3000;
        JavaProcessManager processManager = UdpSocketReserver.start(localAddress, 5065, 3000);
        Thread.sleep(1500L);
        MatcherAssert.assertThat(processManager.isAlive(), Is.is(true));
        MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(5065), Is.is(true));
        processManager.waitFor(5000L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat(processManager.isAlive(), Is.is(false));
        MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(5065), Is.is(false));
    }

    @Test
    void testIsRepeaterRunning_startRepeaterInCurrentJvmProcess() throws Throwable {
        CARepeater repeater = new CARepeater(45783);
        repeater.start();
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStarts(45783), Is.is(true));
        repeater.shutdown();
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(45783), Is.is(true));
    }

    private static Stream<Arguments> getArgumentsForTestIsRepeaterRunning_detectsSocketReservedInDifferentJvmOnDifferentLocalAddresses() {
        List<Inet4Address> localAddressList = NetworkUtilities.getLocalNetworkInterfaceAddresses();
        List localAddresses = localAddressList.stream().map(Inet4Address::getHostAddress).collect(Collectors.toList());
        return localAddresses.stream().map(xva$0 -> Arguments.of(xva$0));
    }
}

