/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.requests;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.Monitor;
import org.epics.ca.Status;
import org.epics.ca.impl.ChannelImpl;
import org.epics.ca.impl.ContextImpl;
import org.epics.ca.impl.Messages;
import org.epics.ca.impl.NotifyResponseRequest;
import org.epics.ca.impl.TcpTransport;
import org.epics.ca.impl.Transport;
import org.epics.ca.impl.TypeSupports;
import org.epics.ca.impl.monitor.MonitorNotificationService;
import org.epics.ca.util.logging.LibraryLogManager;

public class MonitorRequest<T>
implements Monitor<T>,
NotifyResponseRequest {
    private static final Logger logger = LibraryLogManager.getLogger(MonitorRequest.class);
    private int bufferOverrunWarningCount = 0;
    private final ContextImpl context;
    private final int ioid;
    protected final ChannelImpl<?> channel;
    private final TypeSupports.TypeSupport<T> typeSupport;
    private final int mask;
    private final MonitorNotificationService<T> monitorNotificationService;
    protected final Consumer<? super T> consumer;
    protected final AtomicBoolean closed = new AtomicBoolean();

    public MonitorRequest(ChannelImpl<?> channel, Transport transport, TypeSupports.TypeSupport<T> typeSupport, int mask, MonitorNotificationService<T> monitorNotificationService, Consumer<? super T> consumer) {
        this.channel = Validate.notNull(channel);
        this.typeSupport = Validate.notNull(typeSupport);
        this.mask = mask;
        this.monitorNotificationService = Validate.notNull(monitorNotificationService);
        this.consumer = Validate.notNull(consumer);
        this.context = transport.getContext();
        this.ioid = this.context.registerResponseRequest(this);
        channel.registerResponseRequest(this);
        this.resubscribe(transport);
    }

    @Override
    public int getIOID() {
        return this.ioid;
    }

    @Override
    public void response(int status, short dataType, int dataCount, ByteBuffer dataPayloadBuffer) {
        Validate.notNull(dataPayloadBuffer);
        Status caStatus = Status.forStatusCode(status);
        if (caStatus == Status.NORMAL) {
            boolean overrun;
            boolean bl = overrun = !this.monitorNotificationService.publish(dataPayloadBuffer, this.typeSupport, dataCount);
            if (overrun) {
                ++this.bufferOverrunWarningCount;
                if (this.bufferOverrunWarningCount < 3) {
                    logger.log(Level.WARNING, "Buffer Overrun: the monitor notification service implementation discarded the oldest data in the notification buffer.");
                } else if (this.bufferOverrunWarningCount == 3) {
                    logger.log(Level.WARNING, "Buffer Overrun: no further warnings will be issued for this monitor.");
                }
            }
        } else {
            this.cancel();
        }
    }

    @Override
    public void cancel() {
        this.context.unregisterResponseRequest(this);
        this.channel.unregisterResponseRequest(this);
    }

    public void resubscribe(Transport transport) {
        int dataCount = this.typeSupport.getForcedElementCount();
        if (dataCount == 0 && this.channel.getTcpTransport().getMinorRevision() < 13) {
            dataCount = this.channel.getNativeElementCount();
        }
        Messages.createSubscriptionMessage(transport, this.typeSupport.getDataType(), dataCount, this.channel.getSID(), this.ioid, this.mask);
        transport.flush();
    }

    @Override
    public void exception(int errorCode, String errorMessage) {
        Status status = Status.forStatusCode(errorCode);
        if (status == null) {
            logger.log(Level.WARNING, "Unknown CA status code received for monitor, code: " + errorCode + ", message: " + errorMessage);
            return;
        }
        if (status == Status.CHANDESTROY) {
            this.cancel();
        } else if (status == Status.DISCONN) {
            logger.finest("Channel disconnected.");
        } else {
            logger.log(Level.WARNING, "Exception with CA status " + (Object)((Object)status) + " received for monitor, message: " + (errorMessage != null ? errorMessage : status.getMessage()));
        }
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.cancel();
        TcpTransport transport = this.channel.getTcpTransport();
        if (transport == null) {
            return;
        }
        int dataCount = this.typeSupport.getForcedElementCount();
        if (dataCount == 0 && this.channel.getTcpTransport().getMinorRevision() < 13) {
            dataCount = this.channel.getNativeElementCount();
        }
        try {
            Messages.cancelSubscriptionMessage(transport, this.typeSupport.getDataType(), dataCount, this.channel.getSID(), this.ioid);
            transport.flush();
        }
        catch (Throwable th) {
            logger.log(Level.FINER, "Failed to send 'cancel subscription' message.", th);
        }
    }
}

