/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.argumentmatching;

import java.util.LinkedList;
import java.util.List;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.matchers.ContainsExtraTypeInfo;

public class ArgumentMatchingTool {
    private ArgumentMatchingTool() {
    }

    public static Integer[] getSuspiciouslyNotMatchingArgsIndexes(List<ArgumentMatcher> matchers, Object[] arguments) {
        if (matchers.size() != arguments.length) {
            return new Integer[0];
        }
        LinkedList<Integer> suspicious = new LinkedList<Integer>();
        int i2 = 0;
        for (ArgumentMatcher m : matchers) {
            if (m instanceof ContainsExtraTypeInfo && !ArgumentMatchingTool.safelyMatches(m, arguments[i2]) && ArgumentMatchingTool.toStringEquals(m, arguments[i2]) && !((ContainsExtraTypeInfo)((Object)m)).typeMatches(arguments[i2])) {
                suspicious.add(i2);
            }
            ++i2;
        }
        return suspicious.toArray(new Integer[0]);
    }

    private static boolean safelyMatches(ArgumentMatcher m, Object arg) {
        try {
            return m.matches(arg);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean toStringEquals(ArgumentMatcher m, Object arg) {
        return m.toString().equals(arg == null ? "null" : arg.toString());
    }
}

