/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl;

import java.util.Properties;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.Validate;
import org.epics.ca.impl.ConfigurationReader;

@Immutable
public class ProtocolConfiguration {
    private static final int CA_PORT_BASE = 5056;
    private final Properties properties;
    public static final String EPICS_CA_ADDR_LIST_DEFAULT = "";
    public static final boolean EPICS_CA_AUTO_ADDR_LIST_DEFAULT = true;
    public static final float EPICS_CA_CONN_TMO_DEFAULT = 30.0f;
    public static final int EPICS_CA_REPEATER_PORT_DEFAULT = 5065;
    public static final int EPICS_CA_SERVER_PORT_DEFAULT = 5064;
    public static final int EPICS_CA_MAX_ARRAY_BYTES_DEFAULT = 0;

    public ProtocolConfiguration() {
        this(new Properties());
    }

    public ProtocolConfiguration(Properties properties) {
        this.properties = Validate.notNull(properties);
    }

    public String getAddressList() {
        return ConfigurationReader.readStringProperty(PropertyNames.EPICS_CA_ADDR_LIST.toString(), this.properties, EPICS_CA_ADDR_LIST_DEFAULT);
    }

    public boolean getAutoAddressList() {
        return ConfigurationReader.readBooleanProperty(PropertyNames.EPICS_CA_AUTO_ADDR_LIST.toString(), this.properties, true);
    }

    public float getConnectionTimeout() {
        return ConfigurationReader.readFloatProperty(PropertyNames.EPICS_CA_CONN_TMO.toString(), this.properties, 30.0f);
    }

    public int getRepeaterPort() {
        return ConfigurationReader.readIntegerProperty(PropertyNames.EPICS_CA_REPEATER_PORT.toString(), this.properties, 5065);
    }

    public int getServerPort() {
        return ConfigurationReader.readIntegerProperty(PropertyNames.EPICS_CA_SERVER_PORT.toString(), this.properties, 5064);
    }

    public int getMaxArrayBytes() {
        return ConfigurationReader.readIntegerProperty(PropertyNames.EPICS_CA_MAX_ARRAY_BYTES.toString(), this.properties, 0);
    }

    public static enum PropertyNames {
        EPICS_CA_ADDR_LIST,
        EPICS_CA_AUTO_ADDR_LIST,
        EPICS_CA_CONN_TMO,
        EPICS_CA_REPEATER_PORT,
        EPICS_CA_SERVER_PORT,
        EPICS_CA_MAX_ARRAY_BYTES;

    }
}

