/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.Inet4Address;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.impl.JavaProcessManager;
import org.epics.ca.impl.LibraryConfiguration;
import org.epics.ca.impl.repeater.CARepeater;
import org.epics.ca.impl.repeater.CARepeaterStatusChecker;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.util.logging.LibraryLogManager;

class CARepeaterServiceInstance {
    private static final Logger logger = LibraryLogManager.getLogger(CARepeaterServiceInstance.class);
    private final int port;
    private final JavaProcessManager processManager;
    private final AtomicBoolean activated;
    private final AtomicBoolean shutdown;

    CARepeaterServiceInstance(int port) {
        this.port = port;
        Level logLevel = LibraryConfiguration.getInstance().getRepeaterLogLevel();
        this.processManager = this.createProcessManager(port, logLevel);
        this.activated = new AtomicBoolean(false);
        this.shutdown = new AtomicBoolean(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CARepeaterServiceInstance)) {
            return false;
        }
        CARepeaterServiceInstance that = (CARepeaterServiceInstance)o;
        return this.port == that.port;
    }

    public int hashCode() {
        return Objects.hash(this.port);
    }

    int getPort() {
        return this.port;
    }

    void activate() {
        Validate.validState(!this.activated.getAndSet(true), "This service instance was already activated.", new Object[0]);
        if (!LibraryConfiguration.getInstance().isRepeaterEnabled()) {
            logger.info("The CA Repeater Service configuration is set to disabled.");
            return;
        }
        if (CARepeaterStatusChecker.isRepeaterRunning(this.port)) {
            logger.info("The CA Repeater is already running on port " + this.port + ".");
            logger.info("Possibly it was started previously by another operating system process.");
            return;
        }
        boolean outputCaptureEnable = LibraryConfiguration.getInstance().isRepeaterOutputCaptureEnabled();
        if (this.processManager.start(outputCaptureEnable)) {
            logger.info("The CA Repeater on port " + this.port + " was started.");
        } else {
            logger.warning("The CA Repeater on port " + this.port + " failed to start.");
        }
    }

    void shutdown() {
        Validate.validState(this.activated.get(), "This service instance was not previously activated.", new Object[0]);
        Validate.validState(!this.shutdown.getAndSet(true), "This service instance was already shut down.", new Object[0]);
        if (!LibraryConfiguration.getInstance().isRepeaterEnabled()) {
            logger.info("The CA Repeater Service configuration is set to disabled.");
            return;
        }
        if (!this.processManager.isAlive()) {
            logger.info("The CA Repeater on port " + this.port + " is no longer alive.");
            return;
        }
        if (this.processManager.shutdown()) {
            logger.info("The CA Repeater on port " + this.port + " was shut down.");
        } else {
            logger.warning("The CA Repeater on port " + this.port + " failed to shut down.");
        }
    }

    boolean isProcessAlive() {
        return this.processManager.isAlive();
    }

    private JavaProcessManager createProcessManager(int repeaterPort, Level logLevel) {
        Validate.notNull(logLevel);
        Validate.inclusiveBetween(1L, 65535L, repeaterPort, "The port must be in the inclusive range 1-65535.");
        logger.fine("Starting the repeater in a separate process...");
        logger.fine("The following local interfaces have been discovered...");
        List<Inet4Address> addrList = NetworkUtilities.getLocalNetworkInterfaceAddresses();
        addrList.forEach(ip -> logger.fine(ip.toString()));
        Properties properties = new Properties();
        properties.put("java.net.preferIPv4Stack", "true");
        properties.put("java.net.preferIPv6Stack", "false");
        properties.put("CA_LIBRARY_LOG_LEVEL", logLevel.toString());
        String repeaterPortAsString = Integer.toString(repeaterPort);
        String[] programArgs = new String[]{"-p", repeaterPortAsString};
        return new JavaProcessManager(CARepeater.class, properties, programArgs);
    }
}

