/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.InetSocketAddress;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.StopWatch;
import org.epics.ca.impl.repeater.UdpSocketUtilities;
import org.epics.ca.util.logging.LibraryLogManager;

public class CARepeaterStatusChecker {
    private static final int PROCESS_STABILISATION_DELAY_IN_MILLIS = 2000;
    private static final Logger logger = LibraryLogManager.getLogger(CARepeaterStatusChecker.class);

    public static boolean isRepeaterRunning(int repeaterPort) {
        logger.finest("Checking whether repeater is running on port " + repeaterPort);
        InetSocketAddress wildcardSocketAddress = new InetSocketAddress(repeaterPort);
        logger.finest("Checking socket address " + wildcardSocketAddress);
        boolean repeaterIsRunning = !UdpSocketUtilities.isSocketAvailable(wildcardSocketAddress);
        String runningOrNot = repeaterIsRunning ? " IS " : " IS NOT ";
        logger.finest("The repeater on port " + repeaterPort + runningOrNot + "running.");
        return repeaterIsRunning;
    }

    public static boolean verifyRepeaterStarts(int repeaterPort) {
        return CARepeaterStatusChecker.isRepeaterInExpectedState(repeaterPort, true);
    }

    public static boolean verifyRepeaterStops(int repeaterPort) {
        return CARepeaterStatusChecker.isRepeaterInExpectedState(repeaterPort, false);
    }

    private static boolean isRepeaterInExpectedState(int repeaterPort, boolean expectedRunState) {
        boolean verified;
        int periodicPollIntervalInMilliseconds = 10;
        StopWatch stopWatch = StopWatch.createStarted();
        while (CARepeaterStatusChecker.isRepeaterRunning(repeaterPort) != expectedRunState && stopWatch.getTime() < 2000L) {
            logger.finest("Waiting 10ms...");
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                logger.warning("Interrupted from sleep !");
                Thread.currentThread().interrupt();
            }
        }
        stopWatch.stop();
        boolean bl = verified = stopWatch.getTime() < 2000L;
        if (!verified) {
            logger.warning("Timeout whilst waiting for CA Repeater to reach expected state !");
        }
        return verified;
    }
}

