/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import org.epics.ca.impl.repeater.CARepeaterMessage;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.impl.repeater.UdpSocketUtilities;

public class UdpMessageSniffer {
    public static void main(String[] argv) {
        int port;
        if (!NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible()) {
            return;
        }
        if (argv.length != 1) {
            System.out.println("Usage: java -cp <caJarFile> org.epics.ca.impl.repeater.UdpMessageSniffer <port>");
            return;
        }
        try {
            port = Integer.parseInt(argv[0]);
        }
        catch (NumberFormatException ex) {
            System.out.println("The supplied argument ('" + argv[0] + "') could not be converted to an integer.");
            return;
        }
        if (port < 0 || port > 65535) {
            System.out.println("The supplied argument ('" + argv[0] + "') was outside the allowed range (0-65535");
            return;
        }
        UdpMessageSniffer.sniff(port);
    }

    private static void sniff(int port) {
        DatagramSocket socket;
        try {
            socket = UdpSocketUtilities.createBroadcastAwareListeningSocket(port, true);
            System.out.println("Listening for traffic on port " + port);
        }
        catch (SocketException ex) {
            System.out.println("ERROR: The listening socket on port " + port + " could not be opened.");
            return;
        }
        boolean socketErrors = false;
        while (!socketErrors) {
            DatagramPacket rxPacket = new DatagramPacket(new byte[16384], 16384);
            try {
                socket.receive(rxPacket);
            }
            catch (IOException ex) {
                System.out.println("ERROR: The listening socket experienced a problem. This utility will quit.");
                socketErrors = true;
                continue;
            }
            System.out.println("\nReceived packet from " + rxPacket.getSocketAddress() + " of length " + rxPacket.getLength() + " bytes.");
            boolean unprocessedMessages = true;
            while (unprocessedMessages) {
                System.out.println(CARepeaterMessage.extractMessageAsString(rxPacket));
                unprocessedMessages = rxPacket.getLength() > 0;
            }
        }
    }
}

