/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.examples;

import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.epics.ca.Channel;
import org.epics.ca.Context;
import org.epics.ca.Listener;
import org.epics.ca.Monitor;
import org.epics.ca.Status;
import org.epics.ca.data.Alarm;
import org.epics.ca.data.Control;
import org.epics.ca.data.Graphic;
import org.epics.ca.data.GraphicEnum;
import org.epics.ca.data.GraphicEnumArray;
import org.epics.ca.data.Timestamped;

public class Example {
    public static void main(String[] args) {
        Properties properties = new Properties();
        try (Context context = new Context(properties);){
            System.out.print("Creating a DOUBLE channel... ");
            Channel<Double> dblCh = context.createChannel("adc01", Double.class);
            System.out.println("OK.");
            System.out.print("Adding a connection listener... ");
            Listener connectionListener = dblCh.addConnectionListener((channel, state) -> System.out.println(channel.getName() + " is connected? " + state));
            System.out.println("OK.");
            System.out.print("Removing a connection listener... ");
            connectionListener.close();
            System.out.println("OK.");
            System.out.print("Adding an access rights listener... ");
            Listener accessRightsListener = dblCh.addAccessRightListener((channel, rights) -> System.out.println(channel.getName() + " is rights? " + (Object)rights));
            System.out.println("OK.");
            System.out.print("Removing an access rights listener... ");
            accessRightsListener.close();
            System.out.println("OK.");
            System.out.print("Connecting asynchronously... ");
            dblCh.connectAsync().get();
            System.out.println("OK.");
            System.out.print("Putting DOUBLE value asynchronously, without waiting for completion... ");
            dblCh.putNoWait(3.11);
            System.out.println("OK.");
            System.out.print("Putting DOUBLE value asynchronously, then waiting for completion... ");
            CompletableFuture<Status> fp = dblCh.putAsync(12.8);
            System.out.println("OK. Data returned: '" + (Object)((Object)fp.get()) + "'.");
            System.out.print("Getting DOUBLE value asynchronously, then waiting for completion... ");
            CompletableFuture<Double> fd = dblCh.getAsync();
            System.out.println("OK. Data returned: '" + fd.get() + "'.");
            System.out.print("Getting DOUBLE value asynchronously with ALARM metadata, then waiting for completion... ");
            CompletableFuture fal = dblCh.getAsync(Alarm.class);
            Alarm dal = (Alarm)fal.get();
            System.out.println("OK. Data returned: '" + dal.getValue() + ", " + (Object)((Object)dal.getAlarmStatus()) + ", " + (Object)((Object)dal.getAlarmSeverity()) + "'.");
            System.out.print("Getting DOUBLE value asynchronously with TIMESTAMP metadata, then waiting for completion... ");
            CompletableFuture fts = dblCh.getAsync(Timestamped.class);
            Timestamped dts = (Timestamped)fts.get();
            System.out.println("OK. Data returned: '" + dts.getValue() + ", " + (Object)((Object)dts.getAlarmStatus()) + ", " + (Object)((Object)dts.getAlarmSeverity()) + ", " + new Date(dts.getMillis()) + "'.");
            System.out.print("Getting DOUBLE value asynchronously with GRAPHIC metadata, then waiting for completion... ");
            CompletableFuture fgr = dblCh.getAsync(Graphic.class);
            Graphic dgr = (Graphic)fgr.get();
            System.out.println("OK. Data returned: '" + dgr.getValue() + ", " + (Object)((Object)dgr.getAlarmStatus()) + ", " + (Object)((Object)dgr.getAlarmSeverity()) + ", " + dgr.getLowerDisplay() + ", " + dgr.getUpperDisplay() + "'.");
            System.out.print("Getting DOUBLE value asynchronously with CONTROL metadata, then waiting for completion... ");
            CompletableFuture fc = dblCh.getAsync(Control.class);
            Control dc = (Control)fc.get();
            System.out.println("OK. Data returned: '" + dc.getValue() + ", " + (Object)((Object)dc.getAlarmStatus()) + ", " + (Object)((Object)dc.getAlarmSeverity()) + ", " + dc.getLowerControl() + ", " + dc.getUpperControl() + "'.");
            System.out.print("Getting DOUBLE ARRAY value asynchronously, then waiting for completion... ");
            Channel<double[]> dblArrCh = context.createChannel("adc01", double[].class).connectAsync().get();
            CompletableFuture<double[]> fda = dblArrCh.getAsync();
            System.out.println("OK. Data returned: '" + Arrays.toString(fda.get()) + "'.");
            System.out.print("Getting DOUBLE ARRAY value asynchronously, with GRAPHIC metadata, then waiting for completion... ");
            CompletableFuture fdagr = dblArrCh.getAsync(Graphic.class);
            Graphic dagr = (Graphic)fdagr.get();
            System.out.println("OK. Data returned: '" + Arrays.toString((double[])dagr.getValue()) + ", " + (Object)((Object)dagr.getAlarmStatus()) + ", " + (Object)((Object)dagr.getAlarmSeverity()) + ", " + dagr.getLowerDisplay() + " " + dagr.getUpperDisplay() + "'.");
            System.out.print("Getting GRAPHIC ENUM value asynchronously, then waiting for completion... ");
            Channel<Short> enumCh = context.createChannel("enum", Short.class).connectAsync().get();
            CompletableFuture fge = enumCh.getAsync(GraphicEnum.class);
            GraphicEnum ge = (GraphicEnum)fge.get();
            System.out.println("OK. Data returned: '" + ge.getValue() + ", " + Arrays.toString(ge.getLabels()) + "'.");
            System.out.print("Getting GRAPHIC ENUM ARRAY value asynchronously, then waiting for completion... ");
            Channel<short[]> enumArrCh = context.createChannel("enum", short[].class).connectAsync().get();
            CompletableFuture fgea = enumArrCh.getAsync(GraphicEnumArray.class);
            GraphicEnumArray gea = (GraphicEnumArray)fgea.get();
            System.out.println("OK. Data returned: '" + Arrays.toString((short[])gea.getValue()) + ", " + Arrays.toString(gea.getLabels()) + "'.");
            System.out.print("Getting GRAPHIC ENUM value synchronously, then waiting for completion... ");
            GraphicEnum ges = (GraphicEnum)enumCh.get(GraphicEnum.class);
            System.out.println("OK. Data returned: '" + Arrays.toString(ges.getLabels()) + "'.");
            System.out.print("Putting SHORT value asynchronously, without waiting for completion... ");
            enumCh.putNoWait((short)99);
            System.out.println("OK.");
            System.out.print("Monitoring DOUBLE, waiting for notifications...");
            Monitor<Double> mon = dblCh.addValueMonitor(x -> System.out.println("OK. Data returned: '" + x + "'."));
            Thread.sleep(100L);
            System.out.print("Closing Monitor... ");
            mon.close();
            System.out.println("OK.");
            System.out.print("Monitoring DOUBLE, requesting ALARM information, waiting for notifications... ");
            try (Monitor<Alarm> ignored = dblCh.addMonitor(Alarm.class, value -> {
                if (value != null) {
                    System.out.println("OK. Data returned: '" + (Object)((Object)value.getAlarmStatus()) + ", " + (Object)((Object)value.getAlarmSeverity()) + ", " + value.getValue() + "'.");
                }
            });){
                Thread.sleep(100L);
            }
            Thread.sleep(100L);
            System.out.print("Monitoring DOUBLE, requesting TIMESTAMP information, waiting for notifications... ");
            ignored = dblCh.addMonitor(Timestamped.class, value -> {
                if (value != null) {
                    System.out.println("OK. Data returned: '" + (Object)((Object)value.getAlarmStatus()) + ", " + (Object)((Object)value.getAlarmSeverity()) + ", " + new Date(value.getMillis()) + ", " + value.getValue() + "'.");
                }
            });
            var30_33 = null;
            try {
                Thread.sleep(100L);
            }
            catch (Throwable throwable) {
                var30_33 = throwable;
                throw throwable;
            }
            finally {
                if (ignored != null) {
                    if (var30_33 != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable) {
                            var30_33.addSuppressed(throwable);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
            Thread.sleep(100L);
            System.out.print("Creating DOUBLE channel... ");
            Channel<Double> dblSyncCh = context.createChannel("adc04", Double.class);
            System.out.println("OK.");
            System.out.print("Using connectAsync followed by ThenAccept... ");
            dblSyncCh.connectAsync().thenAccept(chan -> System.out.println("OK. Channel: '" + chan.getName() + ", connection state: " + (Object)((Object)chan.getConnectionState()) + "."));
            Thread.sleep(100L);
            System.out.print("Creating an INTEGER channel... ");
            Channel<Integer> intCh = context.createChannel("adc02", Integer.class);
            System.out.println("OK.");
            System.out.print("Creating a STRING channel... ");
            Channel<String> strCh = context.createChannel("adc03", String.class);
            System.out.println("OK.");
            System.out.print("Waiting for MULTIPLE channels of MIXED types to connect... ");
            CompletionStage f = CompletableFuture.allOf(intCh.connectAsync(), strCh.connectAsync()).thenAccept(v -> System.out.println("OK: ALL channels of MIXED types connected."));
            ((CompletableFuture)f).get();
            System.out.print("Getting DOUBLE synchronously... ");
            double dv = dblCh.get();
            System.out.println("OK. Data returned: '" + dv + "'.");
            System.out.print("Getting DOUBLE synchronously with ALARM information... ");
            Alarm dval = (Alarm)dblCh.get(Alarm.class);
            System.out.println("OK. Data returned: '" + dval.getValue() + ", " + (Object)((Object)dval.getAlarmStatus()) + ", " + (Object)((Object)dval.getAlarmSeverity()) + "'.");
            System.out.print("Getting DOUBLE synchronously with TIMESTAMP information... ");
            Timestamped dvts = (Timestamped)dblCh.get(Timestamped.class);
            System.out.println("OK. Data returned: '" + dvts.getValue() + ", " + (Object)((Object)dvts.getAlarmStatus()) + ", " + (Object)((Object)dvts.getAlarmSeverity()) + ", " + new Date(dvts.getMillis()) + "'.");
            System.out.print("Monitoring DOUBLE using try-with-resources... ");
            try (Monitor<Double> ignored = dblCh.addValueMonitor(v -> System.out.println("OK. Data returned: '" + v + "'."));){
                Thread.sleep(100L);
            }
            System.out.println("OK.");
        }
        catch (Exception ex) {
            System.out.println("\nThe example program FAILED, with the following exception: " + ex);
            System.exit(-1);
        }
        System.out.println("\nThe example program SUCCEEDED, and ran to completion.");
    }
}

