/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.util.logging.LibraryLogManager;

public class ConfigurationReader {
    private static final Logger logger = LibraryLogManager.getLogger(ConfigurationReader.class);

    public static String readStringProperty(String item, Properties properties, String defaultValue) {
        Validate.notNull((Object)item);
        Validate.notNull((Object)properties);
        Validate.notNull((Object)defaultValue);
        String sValue = properties.getProperty(item, System.getenv(item));
        return sValue != null ? sValue : defaultValue;
    }

    public static boolean readBooleanProperty(String item, Properties properties, boolean defaultValue) {
        Validate.notNull((Object)item);
        Validate.notNull((Object)properties);
        String sValue = properties.getProperty(item, System.getenv(item));
        if (sValue != null) {
            if (sValue.equalsIgnoreCase("yes") || sValue.equalsIgnoreCase("true")) {
                return true;
            }
            if (sValue.equalsIgnoreCase("no") || sValue.equalsIgnoreCase("false")) {
                return false;
            }
            logger.config("Failed to parse boolean value for property " + item + ": \"" + sValue + "\", \"YES\" or \"NO\" expected.");
            return defaultValue;
        }
        return defaultValue;
    }

    public static float readFloatProperty(String item, Properties properties, float defaultValue) {
        Validate.notNull((Object)item);
        Validate.notNull((Object)properties);
        String sValue = properties.getProperty(item, System.getenv(item));
        if (sValue != null) {
            try {
                return Float.parseFloat(sValue);
            }
            catch (Throwable th) {
                logger.config("Failed to parse float value for property " + item + ": \"" + sValue + "\".");
            }
        }
        return defaultValue;
    }

    public static int readIntegerProperty(String item, Properties properties, int defaultValue) {
        Validate.notNull((Object)item);
        Validate.notNull((Object)properties);
        String sValue = properties.getProperty(item, System.getenv(item));
        if (sValue != null) {
            try {
                return Integer.parseInt(sValue);
            }
            catch (Throwable th) {
                logger.config("Failed to parse integer value for property " + item + ": \"" + sValue + "\".");
            }
        }
        return defaultValue;
    }

    public static Level readDebugLevelProperty(String item, Properties properties, Level defaultValue) {
        Validate.notNull((Object)item);
        Validate.notNull((Object)properties);
        Validate.notNull((Object)defaultValue);
        String sValue = ConfigurationReader.readStringProperty(item, properties, defaultValue.toString());
        try {
            return Level.parse(sValue);
        }
        catch (Throwable th) {
            logger.config("Failed to parse logging level value for property " + item + ": \"" + sValue + "\".");
            return defaultValue;
        }
    }
}

