/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.Channel;
import org.epics.ca.impl.BeaconHandler;
import org.epics.ca.impl.ChannelImpl;
import org.epics.ca.impl.LibraryConfiguration;
import org.epics.ca.impl.Messages;
import org.epics.ca.impl.ProtocolConfiguration;
import org.epics.ca.impl.ResponseHandlers;
import org.epics.ca.impl.ResponseRequest;
import org.epics.ca.impl.StatefullEventSource;
import org.epics.ca.impl.TcpTransport;
import org.epics.ca.impl.TransportClient;
import org.epics.ca.impl.TransportRegistry;
import org.epics.ca.impl.TypeSupports;
import org.epics.ca.impl.UdpBroadcastTransport;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactory;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactoryCreator;
import org.epics.ca.impl.reactor.Reactor;
import org.epics.ca.impl.reactor.ReactorHandler;
import org.epics.ca.impl.reactor.lf.LeaderFollowersHandler;
import org.epics.ca.impl.reactor.lf.LeaderFollowersThreadPool;
import org.epics.ca.impl.repeater.CARepeaterServiceManager;
import org.epics.ca.impl.search.ChannelSearchManager;
import org.epics.ca.util.IntHashMap;
import org.epics.ca.util.logging.LibraryLogManager;
import org.epics.ca.util.net.InetAddressUtil;
import org.epics.ca.util.sync.NamedLockPattern;

public class ContextImpl
implements AutoCloseable {
    private static final Logger logger;
    private static final int LOCK_TIMEOUT = 20000;
    private static final CARepeaterServiceManager caRepeaterServiceManager;
    private final NamedLockPattern namedLocker = new NamedLockPattern();
    private final ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final TransportRegistry transportRegistry = new TransportRegistry();
    private final AtomicReference<UdpBroadcastTransport> udpBroadcastTransportRef = new AtomicReference();
    private final Map<InetSocketAddress, BeaconHandler> beaconHandlers = new HashMap<InetSocketAddress, BeaconHandler>();
    private final IntHashMap<ChannelImpl<?>> channelsByCID = new IntHashMap();
    private final IntHashMap<ResponseRequest> responseRequests = new IntHashMap();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ProtocolConfiguration protocolConfiguration;
    private final MonitorNotificationServiceFactory monitorNotificationServiceFactory;
    private final ScheduledFuture<?> repeaterRegistrationFuture;
    private final LeaderFollowersThreadPool leaderFollowersThreadPool;
    private final Reactor reactor;
    private final ChannelSearchManager channelSearchManager;
    private final String hostName;
    private final String userName;
    private int lastCID = 0;
    private int lastIOID = 0;

    public ContextImpl(ProtocolConfiguration protocolConfiguration) {
        Validate.notNull((Object)protocolConfiguration, (String)"null properties", (Object[])new Object[0]);
        this.protocolConfiguration = protocolConfiguration;
        this.hostName = InetAddressUtil.getHostName();
        this.userName = System.getProperty("user.name", "nobody");
        try {
            this.reactor = new Reactor();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize reactor.", e);
        }
        this.leaderFollowersThreadPool = new LeaderFollowersThreadPool();
        this.leaderFollowersThreadPool.promoteLeader(this.reactor::process);
        this.udpBroadcastTransportRef.set(this.getUdpBroadcastTransport());
        caRepeaterServiceManager.requestServiceOnPort(this.getRepeaterPort());
        InetSocketAddress repeaterLocalAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), protocolConfiguration.getRepeaterPort());
        RepeaterRegistrationTask repeaterRegistrationTask = new RepeaterRegistrationTask(repeaterLocalAddress);
        this.repeaterRegistrationFuture = this.timer.scheduleWithFixedDelay(repeaterRegistrationTask, 500L, 60000L, TimeUnit.MILLISECONDS);
        this.channelSearchManager = new ChannelSearchManager(this.udpBroadcastTransportRef.get());
        String monitorNotifierImpl = LibraryConfiguration.getInstance().getMonitorNotifierImplementation();
        this.monitorNotificationServiceFactory = MonitorNotificationServiceFactoryCreator.create(monitorNotifierImpl);
    }

    public <T> Channel<T> createChannel(String channelName, Class<T> channelType, int priority) {
        Validate.validState((!this.closed.get() ? 1 : 0) != 0, (String)"context closed", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)channelName, (String)"null or empty channel name", (Object[])new Object[0]);
        Validate.isTrue((channelName.length() <= Math.min(1008, 500) ? 1 : 0) != 0, (String)"name too long", (Object[])new Object[0]);
        Validate.notNull(channelType, (String)"null channel type", (Object[])new Object[0]);
        Validate.isTrue((TypeSupports.isNativeType(channelType) || channelType.equals(Object.class) ? 1 : 0) != 0, (String)"invalid channel native type", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)0L, (long)99L, (long)priority, (String)"priority out of bounds");
        return new ChannelImpl<T>(this, channelName, channelType, priority);
    }

    @Override
    public void close() {
        logger.finest("Closing context.");
        if (this.closed.getAndSet(true)) {
            return;
        }
        caRepeaterServiceManager.cancelServiceRequestOnPort(this.getRepeaterPort());
        this.channelSearchManager.cancel();
        this.udpBroadcastTransportRef.get().close();
        this.destroyAllChannels();
        this.reactor.shutdown();
        this.leaderFollowersThreadPool.shutdown();
        this.timer.shutdown();
        this.monitorNotificationServiceFactory.close();
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.executorService.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerResponseRequest(ResponseRequest request) {
        IntHashMap<ResponseRequest> intHashMap = this.responseRequests;
        synchronized (intHashMap) {
            int ioid = this.generateIOID();
            this.responseRequests.put(ioid, request);
            return ioid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseRequest unregisterResponseRequest(ResponseRequest request) {
        IntHashMap<ResponseRequest> intHashMap = this.responseRequests;
        synchronized (intHashMap) {
            return this.responseRequests.remove(request.getIOID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResponseRequest getResponseRequest(int ioid) {
        IntHashMap<ResponseRequest> intHashMap = this.responseRequests;
        synchronized (intHashMap) {
            return this.responseRequests.get(ioid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChannelImpl<?> getChannel(int channelID) {
        IntHashMap<ChannelImpl<?>> intHashMap = this.channelsByCID;
        synchronized (intHashMap) {
            return this.channelsByCID.get(channelID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchResponse(int cid, int sid, short type, int count, short minorRevision, InetSocketAddress serverAddress) {
        ChannelImpl<?> channel = this.getChannel(cid);
        if (channel == null) {
            return;
        }
        logger.log(Level.FINER, "Search response for channel " + channel.getName() + " received.");
        ChannelImpl<?> channelImpl = channel;
        synchronized (channelImpl) {
            TcpTransport transport = channel.getTcpTransport();
            if (transport != null && !transport.getRemoteAddress().equals(serverAddress)) {
                logger.log(Level.INFO, "More than one PVs with name '" + channel.getName() + "' detected, additional response from: " + serverAddress);
                return;
            }
            this.channelSearchManager.searchResponse(channel);
            transport = this.getTcpTransport(channel, serverAddress, minorRevision, channel.getPriority());
            if (transport == null) {
                channel.createChannelFailed();
                return;
            }
            channel.createChannel(transport, sid, type, count);
        }
    }

    void repeaterConfirm(InetSocketAddress responseFrom) {
        logger.fine("Repeater registration confirmed from: " + responseFrom);
        ScheduledFuture<?> sf = this.repeaterRegistrationFuture;
        if (sf != null) {
            sf.cancel(false);
        }
    }

    boolean enqueueStatefullEvent(StatefullEventSource event) {
        if (event.allowEnqueue()) {
            this.executorService.execute(event);
            return true;
        }
        return false;
    }

    void beaconAnomalyNotify() {
        logger.fine("A beacon anomaly has been detected.");
        if (this.channelSearchManager != null) {
            this.channelSearchManager.beaconAnomalyNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BeaconHandler getBeaconHandler(InetSocketAddress responseFrom) {
        Map<InetSocketAddress, BeaconHandler> map = this.beaconHandlers;
        synchronized (map) {
            BeaconHandler handler = this.beaconHandlers.get(responseFrom);
            if (handler == null) {
                handler = new BeaconHandler(this, responseFrom);
                this.beaconHandlers.put(responseFrom, handler);
            }
            return handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int generateCID() {
        IntHashMap<ChannelImpl<?>> intHashMap = this.channelsByCID;
        synchronized (intHashMap) {
            while (this.channelsByCID.containsKey(++this.lastCID)) {
            }
            this.channelsByCID.put(this.lastCID, null);
            return this.lastCID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerChannel(ChannelImpl<?> channel) {
        IntHashMap<ChannelImpl<?>> intHashMap = this.channelsByCID;
        synchronized (intHashMap) {
            this.channelsByCID.put(channel.getCID(), channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterChannel(ChannelImpl<?> channel) {
        IntHashMap<ChannelImpl<?>> intHashMap = this.channelsByCID;
        synchronized (intHashMap) {
            this.channelsByCID.remove(channel.getCID());
        }
    }

    ChannelSearchManager getChannelSearchManager() {
        return this.channelSearchManager;
    }

    UdpBroadcastTransport getUdpBroadcastTransportHolder() {
        return this.udpBroadcastTransportRef.get();
    }

    TransportRegistry getTransportRegistry() {
        return this.transportRegistry;
    }

    LeaderFollowersThreadPool getLeaderFollowersThreadPool() {
        return this.leaderFollowersThreadPool;
    }

    int getRepeaterPort() {
        return this.protocolConfiguration.getRepeaterPort();
    }

    int getServerPort() {
        return this.protocolConfiguration.getServerPort();
    }

    float getConnectionTimeout() {
        return this.protocolConfiguration.getConnectionTimeout();
    }

    int getMaxArrayBytes() {
        return this.protocolConfiguration.getMaxArrayBytes();
    }

    ScheduledExecutorService getScheduledExecutor() {
        return this.timer;
    }

    Reactor getReactor() {
        return this.reactor;
    }

    MonitorNotificationServiceFactory getMonitorNotificationServiceFactory() {
        return this.monitorNotificationServiceFactory;
    }

    private UdpBroadcastTransport getUdpBroadcastTransport() {
        String addressList = this.protocolConfiguration.getAddressList();
        boolean autoAddressList = this.protocolConfiguration.getAutoAddressList();
        int serverPort = this.protocolConfiguration.getServerPort();
        InetSocketAddress[] broadcastAddressList = null;
        if (addressList != null && addressList.length() > 0) {
            InetSocketAddress[] list;
            InetSocketAddress[] appendList = null;
            if (autoAddressList) {
                appendList = InetAddressUtil.getBroadcastAddresses(serverPort);
            }
            if ((list = InetAddressUtil.getSocketAddressList(addressList, serverPort, appendList)).length > 0) {
                broadcastAddressList = list;
            }
        } else if (!autoAddressList) {
            logger.warning("Empty broadcast search address list, all connects will fail.");
        } else {
            broadcastAddressList = InetAddressUtil.getBroadcastAddresses(serverPort);
        }
        if (logger.isLoggable(Level.CONFIG) && broadcastAddressList != null) {
            for (int i = 0; i < broadcastAddressList.length; ++i) {
                logger.config("Broadcast address #" + i + ": " + broadcastAddressList[i] + '.');
            }
        }
        InetSocketAddress connectAddress = new InetSocketAddress(0);
        logger.finer("Creating datagram socket to: " + connectAddress);
        DatagramChannel channel = null;
        try {
            channel = DatagramChannel.open();
            channel.configureBlocking(false);
            channel.socket().setBroadcast(true);
            channel.socket().setReuseAddress(false);
            channel.socket().bind(new InetSocketAddress(0));
            UdpBroadcastTransport transport = new UdpBroadcastTransport(this, ResponseHandlers::handleResponse, channel, connectAddress, broadcastAddressList);
            LeaderFollowersHandler handler = new LeaderFollowersHandler(this.reactor, transport, this.leaderFollowersThreadPool);
            this.reactor.register(channel, 1, handler);
            return transport;
        }
        catch (Throwable th) {
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException("Failed to connect to '" + connectAddress + "'.", th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAllChannels() {
        ChannelImpl[] channelImplArray = this.channelsByCID;
        synchronized (this.channelsByCID) {
            ChannelImpl[] channels = new ChannelImpl[this.channelsByCID.size()];
            this.channelsByCID.toArray(channels);
            this.channelsByCID.clear();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (ChannelImpl channel : channels) {
                try {
                    if (channel == null) continue;
                    channel.close();
                }
                catch (Throwable th) {
                    logger.log(Level.SEVERE, "Unexpected exception caught while closing a channel", th);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateIOID() {
        IntHashMap<ResponseRequest> intHashMap = this.responseRequests;
        synchronized (intHashMap) {
            while (this.responseRequests.containsKey(++this.lastIOID)) {
            }
            this.responseRequests.put(this.lastIOID, null);
            return this.lastIOID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TcpTransport getTcpTransport(TransportClient client, InetSocketAddress address, short minorRevision, int priority) {
        boolean lockAcquired;
        AbstractInterruptibleChannel socket = null;
        TcpTransport transport = (TcpTransport)this.transportRegistry.get(address, priority);
        if (transport != null) {
            logger.log(Level.FINER, "Reusing existing connection to CA server: " + address);
            if (transport.acquire(client)) {
                return transport;
            }
        }
        if (lockAcquired = this.namedLocker.acquireSynchronizationObject(address, 20000L)) {
            try {
                transport = (TcpTransport)this.transportRegistry.get(address, priority);
                if (transport != null) {
                    logger.log(Level.FINER, "Reusing existing connection to CA server: " + address);
                    if (transport.acquire(client)) {
                        TcpTransport tcpTransport = transport;
                        return tcpTransport;
                    }
                }
                logger.log(Level.FINER, "Connecting to CA server: " + address);
                socket = this.tryConnect(address, 3);
                ((AbstractSelectableChannel)socket).configureBlocking(false);
                ((SocketChannel)socket).socket().setTcpNoDelay(true);
                ((SocketChannel)socket).socket().setKeepAlive(true);
                ReactorHandler handler = transport = new TcpTransport(this, client, ResponseHandlers::handleResponse, (SocketChannel)socket, minorRevision, priority);
                if (this.leaderFollowersThreadPool != null) {
                    handler = new LeaderFollowersHandler(this.reactor, handler, this.leaderFollowersThreadPool);
                }
                this.reactor.register((SelectableChannel)socket, 1, handler);
                Messages.versionMessage(transport, (short)priority, 0, false);
                Messages.userNameMessage(transport, this.userName);
                Messages.hostNameMessage(transport, this.hostName);
                transport.flush();
                logger.log(Level.FINER, "Connected to CA server: " + address);
                TcpTransport tcpTransport = transport;
                return tcpTransport;
            }
            catch (Throwable th) {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                logger.log(Level.WARNING, th, () -> "Failed to connect to '" + address + "'.");
                TcpTransport tcpTransport = null;
                return tcpTransport;
            }
            finally {
                this.namedLocker.releaseSynchronizationObject(address);
            }
        }
        logger.severe(() -> "Failed to obtain synchronization lock for '" + address + "', possible deadlock.");
        return null;
    }

    private SocketChannel tryConnect(InetSocketAddress address, int tries) throws IOException {
        IOException lastException = null;
        for (int tryCount = 0; tryCount < tries; ++tryCount) {
            if (tryCount > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    logger.finest("Interrupted Exception");
                }
            }
            logger.finest("Opening socket to CA server " + address + ", attempt " + (tryCount + 1) + ".");
            try {
                return SocketChannel.open(address);
            }
            catch (IOException ioe) {
                lastException = ioe;
                continue;
            }
        }
        throw (IOException)Objects.requireNonNull(lastException);
    }

    static {
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.setProperty("java.net.preferIPv6Stack", "false");
        logger = LibraryLogManager.getLogger(ContextImpl.class);
        caRepeaterServiceManager = new CARepeaterServiceManager();
    }

    private class RepeaterRegistrationTask
    implements Runnable {
        private final InetSocketAddress repeaterLocalAddress;
        private final ByteBuffer buffer = ByteBuffer.allocate(16);

        RepeaterRegistrationTask(InetSocketAddress repeaterLocalAddress) {
            this.repeaterLocalAddress = repeaterLocalAddress;
            Messages.generateRepeaterRegistration(this.buffer);
        }

        @Override
        public void run() {
            try {
                logger.fine("Attempting to register with repeater at address: '" + this.repeaterLocalAddress + "'.");
                ContextImpl.this.getUdpBroadcastTransportHolder().send(this.buffer, this.repeaterLocalAddress);
                logger.fine("Repeater registration message sent ok.");
            }
            catch (Throwable th) {
                logger.log(Level.FINE, th, () -> "Failed to send repeater registration message to: " + this.repeaterLocalAddress);
            }
        }
    }
}

