/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl;

import java.util.Properties;
import java.util.logging.Level;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.Validate;
import org.epics.ca.impl.ConfigurationReader;

@Immutable
public class LibraryConfiguration {
    public static final String CA_MONITOR_NOTIFIER_IMPL_DEFAULT = "BlockingQueueMultipleWorkerMonitorNotificationServiceImpl,16";
    public static final boolean CA_REPEATER_DISABLE_DEFAULT = false;
    public static final boolean CA_REPEATER_OUTPUT_CAPTURE_DEFAULT = false;
    public static final Level CA_REPEATER_LOG_LEVEL_DEFAULT = Level.INFO;
    public static final Level CA_LIBRARY_LOG_LEVEL_DEFAULT = Level.INFO;
    private static final LibraryConfiguration instance = new LibraryConfiguration(System.getProperties());
    private final Properties properties;

    private LibraryConfiguration(Properties properties) {
        this.properties = (Properties)Validate.notNull((Object)properties);
    }

    public static LibraryConfiguration getInstance() {
        return instance;
    }

    public String getMonitorNotifierImplementation() {
        return ConfigurationReader.readStringProperty(PropertyNames.CA_MONITOR_NOTIFIER_IMPL.toString(), this.properties, CA_MONITOR_NOTIFIER_IMPL_DEFAULT);
    }

    public boolean isRepeaterEnabled() {
        return !ConfigurationReader.readBooleanProperty(PropertyNames.CA_REPEATER_DISABLE.toString(), this.properties, false);
    }

    public boolean isRepeaterOutputCaptureEnabled() {
        return ConfigurationReader.readBooleanProperty(PropertyNames.CA_REPEATER_OUTPUT_CAPTURE.toString(), this.properties, false);
    }

    public Level getRepeaterLogLevel() {
        return ConfigurationReader.readDebugLevelProperty(PropertyNames.CA_REPEATER_LOG_LEVEL.toString(), this.properties, CA_REPEATER_LOG_LEVEL_DEFAULT);
    }

    public Level getLibraryLogLevel() {
        return ConfigurationReader.readDebugLevelProperty(PropertyNames.CA_LIBRARY_LOG_LEVEL.toString(), this.properties, CA_LIBRARY_LOG_LEVEL_DEFAULT);
    }

    public static enum PropertyNames {
        CA_MONITOR_NOTIFIER_IMPL,
        CA_REPEATER_DISABLE,
        CA_REPEATER_OUTPUT_CAPTURE,
        CA_REPEATER_LOG_LEVEL,
        CA_LIBRARY_LOG_LEVEL;

    }
}

