/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.monitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactory;
import org.epics.ca.impl.monitor.blockingqueue.BlockingQueueMonitorNotificationServiceFactory;
import org.epics.ca.impl.monitor.striped.StripedExecutorServiceMonitorNotificationServiceFactory;
import org.epics.ca.util.logging.LibraryLogManager;

public class MonitorNotificationServiceFactoryCreator
implements AutoCloseable {
    public static final String V1_1_0_DEFAULT_IMPL = ServiceImpl.BlockingQueueMultipleWorkerMonitorNotificationServiceImpl.name() + ",5";
    public static final String DEFAULT_IMPL = ServiceImpl.BlockingQueueMultipleWorkerMonitorNotificationServiceImpl.name() + ",16";
    public static final String HUMAN_CONSUMER_IMPL = (Object)((Object)ServiceImpl.BlockingQueueMultipleWorkerMonitorNotificationServiceImpl) + ",100,1";
    public static final String MACHINE_CONSUMER_IMPL = ServiceImpl.BlockingQueueMultipleWorkerMonitorNotificationServiceImpl.name() + ",100";
    public static final int NUMBER_OF_SERVICE_THREADS_DEFAULT = 10;
    public static final int NOTIFICATION_VALUE_BUFFER_SIZE_DEFAULT = Integer.MAX_VALUE;
    private static final Logger logger = LibraryLogManager.getLogger(MonitorNotificationServiceFactoryCreator.class);
    private static final List<MonitorNotificationServiceFactory> serviceFactoryList = new ArrayList<MonitorNotificationServiceFactory>();

    public static MonitorNotificationServiceFactory create(String serviceConfiguration) {
        MonitorNotificationServiceFactory serviceFactory;
        logger.finest(String.format("MonitorNotificationServiceFactoryCreator create method has been called with serviceImpl specifier: %s", serviceConfiguration));
        Validate.notEmpty((CharSequence)serviceConfiguration);
        String[] args = serviceConfiguration.split(",");
        Validate.isTrue((args.length >= 1 ? 1 : 0) != 0);
        Validate.isTrue((boolean)ServiceImpl.isRecognised(args[0]), (String)("The service configuration '" + args[0] + "' was not recognised."), (Object[])new Object[0]);
        ServiceImpl serviceImpl = ServiceImpl.valueOf(args[0]);
        switch (serviceImpl) {
            case StripedExecutorServiceMonitorNotificationServiceImpl: {
                int totalNumberOfServiceThreads = args.length == 2 ? NumberUtils.toInt((String)args[1], (int)10) : 10;
                serviceFactory = new StripedExecutorServiceMonitorNotificationServiceFactory(totalNumberOfServiceThreads);
                break;
            }
            case BlockingQueueSingleWorkerMonitorNotificationServiceImpl: {
                if (args.length >= 2) {
                    logger.info("Note: in this implementation the value for the number of notification threads will be ignored and set to 1.");
                }
                boolean totalNumberOfServiceThreads = true;
                int notificationValueBufferQueueSize = args.length == 3 ? NumberUtils.toInt((String)args[2], (int)Integer.MAX_VALUE) : Integer.MAX_VALUE;
                serviceFactory = new BlockingQueueMonitorNotificationServiceFactory(1, notificationValueBufferQueueSize);
                break;
            }
            default: {
                int totalNumberOfServiceThreads = args.length >= 2 ? NumberUtils.toInt((String)args[1], (int)10) : 10;
                int notificationValueBufferQueueSize = args.length == 3 ? NumberUtils.toInt((String)args[2], (int)Integer.MAX_VALUE) : Integer.MAX_VALUE;
                serviceFactory = new BlockingQueueMonitorNotificationServiceFactory(totalNumberOfServiceThreads, notificationValueBufferQueueSize);
            }
        }
        serviceFactoryList.add(serviceFactory);
        return serviceFactory;
    }

    @Override
    public void close() {
        logger.finer("MonitorNotificationServiceFactoryCreator close method has been called.");
        serviceFactoryList.forEach(MonitorNotificationServiceFactory::close);
        serviceFactoryList.clear();
        logger.finer("MonitorNotificationServiceFactoryCreator close method completed.");
    }

    public static List<String> getAllServiceImplementations() {
        return Arrays.stream(ServiceImpl.values()).map(Enum::toString).collect(Collectors.toList());
    }

    public static long getServiceCount() {
        return serviceFactoryList.stream().mapToInt(MonitorNotificationServiceFactory::getServiceCount).sum();
    }

    public static void shutdownExecutor(ExecutorService executorService) {
        logger.fine("Starting executor shutdown sequence for executor " + executorService);
        executorService.shutdown();
        try {
            logger.finer("Waiting up to 2 seconds for tasks to finish...");
            if (executorService.awaitTermination(2L, TimeUnit.SECONDS)) {
                logger.finer("Executor terminated ok.");
            } else {
                logger.finer("Executor did not yet terminate. Forcing termination...");
                List<Runnable> droppedTasks = executorService.shutdownNow();
                logger.finer("Executor was abruptly shutdown. " + droppedTasks.size() + " tasks will not be executed.");
                logger.finer("Termination forced. Waiting up to 2 seconds for tasks to finish...");
                executorService.awaitTermination(2L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException ex) {
            logger.warning("Interrupted whilst waiting for tasks to finish. Propagating interrupt.");
            Thread.currentThread().interrupt();
        }
        logger.fine("Executor shutdown sequence completed.");
    }

    static enum ServiceImpl {
        BlockingQueueSingleWorkerMonitorNotificationServiceImpl,
        BlockingQueueMultipleWorkerMonitorNotificationServiceImpl,
        StripedExecutorServiceMonitorNotificationServiceImpl;

        private static final ServiceImpl[] copyOfValues;

        public static boolean isRecognised(String name) {
            for (ServiceImpl value : copyOfValues) {
                if (!value.name().equals(name)) continue;
                return true;
            }
            return false;
        }

        static {
            copyOfValues = ServiceImpl.values();
        }
    }
}

