/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.monitor.blockingqueue;

import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang3.Validate;
import org.epics.ca.impl.TypeSupports;
import org.epics.ca.impl.monitor.MonitorNotificationService;
import org.epics.ca.impl.monitor.blockingqueue.MonitorNotificationTask;
import org.epics.ca.util.logging.LibraryLogManager;

@ThreadSafe
public class BlockingQueueMonitorNotificationService<T>
implements MonitorNotificationService<T>,
Supplier<T> {
    private static final Logger logger = LibraryLogManager.getLogger(BlockingQueueMonitorNotificationService.class);
    private final ThreadPoolExecutor executor;
    private final Consumer<? super T> consumer;
    private final BlockingQueue<T> valueQueue;
    private T deserializedValue;

    BlockingQueueMonitorNotificationService(ThreadPoolExecutor executor, BlockingQueue<T> valueQueue, Consumer<? super T> consumer) {
        this.executor = (ThreadPoolExecutor)Validate.notNull((Object)executor);
        this.valueQueue = (BlockingQueue)Validate.notNull(valueQueue);
        this.consumer = (Consumer)Validate.notNull(consumer);
        this.deserializedValue = null;
    }

    @Override
    public boolean publish(ByteBuffer dataBuffer, TypeSupports.TypeSupport<T> typeSupport, int dataCount) {
        this.deserializedValue = typeSupport.deserialize(dataBuffer, this.deserializedValue, dataCount);
        return this.publish(this.deserializedValue);
    }

    @Override
    public synchronized boolean publish(T value) {
        Validate.notNull(value);
        boolean overrun = false;
        if (!this.valueQueue.offer(value)) {
            logger.finest(String.format("Buffer is full [size is: %d]", this.valueQueue.size()));
            overrun = true;
            Object discardedValue = this.valueQueue.remove();
            logger.finest(String.format("Removing and throwing away oldest queue item, %s", discardedValue));
            this.valueQueue.add(value);
        } else {
            logger.finest(String.format("Added new item to buffer [size is: %d]", this.valueQueue.size()));
            logger.finest(String.format("Queueing Task for consumer '%s' on work queue '%s'. Latest value is: '%s'", this.consumer, this.executor.getQueue().hashCode(), value));
            this.executor.submit(new MonitorNotificationTask<T>(this.consumer, this));
        }
        return !overrun;
    }

    @Override
    public synchronized T get() {
        Validate.isTrue((!this.valueQueue.isEmpty() ? 1 : 0) != 0, (String)"programming error - value notification queue was unexpectedly empty", (Object[])new Object[0]);
        Object value = this.valueQueue.remove();
        logger.finest(String.format("Retrieved value '%s'", value));
        return (T)value;
    }

    @Override
    public void init() {
    }

    @Override
    public void close() {
        logger.finest("Closing monitor notification service for consumer.");
    }
}

