/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.impl.repeater.CARepeaterServiceInstance;
import org.epics.ca.util.logging.LibraryLogManager;

public class CARepeaterServiceManager {
    private static final Logger logger = LibraryLogManager.getLogger(CARepeaterServiceManager.class);
    private final Map<CARepeaterServiceInstance, Integer> serviceInterestMap = new HashMap<CARepeaterServiceInstance, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestServiceOnPort(int repeaterPort) {
        Class<CARepeaterServiceManager> clazz = CARepeaterServiceManager.class;
        synchronized (CARepeaterServiceManager.class) {
            logger.fine("Processing request for CA Repeater Services on port '" + repeaterPort + ".");
            int currentInterestLevel = this.getServiceInterestLevelForPort(repeaterPort);
            if (this.getServiceInterestLevelForPort(repeaterPort) == 0) {
                logger.fine("Starting the port " + repeaterPort + " CA Repeater Service instance.");
                CARepeaterServiceInstance serviceInstance = new CARepeaterServiceInstance(repeaterPort);
                this.serviceInterestMap.put(serviceInstance, 1);
                serviceInstance.activate();
            } else {
                logger.finer("Increasing the interest level in the port " + repeaterPort + " CA Repeater Service instance.");
                this.increaseServiceInterestLevelForPort(repeaterPort);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelServiceRequestOnPort(int repeaterPort) {
        Class<CARepeaterServiceManager> clazz = CARepeaterServiceManager.class;
        synchronized (CARepeaterServiceManager.class) {
            logger.fine("Processing request for cancellation of CA Repeater Services on port: '" + repeaterPort + "'.");
            int currentInterestLevel = this.getServiceInterestLevelForPort(repeaterPort);
            switch (currentInterestLevel) {
                case 0: {
                    logger.warning("The CA Repeater Service has received no previous service requests for port " + repeaterPort + ".");
                    break;
                }
                case 1: {
                    logger.fine("Shutting down the port " + repeaterPort + " CA Repeater Service instance.");
                    Optional<CARepeaterServiceInstance> optInstance = this.getServiceInstanceFor(repeaterPort);
                    Validate.validState((boolean)optInstance.isPresent());
                    this.serviceInterestMap.remove(optInstance.get());
                    optInstance.get().shutdown();
                    break;
                }
                default: {
                    logger.finer("Reducing the interest level in the port " + repeaterPort + " CA Repeater Service instance.");
                    this.reduceServiceInterestlevelForPort(repeaterPort);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    int getServiceInstances() {
        return this.serviceInterestMap.size();
    }

    private int getServiceInterestLevelForPort(int port) {
        Validate.inclusiveBetween((long)0L, (long)65535L, (long)port);
        Optional<Integer> currentInterestLevel = this.serviceInterestMap.entrySet().stream().filter(x -> ((CARepeaterServiceInstance)x.getKey()).getPort() == port).map(Map.Entry::getValue).findFirst();
        return currentInterestLevel.orElse(0);
    }

    private Optional<CARepeaterServiceInstance> getServiceInstanceFor(int port) {
        Validate.inclusiveBetween((long)0L, (long)65535L, (long)port);
        return this.serviceInterestMap.keySet().stream().filter(integer -> integer.getPort() == port).findFirst();
    }

    private void increaseServiceInterestLevelForPort(int port) {
        Validate.inclusiveBetween((long)0L, (long)65535L, (long)port);
        Optional<CARepeaterServiceInstance> instance = this.getServiceInstanceFor(port);
        Validate.validState((boolean)instance.isPresent());
        int currentInterestLevel = this.getServiceInterestLevelForPort(port);
        Validate.validState((currentInterestLevel >= 1 ? 1 : 0) != 0);
        int newInterestLevel = this.getServiceInterestLevelForPort(port) + 1;
        this.serviceInterestMap.put(instance.get(), newInterestLevel);
    }

    private void reduceServiceInterestlevelForPort(int port) {
        Validate.inclusiveBetween((long)0L, (long)65535L, (long)port);
        Optional<CARepeaterServiceInstance> instance = this.getServiceInstanceFor(port);
        Validate.validState((boolean)instance.isPresent());
        int currentInterestLevel = this.getServiceInterestLevelForPort(port);
        Validate.validState((currentInterestLevel >= 1 ? 1 : 0) != 0);
        int newInterestLevel = currentInterestLevel - 1;
        this.serviceInterestMap.put(instance.get(), newInterestLevel);
    }
}

