/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.util.logging.LibraryLogManager;

public class NetworkUtilities {
    private static final Logger logger = LibraryLogManager.getLogger(NetworkUtilities.class);

    public static boolean verifyTargetPlatformNetworkStackIsChannelAccessCompatible() {
        if (NetworkUtilities.verifyIpv4NetworkStackPreferred() && NetworkUtilities.verifyIpv6NetworkStackNotPreferred()) {
            logger.info("The network stack for this JVM is configured OK for channel access.");
            return true;
        }
        logger.warning("JVM Configuration Error: the network stack for this JVM is NOT configured appropriately for channel access.");
        if (!NetworkUtilities.verifyIpv4NetworkStackPreferred()) {
            logger.warning("Please ensure that the system property 'java.net.preferIPv4Stack' is set to true.");
        }
        if (!NetworkUtilities.verifyIpv6NetworkStackNotPreferred()) {
            logger.warning("Please ensure that the system property 'java.net.preferIPv6Stack' is set to false.");
        }
        return false;
    }

    public static boolean isVpnActive() {
        ArrayList addrList = new ArrayList();
        try {
            Enumeration<NetworkInterface> eni = NetworkInterface.getNetworkInterfaces();
            while (eni.hasMoreElements()) {
                NetworkInterface nif = eni.nextElement();
                if (!nif.isUp() || !nif.isPointToPoint()) continue;
                logger.warning("An active VPN has been detected wth name: '" + nif.getName() + "'.");
                return true;
            }
        }
        catch (SocketException e) {
            logger.warning("Exception when querying local interfaces for registered IP4 addresses.");
        }
        logger.info("An active VPN has NOT been detected.");
        return false;
    }

    static List<Inet4Address> getLocalNetworkInterfaceAddresses() {
        ArrayList<Inet4Address> addrList = new ArrayList<Inet4Address>();
        try {
            Enumeration<NetworkInterface> eni = NetworkInterface.getNetworkInterfaces();
            while (eni.hasMoreElements()) {
                NetworkInterface nif = eni.nextElement();
                logger.finest("name: " + nif.getName());
                logger.finest("- isUp: " + nif.isUp());
                logger.finest("- isPointToPoint: " + nif.isPointToPoint());
                logger.finest("- isVirtual: " + nif.isVirtual());
                logger.finest("- supportsMulticast: " + nif.supportsMulticast());
                logger.finest("- isLoopback: " + nif.isLoopback());
                logger.finest("- if addresses: ");
                for (InterfaceAddress ifAddr : nif.getInterfaceAddresses()) {
                    InetAddress inetAddress = ifAddr.getAddress();
                    logger.finest("  - addr: " + inetAddress);
                    logger.finest("  - subnetMask: " + ifAddr.getNetworkPrefixLength());
                    logger.finest("  - broadcast: " + ifAddr.getBroadcast());
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    Inet4Address inet4Address = (Inet4Address)inetAddress;
                    addrList.add(inet4Address);
                }
                logger.finest("");
            }
        }
        catch (SocketException e) {
            logger.warning("Exception when querying local interfaces for registered IP4 addresses.");
        }
        return addrList;
    }

    static List<Inet4Address> getLocalBroadcastAddresses() {
        ArrayList<Inet4Address> addrList = new ArrayList<Inet4Address>();
        try {
            Enumeration<NetworkInterface> eni = NetworkInterface.getNetworkInterfaces();
            while (eni.hasMoreElements()) {
                NetworkInterface nif = eni.nextElement();
                for (InterfaceAddress ifAddr : nif.getInterfaceAddresses()) {
                    InetAddress inetAddress = ifAddr.getBroadcast();
                    if (inetAddress == null) continue;
                    addrList.add((Inet4Address)inetAddress);
                }
            }
        }
        catch (SocketException e) {
            logger.warning("Exception when querying local interfaces for registered IP4 addresses.");
        }
        return addrList;
    }

    static boolean isThisMyIpAddress(InetAddress addr) {
        Validate.notNull((Object)addr);
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    private static boolean verifyIpv4NetworkStackPreferred() {
        String propertyName = "java.net.preferIPv4Stack";
        logger.finest("The property: 'java.net.preferIPv4Stack' is set to: '" + System.getProperty("java.net.preferIPv4Stack") + "'.");
        boolean result = System.getProperty("java.net.preferIPv4Stack", "false").equals("true");
        logger.finest("verifyIpv4NetworkStackPreferred is set to: '" + result + "'.");
        return result;
    }

    private static boolean verifyIpv6NetworkStackNotPreferred() {
        String propertyName = "java.net.preferIPv6Stack";
        logger.finest("The property: 'java.net.preferIPv6Stack' is set to: '" + System.getProperty("java.net.preferIPv6Stack") + "'.");
        boolean result = System.getProperty("java.net.preferIPv6Stack", "false").equals("false");
        logger.finest("verifyIpv6NetworkStackNotPreferred is set to: '" + result + "'.");
        return result;
    }
}

