/*
 * Copyright (c) 2004 by Cosylab
 *
 * The full license specifying the redistribution, modification, usage and other
 * rights and obligations is included with the distribution of this project in
 * the file "LICENSE-CAJ". If the license is not included visit Cosylab web site,
 * <http://www.cosylab.com>.
 *
 * THIS SOFTWARE IS PROVIDED AS-IS WITHOUT WARRANTY OF ANY KIND, NOT EVEN THE
 * IMPLIED WARRANTY OF MERCHANTABILITY. THE AUTHOR OF THIS SOFTWARE, ASSUMES
 * _NO_ RESPONSIBILITY FOR ANY CONSEQUENCE RESULTING FROM THE USE, MODIFICATION,
 * OR REDISTRIBUTION OF THIS SOFTWARE.
 */

package com.cosylab.epics.caj.cas.requests;

import java.nio.ByteBuffer;

import com.cosylab.epics.caj.impl.Request;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.requests.AbstractCARequest;

/**
 * CA echo response.
 * @author <a href="mailto:matej.sekoranjaATcosylab.com">Matej Sekoranja</a>
 * @version $id$
 */
public class EchoRequest extends AbstractCARequest {

	/**
	 * @param transport
	 */
	public EchoRequest(Transport transport, ByteBuffer headerBuffer, ByteBuffer payloadBuffer) {
		super(transport);
		
		// calculate message size
		int capacity = headerBuffer.remaining();
		if (payloadBuffer != null)
			capacity += payloadBuffer.remaining();
		
		// create and copy
		requestMessage = ByteBuffer.allocate(capacity);
		requestMessage.put(headerBuffer);
		if (payloadBuffer != null)
			requestMessage.put(payloadBuffer);

	}

	/**
	 * @see com.cosylab.epics.caj.impl.Request#getPriority()
	 */
	public byte getPriority() {
		return Request.SEND_IMMEDIATELY_PRIORITY;
	}

}
