/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj;

import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.CAJMonitor;
import com.cosylab.epics.caj.impl.CATransport;
import com.cosylab.epics.caj.impl.ResponseRequest;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.TransportClient;
import com.cosylab.epics.caj.impl.requests.ClearChannelRequest;
import com.cosylab.epics.caj.impl.requests.CreateChannelRequest;
import com.cosylab.epics.caj.impl.requests.EventAddRequest;
import com.cosylab.epics.caj.impl.requests.ReadNotifyRequest;
import com.cosylab.epics.caj.impl.requests.SearchRequest;
import com.cosylab.epics.caj.impl.requests.WriteNotifyRequest;
import com.cosylab.epics.caj.impl.requests.WriteRequest;
import gov.aps.jca.CAException;
import gov.aps.jca.CAStatus;
import gov.aps.jca.Channel;
import gov.aps.jca.Context;
import gov.aps.jca.Monitor;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRFactory;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.Severity;
import gov.aps.jca.event.AccessRightsEvent;
import gov.aps.jca.event.AccessRightsListener;
import gov.aps.jca.event.ConnectionEvent;
import gov.aps.jca.event.ConnectionListener;
import gov.aps.jca.event.GetListener;
import gov.aps.jca.event.MonitorListener;
import gov.aps.jca.event.PutListener;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CAJChannel
extends Channel
implements TransportClient {
    protected int channelID;
    protected CAJContext context;
    protected String name;
    protected int accessRights = 0;
    protected short priority;
    protected boolean lastReportedConnectionState = false;
    protected Channel.ConnectionState connectionState = Channel.ConnectionState.NEVER_CONNECTED;
    protected DBRType type = DBRType.UNKNOWN;
    protected int elementCount = 0;
    protected ArrayList connectionListeners = new ArrayList();
    protected ArrayList accessRightsListeners = new ArrayList();
    protected boolean syncConnection = false;
    protected int sequenceNumberIO;
    protected Map monitors = null;
    protected Map responseRequests = new HashMap();
    protected int searchTries = 0;
    protected boolean allowCreation = true;
    protected int references = 1;
    protected CATransport transport = null;
    protected int serverChannelID = -1;
    protected volatile boolean canceled = false;
    protected Object ownerLock = new Object();
    protected List owner = null;
    protected int ownerIndex = -1;

    protected CAJChannel(CAJContext context, int channelID, String name, ConnectionListener listener, short priority) throws CAException {
        this.context = context;
        this.channelID = channelID;
        this.name = name;
        this.priority = priority;
        context.registerChannel(this);
        if (listener != null) {
            this.addConnectionListener(listener);
        } else {
            this.syncConnection = true;
            this.sequenceNumberIO = context.incrementPendingRequests();
        }
        this.initiateSearch();
    }

    public synchronized void createChannel(CATransport transport, int sid, short typeCode, int elementCount) {
        if (!this.allowCreation) {
            return;
        }
        this.allowCreation = false;
        if (this.transport != null && this.transport != transport) {
            this.disconnectPendingIO(false);
            this.transport.release(this);
        } else if (this.transport == transport) {
            return;
        }
        this.transport = transport;
        if (transport.getMinorRevision() < 4) {
            this.serverChannelID = sid;
            this.type = DBRType.forValue((int)typeCode);
            if (this.type == null) {
                this.type = DBRType.UNKNOWN;
            }
            this.elementCount = elementCount;
        }
        try {
            new CreateChannelRequest(transport, this.name, this.channelID).submit();
        }
        catch (IOException ioex) {
            this.createChannelFailed();
        }
    }

    public synchronized void cancel() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        if (this.syncConnection) {
            this.syncConnection = false;
            this.context.decrementPendingRequests(this.sequenceNumberIO);
        }
    }

    public void timeout() {
        this.createChannelFailed();
    }

    public synchronized void createChannelFailed() {
        this.cancel();
        this.initiateSearch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connectionCompleted(int sid, short typeCode, int elementCount) throws IllegalStateException {
        try {
            if (this.connectionState == Channel.ConnectionState.CLOSED) {
                return;
            }
            if (this.transport.getMinorRevision() < 1) {
                this.setAccessRights(3);
            }
            if (this.transport.getMinorRevision() >= 4) {
                this.serverChannelID = sid;
            }
            this.type = DBRType.forValue((int)typeCode);
            if (this.type == null) {
                this.type = DBRType.UNKNOWN;
            }
            this.elementCount = elementCount;
            this.resubscribeSubscriptions();
            this.setConnectionState(Channel.ConnectionState.CONNECTED);
        }
        finally {
            this.cancel();
        }
    }

    public synchronized void destroy() throws CAException, IllegalStateException {
        this.destroy(false);
    }

    public synchronized void destroy(boolean force) throws CAException, IllegalStateException {
        if (this.connectionState == Channel.ConnectionState.CLOSED) {
            throw new IllegalStateException("Channel already destroyed.");
        }
        this.context.destroyChannel(this, force);
    }

    public synchronized void acquire() {
        ++this.references;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroyChannel(boolean force) throws CAException, IllegalStateException, IOException {
        if (this.connectionState == Channel.ConnectionState.CLOSED) {
            throw new IllegalStateException("Channel already destroyed.");
        }
        --this.references;
        if (this.references > 0 && !force) {
            return;
        }
        this.context.getChannelSearchManager().unregisterChannel(this);
        this.cancel();
        this.destroyAllMonitors();
        this.disconnectPendingIO(true);
        if (this.connectionState == Channel.ConnectionState.CONNECTED) {
            if (this.transport != null) {
                try {
                    new ClearChannelRequest(this.transport, this.channelID, this.serverChannelID).submit();
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                }
            }
            this.disconnect(false);
        } else if (this.transport != null) {
            this.transport.release(this);
            this.transport = null;
        }
        this.setConnectionState(Channel.ConnectionState.CLOSED);
        this.context.unregisterChannel(this);
        ArrayList arrayList = this.accessRightsListeners;
        synchronized (arrayList) {
            this.accessRightsListeners.clear();
        }
    }

    public synchronized void disconnect(boolean initiateSearch) {
        if (this.connectionState != Channel.ConnectionState.CONNECTED && this.transport == null) {
            return;
        }
        this.setConnectionState(Channel.ConnectionState.DISCONNECTED);
        this.disconnectPendingIO(false);
        if (this.transport != null) {
            this.transport.release(this);
            this.transport = null;
        }
        if (initiateSearch) {
            this.initiateSearch();
        }
    }

    public synchronized void initiateSearch() {
        this.allowCreation = true;
        this.context.getChannelSearchManager().registerChannel(this);
    }

    public synchronized boolean generateSearchRequestMessage(Transport transport, ByteBuffer buffer) {
        ByteBuffer result = SearchRequest.generateSearchRequestMessage(transport, buffer, this.name, this.channelID);
        if (result == null) {
            return false;
        }
        if (this.searchTries < Integer.MAX_VALUE) {
            ++this.searchTries;
        }
        return true;
    }

    public void transportClosed() {
        this.disconnect(true);
    }

    public void transportChanged() {
        this.initiateSearch();
    }

    public synchronized void transportResponsive(Transport transport) {
        if (this.connectionState == Channel.ConnectionState.DISCONNECTED) {
            this.updateSubscriptions();
            this.connectionCompleted(this.serverChannelID, (short)this.type.getValue(), this.elementCount);
        }
    }

    public synchronized void transportUnresponsive() {
        if (this.connectionState == Channel.ConnectionState.CONNECTED) {
            this.setConnectionState(Channel.ConnectionState.DISCONNECTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionListener[] getConnectionListeners() throws IllegalStateException {
        ArrayList arrayList = this.connectionListeners;
        synchronized (arrayList) {
            ConnectionListener[] listeners = new ConnectionListener[this.connectionListeners.size()];
            return this.connectionListeners.toArray(listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener l) throws CAException, IllegalStateException {
        this.checkNotClosedState();
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        ArrayList arrayList = this.connectionListeners;
        synchronized (arrayList) {
            if (!this.connectionListeners.contains(l)) {
                this.connectionListeners.add(l);
            }
        }
    }

    public synchronized void addConnectionListenerAndFireIfConnected(ConnectionListener l) throws CAException, IllegalStateException {
        this.checkNotClosedState();
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        if (this.connectionState == Channel.ConnectionState.CONNECTED) {
            this.context.getEventDispatcher().dispatch(new ConnectionEvent((Channel)this, true), l);
        }
        this.addConnectionListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener l) throws CAException, IllegalStateException {
        this.checkNotClosedState();
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        ArrayList arrayList = this.connectionListeners;
        synchronized (arrayList) {
            this.connectionListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setConnectionState(Channel.ConnectionState connectionState) {
        if (this.connectionState != connectionState) {
            boolean connectionStatusToReport;
            this.connectionState = connectionState;
            boolean bl = connectionStatusToReport = connectionState == Channel.ConnectionState.CONNECTED;
            if (connectionStatusToReport != this.lastReportedConnectionState) {
                this.lastReportedConnectionState = connectionStatusToReport;
                ArrayList arrayList = this.connectionListeners;
                synchronized (arrayList) {
                    this.context.getEventDispatcher().dispatch(new ConnectionEvent((Channel)this, connectionStatusToReport), (List)this.connectionListeners);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessRightsListener[] getAccessRightsListeners() throws IllegalStateException {
        ArrayList arrayList = this.accessRightsListeners;
        synchronized (arrayList) {
            AccessRightsListener[] listeners = new AccessRightsListener[this.accessRightsListeners.size()];
            return this.accessRightsListeners.toArray(listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccessRightsListener(AccessRightsListener l) throws CAException, IllegalStateException {
        this.checkNotClosedState();
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        ArrayList arrayList = this.accessRightsListeners;
        synchronized (arrayList) {
            if (!this.accessRightsListeners.contains(l)) {
                this.accessRightsListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccessRightsListener(AccessRightsListener l) throws CAException, IllegalStateException {
        this.checkNotClosedState();
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        ArrayList arrayList = this.accessRightsListeners;
        synchronized (arrayList) {
            this.accessRightsListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setAccessRights(int accessRights) {
        if (this.accessRights != accessRights) {
            this.accessRights = accessRights;
            boolean readAccess = (accessRights & 1) != 0;
            boolean writeAccess = (accessRights & 2) != 0;
            ArrayList arrayList = this.accessRightsListeners;
            synchronized (arrayList) {
                this.context.getEventDispatcher().dispatch(new AccessRightsEvent((Channel)this, readAccess, writeAccess), (List)this.accessRightsListeners);
            }
        }
    }

    public String getName() throws IllegalStateException {
        return this.name;
    }

    public synchronized DBRType getFieldType() throws IllegalStateException {
        this.checkState();
        return this.type;
    }

    public synchronized int getElementCount() throws IllegalStateException {
        this.checkState();
        return this.elementCount;
    }

    public synchronized Channel.ConnectionState getConnectionState() throws IllegalStateException {
        return this.connectionState;
    }

    public synchronized String getHostName() throws IllegalStateException {
        this.connectionRequiredCheck();
        return this.transport.getRemoteAddress().getHostName();
    }

    public synchronized boolean getReadAccess() throws IllegalStateException {
        this.checkState();
        return (this.accessRights & 1) != 0;
    }

    public synchronized boolean getWriteAccess() throws IllegalStateException {
        this.checkState();
        return (this.accessRights & 2) != 0;
    }

    public void put(byte[] value) throws CAException, IllegalStateException {
        this.put(DBRType.BYTE, value.length, value);
    }

    public void put(byte[] value, PutListener l) throws CAException, IllegalStateException {
        this.put(DBRType.BYTE, value.length, value, l);
    }

    public void put(short[] value) throws CAException, IllegalStateException {
        this.put(DBRType.SHORT, value.length, value);
    }

    public void put(short[] value, PutListener l) throws CAException, IllegalStateException {
        this.put(DBRType.SHORT, value.length, value, l);
    }

    public void put(int[] value) throws CAException, IllegalStateException {
        this.put(DBRType.INT, value.length, value);
    }

    public void put(int[] value, PutListener l) throws CAException, IllegalStateException {
        this.put(DBRType.INT, value.length, value, l);
    }

    public void put(float[] value) throws CAException, IllegalStateException {
        this.put(DBRType.FLOAT, value.length, value);
    }

    public void put(float[] value, PutListener l) throws CAException, IllegalStateException {
        this.put(DBRType.FLOAT, value.length, value, l);
    }

    public void put(double[] value) throws CAException, IllegalStateException {
        this.put(DBRType.DOUBLE, value.length, value);
    }

    public void put(double[] value, PutListener l) throws CAException, IllegalStateException {
        this.put(DBRType.DOUBLE, value.length, value, l);
    }

    public void put(String[] value) throws CAException, IllegalStateException {
        this.put(DBRType.STRING, value.length, value);
    }

    public void put(String[] value, PutListener l) throws CAException, IllegalStateException {
        this.put(DBRType.STRING, value.length, value, l);
    }

    public void putACKS(Severity severity, PutListener l) throws CAException, IllegalStateException {
        this.put(DBRType.PUT_ACKS, 1, new short[]{(short)severity.getValue()}, l);
    }

    public void putACKS(Severity severity) throws CAException, IllegalStateException {
        this.put(DBRType.PUT_ACKS, 1, new short[]{(short)severity.getValue()});
    }

    public void putACKT(boolean value, PutListener l) throws CAException, IllegalStateException {
        this.put(DBRType.PUT_ACKT, 1, new short[]{value ? (short)1 : 0}, l);
    }

    public void putACKT(boolean value) throws CAException, IllegalStateException {
        this.put(DBRType.PUT_ACKT, 1, new short[]{value ? (short)1 : 0});
    }

    public DBR get(DBRType type, int count) throws CAException, IllegalStateException {
        this.connectionRequiredCheck();
        if (!this.getReadAccess()) {
            throw new CAException("No read access rights granted.");
        }
        CATransport t = this.getTransport();
        if (t != null) {
            try {
                DBR retVal = DBRFactory.create((DBRType)type, (int)count);
                new ReadNotifyRequest(this, null, retVal, t, this.getServerChannelID(), type.getValue(), count).submit();
                return retVal;
            }
            catch (IOException ioex) {
                throw new CAException("Failed to retrieve value.", (Throwable)ioex);
            }
        }
        throw new IllegalStateException("No channel transport available, channel disconnected.");
    }

    public void get(DBRType type, int count, GetListener l) throws CAException, IllegalStateException {
        this.connectionRequiredCheck();
        if (!this.getReadAccess()) {
            throw new CAException("No read access rights granted.");
        }
        CATransport t = this.getTransport();
        if (t != null) {
            try {
                new ReadNotifyRequest(this, l, null, t, this.getServerChannelID(), type.getValue(), count).submit();
            }
            catch (IOException ioex) {
                throw new CAException("Failed to retrieve value.", (Throwable)ioex);
            }
        } else {
            throw new IllegalStateException("No channel transport available, channel disconnected.");
        }
    }

    public void put(DBRType type, int count, Object value) throws CAException, IllegalStateException {
        this.connectionRequiredCheck();
        if (!this.getWriteAccess()) {
            throw new CAException("No write access rights granted.");
        }
        CATransport t = this.getTransport();
        if (t != null) {
            try {
                new WriteRequest(this, t, this.getServerChannelID(), this.channelID, type.getValue(), count, value).submit();
            }
            catch (IOException ioex) {
                throw new CAException("Failed to set value.", (Throwable)ioex);
            }
        } else {
            throw new IllegalStateException("No channel transport available, channel disconnected.");
        }
    }

    public void put(DBRType type, int count, Object value, PutListener l) throws CAException, IllegalStateException {
        this.connectionRequiredCheck();
        if (!this.getWriteAccess()) {
            throw new CAException("No write access rights granted.");
        }
        CATransport t = this.getTransport();
        if (t != null) {
            try {
                if (l == null) {
                    new WriteRequest(this, t, this.getServerChannelID(), this.channelID, type.getValue(), count, value).submit();
                }
                new WriteNotifyRequest(this, l, t, this.getServerChannelID(), type.getValue(), count, value).submit();
            }
            catch (IOException ioex) {
                throw new CAException("Failed to set value.", (Throwable)ioex);
            }
        } else {
            throw new IllegalStateException("No channel transport available, channel disconnected.");
        }
    }

    public synchronized Monitor addMonitor(DBRType type, int count, int mask, MonitorListener l) throws CAException, IllegalStateException {
        this.checkNotClosedState();
        return new CAJMonitor(this.context, type, count, this, l, mask);
    }

    public int getChannelID() {
        return this.channelID;
    }

    public Context getContext() throws IllegalStateException {
        return this.context;
    }

    private void connectionRequiredCheck() {
        if (this.connectionState != Channel.ConnectionState.CONNECTED) {
            throw new IllegalStateException("Channel not connected.");
        }
    }

    private void checkState() {
        if (this.connectionState != Channel.ConnectionState.CONNECTED && this.connectionState != Channel.ConnectionState.DISCONNECTED) {
            throw new IllegalStateException("Channel not in connected or disconnected state, state = '" + this.connectionState.getName() + "'.");
        }
    }

    private void checkNotClosedState() {
        if (this.connectionState == Channel.ConnectionState.CLOSED) {
            throw new IllegalStateException("Channel closed.");
        }
    }

    public synchronized void printInfo(PrintStream out) throws IllegalStateException {
        if (this.connectionState != Channel.ConnectionState.CONNECTED) {
            out.println("CHANNEL  : " + this.name);
            out.println("TYPE     : " + this.type);
            out.println("COUNT    : " + this.elementCount);
            out.println("STATE    : " + this.connectionState);
        } else {
            super.printInfo(out);
        }
    }

    public synchronized CATransport getTransport() {
        return this.transport;
    }

    public synchronized int getServerChannelID() {
        return this.serverChannelID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerMonitor(CAJMonitor monitor) {
        Object object;
        if (this.monitors == null) {
            object = this;
            synchronized (object) {
                if (this.monitors == null) {
                    this.monitors = new HashMap();
                }
            }
        }
        object = this.monitors;
        synchronized (object) {
            this.monitors.put(new Integer(monitor.getSID()), monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterMonitor(CAJMonitor monitor) {
        if (this.monitors == null) {
            return;
        }
        Map map = this.monitors;
        synchronized (map) {
            this.monitors.remove(new Integer(monitor.getSID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAllMonitors() {
        CAJMonitor[] monitorsArray;
        if (this.monitors == null) {
            return;
        }
        Map map = this.monitors;
        synchronized (map) {
            monitorsArray = new CAJMonitor[this.monitors.size()];
            this.monitors.values().toArray(monitorsArray);
            this.monitors.clear();
        }
        for (int i = 0; i < monitorsArray.length; ++i) {
            try {
                monitorsArray[i].clear();
                continue;
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResponseRequest(ResponseRequest responseRequest) {
        Map map = this.responseRequests;
        synchronized (map) {
            this.responseRequests.put(responseRequest, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterResponseRequest(ResponseRequest responseRequest) {
        Map map = this.responseRequests;
        synchronized (map) {
            this.responseRequests.remove(responseRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectPendingIO(boolean destroy) {
        CAStatus status = destroy ? CAStatus.CHANDESTROY : CAStatus.DISCONN;
        Map map = this.responseRequests;
        synchronized (map) {
            ResponseRequest[] rrs = new ResponseRequest[this.responseRequests.size()];
            this.responseRequests.keySet().toArray(rrs);
            for (int i = 0; i < rrs.length; ++i) {
                try {
                    rrs[i].exception(status.getStatusCode(), null);
                    continue;
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resubscribeSubscriptions() {
        Map map = this.responseRequests;
        synchronized (map) {
            CATransport transport = this.getTransport();
            ResponseRequest[] rrs = new ResponseRequest[this.responseRequests.size()];
            this.responseRequests.keySet().toArray(rrs);
            for (int i = 0; i < rrs.length; ++i) {
                try {
                    if (!(rrs[i] instanceof EventAddRequest)) continue;
                    EventAddRequest ear = (EventAddRequest)rrs[i];
                    ear.resubscribeSubscription(transport);
                    continue;
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSubscriptions() {
        Map map = this.responseRequests;
        synchronized (map) {
            ResponseRequest[] rrs = new ResponseRequest[this.responseRequests.size()];
            this.responseRequests.keySet().toArray(rrs);
            for (int i = 0; i < rrs.length; ++i) {
                try {
                    if (!(rrs[i] instanceof EventAddRequest)) continue;
                    EventAddRequest ear = (EventAddRequest)rrs[i];
                    ear.updateSubscription();
                    continue;
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
    }

    public int getSearchTries() {
        return this.searchTries;
    }

    public short getPriority() {
        return this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetListOwnership() {
        Object object = this.ownerLock;
        synchronized (object) {
            this.owner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndSetListOwnership(List newOwner, int index) {
        List list = newOwner;
        synchronized (list) {
            Object object = this.ownerLock;
            synchronized (object) {
                newOwner.add(this);
                this.owner = newOwner;
                this.ownerIndex = index;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAndUnsetListOwnership() {
        if (this.owner == null) {
            return;
        }
        List list = this.owner;
        synchronized (list) {
            Object object = this.ownerLock;
            synchronized (object) {
                if (this.owner != null) {
                    this.owner.remove(this);
                    this.owner = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getOwnerIndex() {
        Object object = this.ownerLock;
        synchronized (object) {
            return this.ownerIndex;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " = { name = " + this.name + ", connectionState = " + this.connectionState.getName() + " }";
    }
}

