/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl;

import gov.aps.jca.dbr.ACK;
import gov.aps.jca.dbr.CTRL;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.GR;
import gov.aps.jca.dbr.LABELS;
import gov.aps.jca.dbr.PRECISION;
import gov.aps.jca.dbr.STS;
import gov.aps.jca.dbr.Severity;
import gov.aps.jca.dbr.Status;
import gov.aps.jca.dbr.TIME;
import gov.aps.jca.dbr.TimeStamp;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;

public class DBREncoder {
    private static final int[] PAYLOAD_SIZE = new int[]{0, 0, 0, 0, 0, 0, 0, 4, 4, 4, 4, 5, 4, 8, 12, 14, 12, 14, 15, 12, 16, 4, 24, 40, 422, 19, 36, 64, 4, 28, 48, 422, 21, 44, 80, 0, 0, 8};

    public static int calculatePayloadSize(short dataTypeValue, int dataCount, Object value) {
        DBRType dataType = DBRType.forValue((int)dataTypeValue);
        if (dataType == null) {
            throw new IllegalArgumentException("Invalid data type value: " + dataTypeValue);
        }
        int additionalPayload = PAYLOAD_SIZE[dataTypeValue];
        return DBREncoder.calculateValuePayloadSize(dataCount, value, dataType) + additionalPayload;
    }

    private static int calculateValuePayloadSize(int dataCount, Object value, DBRType dataType) {
        if (dataType.isDOUBLE()) {
            return dataCount * 8;
        }
        if (dataType.isINT()) {
            return dataCount * 4;
        }
        if (dataType.isSTRING()) {
            if (dataCount == 1) {
                String str = ((String[])value)[0];
                if (str != null) {
                    return str.length() + 1;
                }
                return 1;
            }
            return dataCount * 40;
        }
        if (dataType.isSHORT()) {
            return dataCount * 2;
        }
        if (dataType.isFLOAT()) {
            return dataCount * 4;
        }
        if (dataType.isENUM()) {
            return dataCount * 2;
        }
        if (dataType.isBYTE()) {
            return dataCount * 1;
        }
        if (dataType == DBRType.PUT_ACKT || dataType == DBRType.PUT_ACKS) {
            return dataCount * 2;
        }
        throw new IllegalArgumentException("Unsupported data type: " + dataType);
    }

    public static void insertPayload(ByteBuffer payloadBuffer, short dataTypeValue, int dataCount, Object value) {
        DBRType dataType = DBRType.forValue((int)dataTypeValue);
        if (dataType == null) {
            throw new IllegalArgumentException("Invalid data type value: " + dataTypeValue);
        }
        int count = Math.min(Array.getLength(value), dataCount);
        if (dataType.isDOUBLE()) {
            double[] array = (double[])value;
            for (int i = 0; i < count; ++i) {
                payloadBuffer.putDouble(array[i]);
            }
        } else if (dataType.isINT()) {
            int[] array = (int[])value;
            for (int i = 0; i < count; ++i) {
                payloadBuffer.putInt(array[i]);
            }
        } else if (dataType.isSTRING()) {
            String[] array = (String[])value;
            if (count == 1) {
                if (array.length > 0 && array[0] != null) {
                    payloadBuffer.put(array[0].getBytes());
                }
                payloadBuffer.put((byte)0);
            } else {
                for (int i = 0; i < count; ++i) {
                    int pos = payloadBuffer.position();
                    if (array[i] != null) {
                        int bytesToWrite = Math.min(array[i].length(), 39);
                        payloadBuffer.put(array[i].getBytes(), 0, bytesToWrite);
                    }
                    payloadBuffer.put((byte)0);
                    payloadBuffer.position(pos + 40);
                }
            }
        } else if (dataType.isSHORT()) {
            short[] array = (short[])value;
            for (int i = 0; i < count; ++i) {
                payloadBuffer.putShort(array[i]);
            }
        } else if (dataType.isFLOAT()) {
            float[] array = (float[])value;
            for (int i = 0; i < count; ++i) {
                payloadBuffer.putFloat(array[i]);
            }
        } else if (dataType.isENUM()) {
            short[] array = (short[])value;
            for (int i = 0; i < count; ++i) {
                payloadBuffer.putShort(array[i]);
            }
        } else if (dataType.isBYTE()) {
            byte[] array = (byte[])value;
            for (int i = 0; i < count; ++i) {
                payloadBuffer.put(array[i]);
            }
        } else if (dataType == DBRType.PUT_ACKT || dataType == DBRType.PUT_ACKS) {
            short[] array = (short[])value;
            for (int i = 0; i < count; ++i) {
                payloadBuffer.putShort(array[i]);
            }
        } else {
            throw new IllegalArgumentException("Unsupported data type: " + dataType);
        }
    }

    public static void insertPayload(ByteBuffer payloadBuffer, short dataTypeValue, int dataCount, DBR value) {
        DBRType dataType = DBRType.forValue((int)dataTypeValue);
        if (dataType == null) {
            throw new IllegalArgumentException("Invalid data type value: " + dataTypeValue);
        }
        if (dataType.isSTS()) {
            STS sts = (STS)value;
            Status status = sts.getStatus();
            if (status == null) {
                payloadBuffer.putShort((short)Status.UDF_ALARM.getValue());
            } else {
                payloadBuffer.putShort((short)status.getValue());
            }
            Severity severity = sts.getSeverity();
            if (severity == null) {
                payloadBuffer.putShort((short)Severity.INVALID_ALARM.getValue());
            } else {
                payloadBuffer.putShort((short)severity.getValue());
            }
        }
        if (dataType == DBRType.STSACK_STRING) {
            ACK ack = (ACK)value;
            payloadBuffer.putShort(ack.getAckT() ? (short)1 : 0);
            Severity severity = ack.getAckS();
            if (severity == null) {
                payloadBuffer.putShort((short)Severity.INVALID_ALARM.getValue());
            } else {
                payloadBuffer.putShort((short)severity.getValue());
            }
        } else if (dataType.isLABELS()) {
            LABELS labels = (LABELS)value;
            String[] labelsArray = labels.getLabels();
            int count = labelsArray != null ? labelsArray.length : 0;
            payloadBuffer.putShort((short)count);
            int MAX_ENUM_STRING_SIZE = 26;
            int MAX_ENUM_STATES = 16;
            byte[] EMPTY_LABEL = new byte[26];
            for (int i = 0; i < count; ++i) {
                String label = labelsArray[i];
                if (label == null) {
                    payloadBuffer.put(EMPTY_LABEL);
                    continue;
                }
                int labelLen = label.length();
                if (labelLen >= 26) {
                    labelLen = 15;
                    label = label.substring(0, labelLen);
                }
                payloadBuffer.put(label.getBytes());
                for (int j = labelLen; j < 26; ++j) {
                    payloadBuffer.put((byte)0);
                }
            }
            int labelsLeft = 16 - count;
            for (int i = 0; i < labelsLeft; ++i) {
                payloadBuffer.put(EMPTY_LABEL);
            }
        } else {
            if (dataType == DBRType.STS_BYTE) {
                payloadBuffer.put((byte)0);
            } else if (dataType == DBRType.STS_DOUBLE) {
                payloadBuffer.putInt(0);
            }
            if (dataType.isTIME() && !dataType.isGR() && dataTypeValue != 21 && dataTypeValue != 28) {
                TIME time = (TIME)value;
                TimeStamp ts = time.getTimeStamp();
                if (ts == null) {
                    payloadBuffer.putInt(0);
                    payloadBuffer.putInt(0);
                } else {
                    payloadBuffer.putInt((int)ts.secPastEpoch());
                    payloadBuffer.putInt((int)ts.nsec());
                }
            }
            if (dataType == DBRType.TIME_SHORT || dataType == DBRType.TIME_ENUM) {
                payloadBuffer.putShort((short)0);
            } else if (dataType == DBRType.TIME_BYTE) {
                payloadBuffer.putShort((short)0);
                payloadBuffer.put((byte)0);
            } else if (dataType == DBRType.TIME_DOUBLE) {
                payloadBuffer.putInt(0);
            }
            if (dataType.isGR()) {
                int zeros;
                if (dataType.isPRECISION()) {
                    PRECISION precision = (PRECISION)value;
                    payloadBuffer.putShort(precision.getPrecision());
                    payloadBuffer.putShort((short)0);
                }
                GR gr = (GR)value;
                String units = gr.getUnits();
                payloadBuffer.put(units.getBytes());
                int MAX_UNITS_SIZE = 8;
                for (int i = zeros = 8 - units.length(); i > 0; --i) {
                    payloadBuffer.put((byte)0);
                }
                if (dataType.isSHORT()) {
                    payloadBuffer.putShort(gr.getUpperDispLimit().shortValue());
                    payloadBuffer.putShort(gr.getLowerDispLimit().shortValue());
                    payloadBuffer.putShort(gr.getUpperAlarmLimit().shortValue());
                    payloadBuffer.putShort(gr.getUpperWarningLimit().shortValue());
                    payloadBuffer.putShort(gr.getLowerWarningLimit().shortValue());
                    payloadBuffer.putShort(gr.getLowerAlarmLimit().shortValue());
                } else if (dataType.isFLOAT()) {
                    payloadBuffer.putFloat(gr.getUpperDispLimit().floatValue());
                    payloadBuffer.putFloat(gr.getLowerDispLimit().floatValue());
                    payloadBuffer.putFloat(gr.getUpperAlarmLimit().floatValue());
                    payloadBuffer.putFloat(gr.getUpperWarningLimit().floatValue());
                    payloadBuffer.putFloat(gr.getLowerWarningLimit().floatValue());
                    payloadBuffer.putFloat(gr.getLowerAlarmLimit().floatValue());
                } else if (dataType.isBYTE()) {
                    payloadBuffer.put(gr.getUpperDispLimit().byteValue());
                    payloadBuffer.put(gr.getLowerDispLimit().byteValue());
                    payloadBuffer.put(gr.getUpperAlarmLimit().byteValue());
                    payloadBuffer.put(gr.getUpperWarningLimit().byteValue());
                    payloadBuffer.put(gr.getLowerWarningLimit().byteValue());
                    payloadBuffer.put(gr.getLowerAlarmLimit().byteValue());
                } else if (dataType.isINT()) {
                    payloadBuffer.putInt(gr.getUpperDispLimit().intValue());
                    payloadBuffer.putInt(gr.getLowerDispLimit().intValue());
                    payloadBuffer.putInt(gr.getUpperAlarmLimit().intValue());
                    payloadBuffer.putInt(gr.getUpperWarningLimit().intValue());
                    payloadBuffer.putInt(gr.getLowerWarningLimit().intValue());
                    payloadBuffer.putInt(gr.getLowerAlarmLimit().intValue());
                } else if (dataType.isDOUBLE()) {
                    payloadBuffer.putDouble(gr.getUpperDispLimit().doubleValue());
                    payloadBuffer.putDouble(gr.getLowerDispLimit().doubleValue());
                    payloadBuffer.putDouble(gr.getUpperAlarmLimit().doubleValue());
                    payloadBuffer.putDouble(gr.getUpperWarningLimit().doubleValue());
                    payloadBuffer.putDouble(gr.getLowerWarningLimit().doubleValue());
                    payloadBuffer.putDouble(gr.getLowerAlarmLimit().doubleValue());
                }
            }
            if (dataType.isCTRL()) {
                CTRL ctrl = (CTRL)value;
                if (dataType.isSHORT()) {
                    payloadBuffer.putShort(ctrl.getUpperCtrlLimit().shortValue());
                    payloadBuffer.putShort(ctrl.getLowerCtrlLimit().shortValue());
                } else if (dataType.isFLOAT()) {
                    payloadBuffer.putFloat(ctrl.getUpperCtrlLimit().floatValue());
                    payloadBuffer.putFloat(ctrl.getLowerCtrlLimit().floatValue());
                } else if (dataType.isBYTE()) {
                    payloadBuffer.put(ctrl.getUpperCtrlLimit().byteValue());
                    payloadBuffer.put(ctrl.getLowerCtrlLimit().byteValue());
                } else if (dataType.isINT()) {
                    payloadBuffer.putInt(ctrl.getUpperCtrlLimit().intValue());
                    payloadBuffer.putInt(ctrl.getLowerCtrlLimit().intValue());
                } else if (dataType.isDOUBLE()) {
                    payloadBuffer.putDouble(ctrl.getUpperCtrlLimit().doubleValue());
                    payloadBuffer.putDouble(ctrl.getLowerCtrlLimit().doubleValue());
                }
            }
        }
        if (dataType == DBRType.GR_BYTE || dataType == DBRType.CTRL_BYTE) {
            payloadBuffer.put((byte)0);
        }
        DBREncoder.insertPayload(payloadBuffer, dataTypeValue, dataCount, value.getValue());
    }
}

