/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl.handlers;

import com.cosylab.epics.caj.impl.ResponseHandler;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.util.HexDump;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public abstract class AbstractCAResponseHandler
implements ResponseHandler {
    protected String description;
    protected short command;
    protected int payloadSize;
    protected short dataType;
    protected int dataCount;
    protected int parameter1;
    protected int parameter2;
    protected boolean debug = false;

    public AbstractCAResponseHandler(String description) {
        this.description = description;
        this.debug = System.getProperties().containsKey("CAJ_DEBUG");
    }

    public void handleResponse(InetSocketAddress responseFrom, Transport transport, ByteBuffer[] response) {
        this.parseHeader(response[0]);
        if (this.debug && this.payloadSize > 0 && response.length > 1) {
            HexDump.hexDump(this.description + " payload", response[1].array(), response[1].position(), response[1].limit() - response[1].position());
        }
        this.internalHandleResponse(responseFrom, transport, response);
    }

    protected abstract void internalHandleResponse(InetSocketAddress var1, Transport var2, ByteBuffer[] var3);

    protected void parseHeader(ByteBuffer headerBuffer) {
        int startPos = headerBuffer.position();
        boolean isExtended = false;
        this.command = headerBuffer.getShort();
        this.payloadSize = headerBuffer.getShort() & 0xFFFF;
        this.dataType = headerBuffer.getShort();
        this.dataCount = headerBuffer.getShort() & 0xFFFF;
        this.parameter1 = headerBuffer.getInt();
        this.parameter2 = headerBuffer.getInt();
        if (this.payloadSize == 65535) {
            isExtended = true;
        }
        if (this.payloadSize == 65535) {
            this.payloadSize = headerBuffer.getInt();
            this.dataCount = headerBuffer.getInt();
        }
        if (this.debug) {
            HexDump.hexDump(this.description, headerBuffer.array(), startPos, isExtended ? 24 : 16);
        }
    }
}

