/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl.reactor;

import com.cosylab.epics.caj.impl.reactor.ReactorHandler;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;

public class Reactor {
    private Selector selector;
    private LinkedList registrationRequests = new LinkedList();
    private LinkedList deregistrationRequests = new LinkedList();
    private LinkedList interestOpsChangeRequests = new LinkedList();
    private HashMap disabledKeys = new HashMap();
    private AtomicInteger selectorPending = new AtomicInteger(0);
    private volatile boolean shutdown = false;
    private volatile Object shutdownMonitor = new Object();

    public Reactor() throws IOException {
        this.initialize();
    }

    private void initialize() throws IOException {
        this.selector = Selector.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processInternalRequest(LinkedList list) {
        if (!list.isEmpty()) {
            LinkedList linkedList = list;
            synchronized (linkedList) {
                while (!list.isEmpty()) {
                    try {
                        ((InternalRequest)list.removeFirst()).process();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process() {
        if (this.selector.isOpen() && !this.shutdown) {
            this.processInternal();
        }
        if (!this.selector.isOpen() || this.shutdown) {
            Object object;
            if (!this.registrationRequests.isEmpty()) {
                object = this.registrationRequests;
                synchronized (object) {
                    while (!this.registrationRequests.isEmpty()) {
                        ((RegistrationRequest)this.registrationRequests.removeFirst()).cancelRegistration();
                    }
                }
            }
            Reactor.processInternalRequest(this.deregistrationRequests);
            object = this.shutdownMonitor;
            synchronized (object) {
                this.shutdownMonitor.notifyAll();
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInternal() {
        try {
            int numSelectedKeys = 0;
            while (numSelectedKeys == 0 && !this.shutdown) {
                Reactor.processInternalRequest(this.deregistrationRequests);
                Reactor.processInternalRequest(this.interestOpsChangeRequests);
                this.selectorPending.incrementAndGet();
                try {
                    numSelectedKeys = this.selector.selectedKeys().size();
                    if (numSelectedKeys == 0) {
                        numSelectedKeys = this.selector.select();
                    }
                }
                finally {
                    this.selectorPending.decrementAndGet();
                }
                if (this.shutdown) {
                    this.selector.close();
                    return;
                }
                Reactor.processInternalRequest(this.registrationRequests);
            }
            if (numSelectedKeys == 0 || this.shutdown) {
                return;
            }
            Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
            SelectionKey selectedKey = selectedKeys.next();
            int ops = selectedKey.interestOps();
            if ((ops & 4) == 4) {
                selectedKey.interestOps(ops & 0xFFFFFFFB);
            }
            ReactorHandler handler = (ReactorHandler)selectedKey.attachment();
            selectedKeys.remove();
            handler.handleEvent(selectedKey);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAndClose(SelectableChannel selectableChannel) {
        SelectionKey key = selectableChannel.keyFor(this.selector);
        LinkedList linkedList = this.deregistrationRequests;
        synchronized (linkedList) {
            this.deregistrationRequests.add(new DeregistrationRequest(key));
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionKey register(SelectableChannel selectableChannel, int interestOps, ReactorHandler handler) throws ClosedChannelException {
        RegistrationRequest rr;
        RegistrationRequest registrationRequest = rr = new RegistrationRequest(selectableChannel, interestOps, handler);
        synchronized (registrationRequest) {
            LinkedList linkedList = this.registrationRequests;
            synchronized (linkedList) {
                this.registrationRequests.add(rr);
            }
            if (this.shutdown) {
                throw new IllegalStateException("Reactor is already shutdown.");
            }
            this.selector.wakeup();
            if (this.selectorPending.get() == 0) {
                rr.process();
            } else {
                try {
                    rr.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        if (this.shutdown) {
            throw new IllegalStateException("Reactor is shutting down.");
        }
        if (rr.getException() != null) {
            throw rr.getException();
        }
        return rr.getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInterestOpsInternal(SelectionKey selectionKey, int interestOps) {
        LinkedList linkedList = this.interestOpsChangeRequests;
        synchronized (linkedList) {
            this.interestOpsChangeRequests.add(new InterestOpsChangeRequest(selectionKey, interestOps));
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableSelectionKey(SelectionKey key) {
        HashMap hashMap = this.disabledKeys;
        synchronized (hashMap) {
            if (this.disabledKeys.containsKey(key)) {
                return;
            }
            int interestOps = key.interestOps();
            this.disabledKeys.put(key, new Integer(interestOps));
            key.interestOps(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableSelectionKey(SelectionKey key) {
        HashMap hashMap = this.disabledKeys;
        synchronized (hashMap) {
            Integer ops = (Integer)this.disabledKeys.remove(key);
            if (ops != null) {
                this.setInterestOpsInternal(key, ops);
            }
        }
    }

    public void setInterestOps(AbstractSelectableChannel channel, int interestOps) {
        SelectionKey key = channel.keyFor(this.selector);
        if (key != null) {
            this.setInterestOps(key, interestOps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInterestOps(SelectionKey selectionKey, int interestOps) {
        HashMap hashMap = this.disabledKeys;
        synchronized (hashMap) {
            Integer ops = (Integer)this.disabledKeys.get(selectionKey);
            if (ops != null) {
                this.disabledKeys.put(selectionKey, new Integer(interestOps));
            } else {
                this.setInterestOpsInternal(selectionKey, interestOps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        Object object = this.shutdownMonitor;
        synchronized (object) {
            this.shutdown = true;
            this.selector.wakeup();
            try {
                this.shutdownMonitor.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    private class InterestOpsChangeRequest
    implements InternalRequest {
        private SelectionKey selectionKey;
        private int interestOps;

        public InterestOpsChangeRequest(SelectionKey selectionKey, int interestOps) {
            this.selectionKey = selectionKey;
            this.interestOps = interestOps;
        }

        public void process() {
            this.selectionKey.interestOps(this.interestOps);
        }
    }

    private class DeregistrationRequest
    implements InternalRequest {
        private SelectionKey key = null;

        public DeregistrationRequest(SelectionKey key) {
            this.key = key;
        }

        public void process() {
            this.key.cancel();
            try {
                this.key.channel().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class RegistrationRequest
    implements InternalRequest {
        private SelectableChannel selectableChannel;
        private int interestOps;
        private ReactorHandler handler;
        private SelectionKey key = null;
        private ClosedChannelException exception = null;

        public RegistrationRequest(SelectableChannel selectableChannel, int interestOps, ReactorHandler handler) {
            this.selectableChannel = selectableChannel;
            this.interestOps = interestOps;
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void process() {
            try {
                this.key = this.selectableChannel.register(Reactor.this.selector, this.interestOps, this.handler);
            }
            catch (ClosedChannelException cce) {
                this.exception = cce;
            }
            finally {
                this.notifyAll();
            }
        }

        public synchronized void cancelRegistration() {
            this.notifyAll();
        }

        public ClosedChannelException getException() {
            return this.exception;
        }

        public SelectionKey getKey() {
            return this.key;
        }
    }

    private static interface InternalRequest {
        public void process();
    }
}

