/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas;

import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.cas.BeaconEmitter;
import com.cosylab.epics.caj.cas.CASAcceptor;
import com.cosylab.epics.caj.cas.CASResponseHandler;
import com.cosylab.epics.caj.cas.CASTransport;
import com.cosylab.epics.caj.impl.BroadcastConnector;
import com.cosylab.epics.caj.impl.BroadcastTransport;
import com.cosylab.epics.caj.impl.CAContext;
import com.cosylab.epics.caj.impl.CATransportRegistry;
import com.cosylab.epics.caj.impl.CachedByteBufferAllocator;
import com.cosylab.epics.caj.impl.ConnectionException;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.reactor.Reactor;
import com.cosylab.epics.caj.impl.reactor.lf.LeaderFollowersThreadPool;
import com.cosylab.epics.caj.util.InetAddressUtil;
import com.cosylab.epics.caj.util.Timer;
import com.cosylab.epics.caj.util.logging.ConsoleLogHandler;
import gov.aps.jca.CAException;
import gov.aps.jca.Context;
import gov.aps.jca.JCALibrary;
import gov.aps.jca.Version;
import gov.aps.jca.cas.Server;
import gov.aps.jca.cas.ServerContext;
import gov.aps.jca.configuration.Configurable;
import gov.aps.jca.configuration.Configuration;
import gov.aps.jca.configuration.ConfigurationException;
import gov.aps.jca.event.ContextExceptionListener;
import gov.aps.jca.event.ContextMessageListener;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CAJServerContext
extends ServerContext
implements CAContext,
Configurable {
    private static final int CAS_VERSION_MAJOR = 1;
    private static final int CAS_VERSION_MINOR = 1;
    private static final int CAS_VERSION_MAINTENANCE = 1;
    private static final int CAS_VERSION_DEVELOPMENT = 0;
    public static final Version VERSION;
    public static final String CAJ_SINGLE_THREADED_MODEL = "CAJ_SINGLE_THREADED_MODEL";
    private static final int NOT_INITIALIZED = 0;
    private static final int INITIALIZED = 1;
    private static final int RUNNING = 2;
    private static final int RUNNED = 3;
    private static final int DESTROYED = 4;
    private volatile int state = 0;
    protected Logger logger = Logger.global;
    protected String beaconAddressList = "";
    protected String ignoreAddressList = "";
    protected boolean autoBeaconAddressList = true;
    protected float beaconPeriod = 15.0f;
    protected int beaconPort = 5065;
    protected int serverPort = 5064;
    protected int maxArrayBytes = 16384;
    protected ArrayList contextMessageListeners = new ArrayList();
    protected ArrayList contextExceptionListeners = new ArrayList();
    protected Timer timer = null;
    protected Reactor reactor = null;
    protected LeaderFollowersThreadPool leaderFollowersThreadPool = null;
    protected BroadcastTransport broadcastTransport = null;
    protected BeaconEmitter beaconEmitter = null;
    protected CASAcceptor acceptor = null;
    protected CATransportRegistry transportRegistry = null;
    protected CachedByteBufferAllocator cachedBufferAllocator = new CachedByteBufferAllocator();
    private AtomicInteger lastChannelSID = new AtomicInteger(0);
    protected Server server;
    protected Object runLock = new Object();
    private AtomicInteger lastReceivedSequenceNumber = new AtomicInteger(0);
    private boolean runTerminated;

    public CAJServerContext() {
        this.initializeLogger();
        this.loadConfiguration();
    }

    public Version getVersion() {
        return VERSION;
    }

    protected void initializeLogger() {
        JCALibrary jcaLibrary = JCALibrary.getInstance();
        String thisClassName = this.getClass().getName();
        String loggerName = jcaLibrary.getProperty(thisClassName + ".logger", thisClassName);
        this.logger = Logger.getLogger(loggerName);
        if (System.getProperties().containsKey("CAJ_DEBUG")) {
            this.logger.setLevel(Level.ALL);
            this.logger.addHandler(new ConsoleLogHandler());
        }
    }

    protected void loadConfiguration() {
        JCALibrary jcaLibrary = JCALibrary.getInstance();
        String contextClassName = Context.class.getName();
        this.beaconAddressList = jcaLibrary.getProperty(contextClassName + ".addr_list", this.beaconAddressList);
        this.autoBeaconAddressList = jcaLibrary.getPropertyAsBoolean(contextClassName + ".auto_addr_list", this.autoBeaconAddressList);
        this.beaconPeriod = jcaLibrary.getPropertyAsFloat(contextClassName + ".beacon_period", this.beaconPeriod);
        this.beaconPort = jcaLibrary.getPropertyAsInt(contextClassName + ".repeater_port", this.beaconPort);
        this.serverPort = jcaLibrary.getPropertyAsInt(contextClassName + ".server_port", this.serverPort);
        this.maxArrayBytes = jcaLibrary.getPropertyAsInt(contextClassName + ".max_array_bytes", this.maxArrayBytes);
        contextClassName = CAJContext.class.getName();
        this.beaconAddressList = jcaLibrary.getProperty(contextClassName + ".addr_list", this.beaconAddressList);
        this.autoBeaconAddressList = jcaLibrary.getPropertyAsBoolean(contextClassName + ".auto_addr_list", this.autoBeaconAddressList);
        this.beaconPeriod = jcaLibrary.getPropertyAsFloat(contextClassName + ".beacon_period", this.beaconPeriod);
        this.beaconPort = jcaLibrary.getPropertyAsInt(contextClassName + ".repeater_port", this.beaconPort);
        this.serverPort = jcaLibrary.getPropertyAsInt(contextClassName + ".server_port", this.serverPort);
        this.maxArrayBytes = jcaLibrary.getPropertyAsInt(contextClassName + ".max_array_bytes", this.maxArrayBytes);
        String thisClassName = this.getClass().getName();
        this.beaconAddressList = jcaLibrary.getProperty(thisClassName + ".beacon_addr_list", this.beaconAddressList);
        this.autoBeaconAddressList = jcaLibrary.getPropertyAsBoolean(thisClassName + ".auto_beacon_addr_list", this.autoBeaconAddressList);
        this.beaconPeriod = jcaLibrary.getPropertyAsFloat(thisClassName + ".beacon_period", this.beaconPeriod);
        this.beaconPort = jcaLibrary.getPropertyAsInt(thisClassName + ".beacon_port", this.beaconPort);
        this.serverPort = jcaLibrary.getPropertyAsInt(thisClassName + ".server_port", this.serverPort);
        this.maxArrayBytes = jcaLibrary.getPropertyAsInt(thisClassName + ".max_array_bytes", this.maxArrayBytes);
        this.ignoreAddressList = jcaLibrary.getProperty(thisClassName + ".ignore_addr_list", this.ignoreAddressList);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        try {
            this.beaconAddressList = configuration.getChild("beacon_addr_list", false).getValue();
        }
        catch (Exception ex) {
            this.beaconAddressList = configuration.getAttribute("beacon_addr_list", this.beaconAddressList);
        }
        try {
            this.autoBeaconAddressList = configuration.getChild("auto_beacon_addr_list", false).getValueAsBoolean();
        }
        catch (Exception ex) {
            this.autoBeaconAddressList = configuration.getAttributeAsBoolean("auto_beacon_addr_list", this.autoBeaconAddressList);
        }
        try {
            this.beaconPeriod = configuration.getChild("beacon_period", false).getValueAsFloat();
        }
        catch (Exception ex) {
            this.beaconPeriod = configuration.getAttributeAsFloat("beacon_period", this.beaconPeriod);
        }
        try {
            this.beaconPort = configuration.getChild("beacon_port", false).getValueAsInteger();
        }
        catch (Exception ex) {
            this.beaconPort = configuration.getAttributeAsInteger("beacon_port", this.beaconPort);
        }
        try {
            this.serverPort = configuration.getChild("server_port", false).getValueAsInteger();
        }
        catch (Exception ex) {
            this.serverPort = configuration.getAttributeAsInteger("server_port", this.serverPort);
        }
        try {
            this.maxArrayBytes = configuration.getChild("max_array_bytes", false).getValueAsInteger();
        }
        catch (Exception ex) {
            this.maxArrayBytes = configuration.getAttributeAsInteger("max_array_bytes", this.maxArrayBytes);
        }
        try {
            this.ignoreAddressList = configuration.getChild("ignore_addr_list", false).getValue();
        }
        catch (Exception ex) {
            this.ignoreAddressList = configuration.getAttribute("ignore_addr_list", this.ignoreAddressList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextMessageListener[] getContextMessageListeners() throws IllegalStateException {
        ArrayList arrayList = this.contextMessageListeners;
        synchronized (arrayList) {
            ContextMessageListener[] listeners = new ContextMessageListener[this.contextMessageListeners.size()];
            return this.contextMessageListeners.toArray(listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContextMessageListener(ContextMessageListener l) throws CAException, IllegalStateException {
        this.checkState();
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        ArrayList arrayList = this.contextMessageListeners;
        synchronized (arrayList) {
            if (!this.contextMessageListeners.contains(l)) {
                this.contextMessageListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContextMessageListener(ContextMessageListener l) throws CAException, IllegalStateException {
        this.checkState();
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        ArrayList arrayList = this.contextMessageListeners;
        synchronized (arrayList) {
            this.contextMessageListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextExceptionListener[] getContextExceptionListeners() throws IllegalStateException {
        ArrayList arrayList = this.contextExceptionListeners;
        synchronized (arrayList) {
            ContextExceptionListener[] listeners = new ContextExceptionListener[this.contextExceptionListeners.size()];
            return this.contextExceptionListeners.toArray(listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContextExceptionListener(ContextExceptionListener l) throws CAException, IllegalStateException {
        this.checkState();
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        ArrayList arrayList = this.contextExceptionListeners;
        synchronized (arrayList) {
            if (!this.contextExceptionListeners.contains(l)) {
                this.contextExceptionListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContextExceptionListener(ContextExceptionListener l) throws CAException, IllegalStateException {
        this.checkState();
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        ArrayList arrayList = this.contextExceptionListeners;
        synchronized (arrayList) {
            this.contextExceptionListeners.remove(l);
        }
    }

    protected void checkState() throws CAException, IllegalStateException {
        if (this.state == 4) {
            throw new IllegalStateException("Context destroyed.");
        }
    }

    public synchronized void initialize(Server server) throws CAException, IllegalStateException {
        if (server == null) {
            throw new IllegalArgumentException("non null server expected");
        }
        if (this.state == 4) {
            throw new IllegalStateException("Context destroyed.");
        }
        if (this.state == 1 || this.state == 2 || this.state == 3) {
            throw new IllegalStateException("Context already initialized.");
        }
        this.server = server;
        this.internalInitialize();
        this.state = 1;
    }

    private void internalInitialize() throws CAException {
        this.timer = new Timer();
        this.transportRegistry = new CATransportRegistry();
        try {
            this.reactor = new Reactor();
            if (System.getProperties().containsKey(CAJ_SINGLE_THREADED_MODEL)) {
                this.logger.config("Using single threaded model.");
                new Thread(new Runnable(){

                    public void run() {
                        while (CAJServerContext.this.reactor.process()) {
                        }
                    }
                }, "CAS reactor").start();
            } else {
                this.leaderFollowersThreadPool = new LeaderFollowersThreadPool();
                this.leaderFollowersThreadPool.promoteLeader(new Runnable(){

                    public void run() {
                        CAJServerContext.this.reactor.process();
                    }
                });
            }
        }
        catch (IOException ioex) {
            throw new CAException("Failed to initialize reactor.", (Throwable)ioex);
        }
        this.initializeUDPTransport();
        this.beaconEmitter = new BeaconEmitter(this.broadcastTransport, this, this.beaconPeriod);
        this.acceptor = new CASAcceptor(this, this.serverPort);
    }

    private void initializeUDPTransport() {
        try {
            InetSocketAddress[] list;
            InetSocketAddress listenLocalAddress = new InetSocketAddress(this.serverPort);
            BroadcastConnector broadcastConnector = new BroadcastConnector(this);
            this.broadcastTransport = (BroadcastTransport)broadcastConnector.connect(null, new CASResponseHandler(this), listenLocalAddress, (short)11, (short)0);
            try {
                this.broadcastTransport.bind(true);
            }
            catch (SocketException se) {
                this.logger.log(Level.WARNING, "Failed to bind UDP socket to: " + listenLocalAddress, se);
            }
            if (this.ignoreAddressList != null && this.ignoreAddressList.length() > 0 && (list = InetAddressUtil.getSocketAddressList(this.ignoreAddressList, 0)) != null && list.length > 0) {
                this.broadcastTransport.setIgnoredAddresses(list);
            }
            if (this.beaconAddressList != null && this.beaconAddressList.length() > 0) {
                InetSocketAddress[] list2;
                InetSocketAddress[] appendList = null;
                if (this.autoBeaconAddressList) {
                    appendList = this.broadcastTransport.getBroadcastAddresses();
                }
                if ((list2 = InetAddressUtil.getSocketAddressList(this.beaconAddressList, this.beaconPort, appendList)) != null && list2.length > 0) {
                    this.broadcastTransport.setBroadcastAddresses(list2);
                }
            }
        }
        catch (ConnectionException ce) {
            this.logger.log(Level.SEVERE, "Failed to initialize UDP transport.", ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(int seconds) throws CAException, IllegalStateException {
        if (seconds < 0) {
            throw new IllegalArgumentException("seconds cannot be negative.");
        }
        if (this.state == 0) {
            throw new IllegalStateException("Context not initialized.");
        }
        if (this.state == 4) {
            throw new IllegalStateException("Context destroyed.");
        }
        if (this.state == 2) {
            throw new IllegalStateException("Context is already running.");
        }
        if (this.state == 3) {
            throw new IllegalStateException("Context has already completed running.");
        }
        Object object = this;
        synchronized (object) {
            if (this.state == 3) {
                throw new IllegalStateException("Context has already completed running.");
            }
            this.state = 2;
        }
        this.beaconEmitter.start();
        object = this.runLock;
        synchronized (object) {
            this.runTerminated = false;
            try {
                long timeToWait = seconds * 1000;
                long start = System.currentTimeMillis();
                while (!(this.runTerminated || timeToWait != 0L && System.currentTimeMillis() - start >= timeToWait)) {
                    this.runLock.wait(timeToWait);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        object = this;
        synchronized (object) {
            this.state = 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() throws CAException, IllegalStateException {
        if (this.state == 4) {
            throw new IllegalStateException("Context already destroyed.");
        }
        Object object = this.runLock;
        synchronized (object) {
            this.runTerminated = true;
            this.runLock.notifyAll();
        }
    }

    public synchronized void destroy() throws CAException, IllegalStateException {
        if (this.state == 4) {
            throw new IllegalStateException("Context already destroyed.");
        }
        this.shutdown();
        this.state = 4;
        this.internalDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDestroy() throws CAException {
        if (this.acceptor != null) {
            this.acceptor.destroy();
        }
        if (this.beaconEmitter != null) {
            this.beaconEmitter.destroy();
        }
        if (this.timer != null) {
            this.timer.shutDown();
        }
        if (this.broadcastTransport != null) {
            this.broadcastTransport.close();
        }
        this.destroyAllTransports();
        if (this.reactor != null) {
            this.reactor.shutdown();
        }
        if (this.leaderFollowersThreadPool != null) {
            this.leaderFollowersThreadPool.shutdown();
        }
        ArrayList arrayList = this.contextMessageListeners;
        synchronized (arrayList) {
            this.contextMessageListeners.clear();
        }
        arrayList = this.contextExceptionListeners;
        synchronized (arrayList) {
            this.contextExceptionListeners.clear();
        }
    }

    private void destroyAllTransports() {
        if (this.transportRegistry == null) {
            return;
        }
        Transport[] transports = this.transportRegistry.toArray();
        if (transports.length == 0) {
            return;
        }
        this.logger.fine("Server context still has " + transports.length + " transport(s) active and closing...");
        for (int i = 0; i < transports.length; ++i) {
            CASTransport transport = (CASTransport)transports[i];
            try {
                transport.close(true);
                continue;
            }
            catch (Throwable th) {
                this.logger.log(Level.SEVERE, "", th);
            }
        }
    }

    public void printInfo(PrintStream out) throws IllegalStateException {
        super.printInfo(out);
        out.println("SERVER : " + (this.server != null ? this.server.getClass().getName() : null));
        out.println("BEACON_ADDR_LIST : " + this.beaconAddressList);
        out.println("AUTO_BEACON_ADDR_LIST : " + this.autoBeaconAddressList);
        out.println("BEACON_PERIOD : " + this.beaconPeriod);
        out.println("BEACON_PORT : " + this.beaconPort);
        out.println("SERVER_PORT : " + this.serverPort);
        out.println("MAX_ARRAY_BYTES : " + this.maxArrayBytes);
        out.println("IGNORE_ADDR_LIST: " + this.ignoreAddressList);
        out.print("STATE : ");
        switch (this.state) {
            case 0: {
                out.println("NOT_INITIALIZED");
                break;
            }
            case 1: {
                out.println("INITIALIZED");
                break;
            }
            case 2: {
                out.println("RUNNING");
                break;
            }
            case 3: {
                out.println("RUNNED");
                break;
            }
            case 4: {
                out.println("DESTROYED");
                break;
            }
            default: {
                out.println("UNKNOWN");
            }
        }
    }

    public boolean isInitialized() {
        return this.state == 1 || this.state == 3 || this.state == 2;
    }

    public boolean isDestroyed() {
        return this.state == 4;
    }

    public String getBeaconAddressList() {
        return this.beaconAddressList;
    }

    public boolean isAutoBeaconAddressList() {
        return this.autoBeaconAddressList;
    }

    public float getBeaconPeriod() {
        return this.beaconPeriod;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getMaxArrayBytes() {
        return this.maxArrayBytes;
    }

    public int getBeaconPort() {
        return this.beaconPort;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int port) {
        this.serverPort = port;
    }

    public int getBroadcastPort() {
        return this.getBeaconPort();
    }

    public String getIgnoreAddressList() {
        return this.ignoreAddressList;
    }

    public InetAddress getServerInetAddress() {
        return this.acceptor != null ? this.acceptor.getBindAddress() : null;
    }

    public Reactor getReactor() {
        return this.reactor;
    }

    public BroadcastTransport getBroadcastTransport() {
        return this.broadcastTransport;
    }

    public CATransportRegistry getTransportRegistry() {
        return this.transportRegistry;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public CachedByteBufferAllocator getCachedBufferAllocator() {
        return this.cachedBufferAllocator;
    }

    public LeaderFollowersThreadPool getLeaderFollowersThreadPool() {
        return this.leaderFollowersThreadPool;
    }

    public Server getServer() {
        return this.server;
    }

    public int generateChannelSID() {
        return this.lastChannelSID.incrementAndGet();
    }

    public final void setLastReceivedSequenceNumber(int seqNo) {
        this.lastReceivedSequenceNumber.set(seqNo);
    }

    public final int getLastReceivedSequenceNumber(int seqNo) {
        return this.lastReceivedSequenceNumber.get();
    }

    public final void invalidateLastReceivedSequence() {
        this.lastReceivedSequenceNumber.set(0);
    }

    static {
        System.setProperty("java.net.preferIPv4Stack", "true");
        VERSION = new Version("Channel Access Server in Java", "Java", 1, 1, 1, 0);
    }
}

