/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas;

import com.cosylab.epics.caj.cas.CASTransport;
import com.cosylab.epics.caj.cas.ProcessVariableEventDispatcher;
import com.cosylab.epics.caj.cas.handlers.EventAddResponse;
import gov.aps.jca.cas.ProcessVariableEventCallback;
import gov.aps.jca.cas.ServerChannel;
import gov.aps.jca.cas.ServerMonitor;
import gov.aps.jca.dbr.DBR;
import java.util.LinkedList;

public class CASServerMonitor
extends ServerMonitor
implements ProcessVariableEventCallback,
Runnable {
    protected short mask;
    protected EventAddResponse handler;
    protected CASTransport transport;
    protected short dataType;
    protected int dataCount;
    protected LinkedList queue = new LinkedList();
    protected DBR pendingEvent = null;
    protected boolean submitPending = false;
    protected boolean destoryed = false;
    protected static final int MAX_QUEUE_SIZE = 100;

    public CASServerMonitor(ServerChannel channel, int ioid, short mask, EventAddResponse handler, CASTransport transport, short dataType, int dataCount) {
        super(channel, ioid);
        this.mask = mask;
        this.handler = handler;
        this.transport = transport;
        this.dataType = dataType;
        this.dataCount = dataCount;
        ((ProcessVariableEventDispatcher)channel.getProcessVariable().getEventCallback()).registerEventListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.destoryed = true;
            this.queue.clear();
        }
        ((ProcessVariableEventDispatcher)this.channel.getProcessVariable().getEventCallback()).unregisterEventListener(this);
        super.destroy();
    }

    public void canceled() {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            if (this.destoryed || this.queue.isEmpty()) {
                return;
            }
            this.pendingEvent = (DBR)this.queue.removeFirst();
        }
        this.handler.eventResponse(this.channel.getProcessVariable(), this.transport, this.dataType, this.dataCount, this.channel.getSID(), this.ioid, this.pendingEvent);
        linkedList = this.queue;
        synchronized (linkedList) {
            this.pendingEvent = null;
            this.submitPending = false;
            if (!this.queue.isEmpty()) {
                this.submit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submit() {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            if (this.submitPending) {
                return;
            }
            this.submitPending = this.transport.processEvents(this);
            if (this.pendingEvent == null) {
                this.submitPending = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postEvent(int select, DBR event) {
        if ((select & this.mask) == 0) {
            return;
        }
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            if (this.destoryed) {
                return;
            }
            if (this.transport.hasReplaceEventPolicy()) {
                this.queue.clear();
            }
            this.queue.addLast(event);
            if (this.queue.size() > 100) {
                this.queue.removeFirst();
            }
            if (!this.submitPending) {
                this.submit();
            }
        }
    }
}

