/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas.handlers;

import com.cosylab.epics.caj.cas.CAJServerContext;
import com.cosylab.epics.caj.cas.CASTransport;
import com.cosylab.epics.caj.cas.handlers.AbstractCASResponseHandler;
import com.cosylab.epics.caj.cas.requests.ClearChannelRequest;
import com.cosylab.epics.caj.impl.Transport;
import gov.aps.jca.CAStatus;
import gov.aps.jca.cas.ServerChannel;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class ClearChannelResponse
extends AbstractCASResponseHandler {
    public ClearChannelResponse(CAJServerContext context) {
        super(context, "Clear channel request");
    }

    protected void internalHandleResponse(InetSocketAddress responseFrom, Transport transport, ByteBuffer[] response) {
        CASTransport casTransport = (CASTransport)transport;
        ServerChannel channel = casTransport.getChannel(this.parameter1);
        if (channel == null) {
            this.sendException(transport, this.parameter1, CAStatus.BADCHID, response[0], null);
            return;
        }
        channel.destroy();
        casTransport.unregisterChannel(this.parameter1);
        try {
            new ClearChannelRequest(transport, this.parameter1, this.parameter2).submit();
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.WARNING, "Exception caught when responding to event cancel request for channel with SID : " + this.parameter1, th);
        }
    }
}

