/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas.handlers;

import com.cosylab.epics.caj.cas.CAJServerContext;
import com.cosylab.epics.caj.cas.handlers.AbstractCASResponseHandler;
import com.cosylab.epics.caj.cas.requests.EchoRequest;
import com.cosylab.epics.caj.impl.Transport;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class EchoResponse
extends AbstractCASResponseHandler {
    protected int initialHeaderBufferPosition = 0;

    public EchoResponse(CAJServerContext context) {
        super(context, "Echo request");
    }

    protected void internalHandleResponse(InetSocketAddress responseFrom, Transport transport, ByteBuffer[] response) {
        boolean udpResponse;
        ByteBuffer headerBuffer = ByteBuffer.wrap(response[0].array(), this.initialHeaderBufferPosition, response[0].position());
        ByteBuffer payloadBuffer = null;
        boolean bl = udpResponse = response.length == 1;
        if (udpResponse) {
            if (this.payloadSize > 0) {
                ByteBuffer postHeaderBuffer = response[0];
                int startPos = postHeaderBuffer.position();
                payloadBuffer = ByteBuffer.wrap(postHeaderBuffer.array(), startPos, this.payloadSize);
                postHeaderBuffer.position(startPos + this.payloadSize);
            }
        } else {
            payloadBuffer = response[1];
        }
        try {
            EchoRequest echoRequest = new EchoRequest(transport, headerBuffer, payloadBuffer);
            if (udpResponse) {
                this.context.getBroadcastTransport().send(echoRequest, responseFrom);
            } else {
                echoRequest.submit();
            }
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.WARNING, "Failed to send back echo response to: " + responseFrom, th);
        }
    }

    public void handleResponse(InetSocketAddress responseFrom, Transport transport, ByteBuffer[] response) {
        this.initialHeaderBufferPosition = response[0].position();
        super.handleResponse(responseFrom, transport, response);
    }
}

