/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas.handlers;

import com.cosylab.epics.caj.cas.CAJServerContext;
import com.cosylab.epics.caj.cas.CASServerMonitor;
import com.cosylab.epics.caj.cas.CASTransport;
import com.cosylab.epics.caj.cas.handlers.AbstractCASResponseHandler;
import com.cosylab.epics.caj.cas.requests.EventAddRequest;
import com.cosylab.epics.caj.impl.Transport;
import gov.aps.jca.CAStatus;
import gov.aps.jca.CAStatusException;
import gov.aps.jca.cas.ProcessVariable;
import gov.aps.jca.cas.ProcessVariableReadCallback;
import gov.aps.jca.cas.ServerChannel;
import gov.aps.jca.dbr.ACK;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class EventAddResponse
extends AbstractCASResponseHandler {
    public EventAddResponse(CAJServerContext context) {
        super(context, "Event add request");
    }

    protected void internalHandleResponse(InetSocketAddress responseFrom, Transport transport, ByteBuffer[] response) {
        ServerChannel channel2;
        CASTransport casTransport = (CASTransport)transport;
        try {
            channel2 = casTransport.getChannelAndVerifyRequest(this.parameter1, this.dataType, this.dataCount);
        }
        catch (CAStatusException cse) {
            ServerChannel channel2 = casTransport.getChannel(this.parameter1);
            int cid = channel2 == null ? 0 : channel2.getCID();
            this.sendException(transport, cid, cse.getStatus(), response[0], "add event request");
            return;
        }
        int MASK_OFFSET = 12;
        short mask = response[1].getShort(12);
        if ((mask & 7) == 0) {
            this.sendException(transport, channel2.getCID(), CAStatus.BADMASK, response[0], "event add req with mask=" + Integer.toHexString(mask));
            return;
        }
        DBR value = EventAddResponse.createDBRforReading(channel2.getProcessVariable(), this.dataType, this.dataCount);
        if (!channel2.readAccess()) {
            this.eventAddFailureResponse(transport, this.dataType, this.dataCount, this.parameter1, this.parameter2, CAStatus.NORDACCESS, value);
            return;
        }
        CAStatus status = null;
        try {
            ProcessVariableReadCallbackImpl pvrc = new ProcessVariableReadCallbackImpl(channel2, transport, this.dataType, this.dataCount, this.parameter1, this.parameter2, mask, value);
            status = channel2.read(value, (ProcessVariableReadCallback)pvrc);
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.WARNING, "Exception caught when calling ServerChannel.read() for: " + channel2.getProcessVariable().getName(), th);
            this.eventAddFailureResponse(transport, this.dataType, this.dataCount, this.parameter1, this.parameter2, CAStatus.DEFUNCT, value);
            return;
        }
        if (status == null) {
            return;
        }
        this.eventAddResponse(channel2, transport, this.dataType, this.dataCount, this.parameter1, this.parameter2, mask, value, status);
    }

    private void eventAddResponse(ServerChannel channel, Transport transport, short dataType, int dataCount, int sid, int ioid, short mask, DBR value, CAStatus status) {
        if (status != CAStatus.NORMAL) {
            this.eventAddFailureResponse(transport, dataType, dataCount, sid, ioid, status, value);
            return;
        }
        this.eventResponse(channel.getProcessVariable(), transport, dataType, dataCount, sid, ioid, value);
        new CASServerMonitor(channel, ioid, mask, this, (CASTransport)transport, dataType, dataCount);
    }

    public void eventResponse(ProcessVariable processVariable, Transport transport, short dataType, int dataCount, int sid, int ioid, DBR value) {
        try {
            value = value.convert(DBRType.forValue((int)dataType));
        }
        catch (CAStatusException cse) {
            this.eventAddFailureResponse(transport, dataType, dataCount, sid, ioid, cse.getStatus(), value);
            return;
        }
        if (value instanceof ACK) {
            ACK ack = (ACK)value;
            ack.setAckS(processVariable.getAckS());
            ack.setAckT(processVariable.isAckT());
        }
        try {
            new EventAddRequest(transport, ioid, dataType, dataCount, CAStatus.NORMAL, value).submit();
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.WARNING, "Exception caught when responding to event add request for channel with SID : " + sid, th);
        }
    }

    private void eventAddFailureResponse(Transport transport, short dataType, int dataCount, int sid, int ioid, CAStatus errorStatus, DBR value) {
        try {
            new EventAddRequest(transport, ioid, dataType, dataCount, errorStatus, value).submit();
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.WARNING, "Exception caught when responding with error to event add request for channel with SID : " + sid, th);
        }
    }

    class ProcessVariableReadCallbackImpl
    implements ProcessVariableReadCallback {
        private ServerChannel channel;
        private Transport transport;
        private short dataType;
        private int dataCount;
        private int sid;
        private int ioid;
        private short mask;
        private DBR value;

        public ProcessVariableReadCallbackImpl(ServerChannel channel, Transport transport, short dataType, int dataCount, int sid, int ioid, short mask, DBR value) {
            this.channel = channel;
            this.transport = transport;
            this.dataType = dataType;
            this.dataCount = dataCount;
            this.sid = sid;
            this.ioid = ioid;
            this.mask = mask;
            this.value = value;
        }

        public void processVariableReadCompleted(CAStatus status) {
            if (status == null) {
                status = CAStatus.DEFUNCT;
            }
            EventAddResponse.this.eventAddResponse(this.channel, this.transport, this.dataType, this.dataCount, this.sid, this.ioid, this.mask, this.value, status);
        }

        public void canceled() {
            EventAddResponse.this.eventAddFailureResponse(this.transport, this.dataType, this.dataCount, this.sid, this.ioid, CAStatus.DEFUNCT, this.value);
        }
    }
}

