/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas.handlers;

import com.cosylab.epics.caj.cas.CAJServerContext;
import com.cosylab.epics.caj.cas.handlers.AbstractCASResponseHandler;
import com.cosylab.epics.caj.cas.requests.SearchFailedRequest;
import com.cosylab.epics.caj.cas.requests.SearchRequest;
import com.cosylab.epics.caj.impl.Transport;
import gov.aps.jca.cas.ProcessVariableExistanceCallback;
import gov.aps.jca.cas.ProcessVariableExistanceCompletion;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class SearchResponse
extends AbstractCASResponseHandler {
    public SearchResponse(CAJServerContext context) {
        super(context, "Search request");
    }

    protected void internalHandleResponse(InetSocketAddress responseFrom, Transport transport, ByteBuffer[] response) {
        ByteBuffer headerBuffer = response[0];
        int start = headerBuffer.position();
        int bufferEnd = start + this.payloadSize;
        headerBuffer.position(bufferEnd);
        if (this.payloadSize <= 1) {
            this.context.getLogger().fine("Empty channel name search request from: " + responseFrom);
            return;
        }
        String channelName = SearchResponse.extractString(headerBuffer, start, this.payloadSize, false);
        if (channelName.length() == 0) {
            this.context.getLogger().fine("Zero length channel name search request from: " + responseFrom);
            return;
        }
        this.context.getLogger().fine(responseFrom + " is searching for " + channelName);
        ProcessVariableExistanceCompletion completion = null;
        try {
            ProcessVariableExistanceCallbackImpl pvec = new ProcessVariableExistanceCallbackImpl(responseFrom, this.dataType, this.dataCount, this.parameter1);
            completion = this.context.getServer().processVariableExistanceTest(channelName, responseFrom, (ProcessVariableExistanceCallback)pvec);
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.WARNING, "Exception caught when calling Server.processVariableExistanceTest() for: " + channelName, th);
        }
        if (completion == ProcessVariableExistanceCompletion.EXISTS_HERE || completion == ProcessVariableExistanceCompletion.DOES_NOT_EXIST_HERE) {
            this.searchResponse(responseFrom, this.dataType, this.dataCount, this.parameter1, completion);
        }
    }

    private void searchResponse(InetSocketAddress responseFrom, short dataType, int dataCount, int cid, ProcessVariableExistanceCompletion completion) {
        if (completion == ProcessVariableExistanceCompletion.EXISTS_HERE) {
            try {
                SearchRequest searchRequest = new SearchRequest(this.context.getBroadcastTransport(), (short)dataCount, cid);
                this.context.getBroadcastTransport().send(searchRequest, responseFrom);
            }
            catch (Throwable th) {
                this.context.getLogger().log(Level.WARNING, "Failed to send back search response to: " + responseFrom, th);
            }
        } else if (completion == ProcessVariableExistanceCompletion.DOES_NOT_EXIST_HERE) {
            boolean notFoundReplyRequired;
            boolean notBroadcast = responseFrom.getAddress().isMulticastAddress();
            boolean bl = notFoundReplyRequired = notBroadcast && dataType == 10;
            if (notFoundReplyRequired) {
                try {
                    SearchFailedRequest searchFailedRequest = new SearchFailedRequest(this.context.getBroadcastTransport(), (short)dataCount, cid, cid);
                    this.context.getBroadcastTransport().send(searchFailedRequest, responseFrom);
                }
                catch (Throwable th) {
                    this.context.getLogger().log(Level.WARNING, "Failed to send back search failed response to: " + responseFrom, th);
                }
            }
        } else if (completion == ProcessVariableExistanceCompletion.ASYNC_COMPLETION) {
            this.context.getLogger().log(Level.SEVERE, "Invalid ProcessVariableExistanceCompletion value, should not be ASYNC_COMPLETION!");
        }
    }

    class ProcessVariableExistanceCallbackImpl
    implements ProcessVariableExistanceCallback {
        private InetSocketAddress responseFrom;
        private short dataType;
        private int dataCount;
        private int cid;

        public ProcessVariableExistanceCallbackImpl(InetSocketAddress responseFrom, short dataType, int dataCount, int cid) {
            this.responseFrom = responseFrom;
            this.dataType = dataType;
            this.dataCount = dataCount;
            this.cid = cid;
        }

        public void processVariableExistanceTestCompleted(ProcessVariableExistanceCompletion completion) {
            SearchResponse.this.searchResponse(this.responseFrom, this.dataType, this.dataCount, this.cid, completion);
        }

        public void canceled() {
        }
    }
}

