/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas.handlers;

import com.cosylab.epics.caj.cas.CAJServerContext;
import com.cosylab.epics.caj.cas.CASTransport;
import com.cosylab.epics.caj.cas.handlers.AbstractCASResponseHandler;
import com.cosylab.epics.caj.cas.requests.WriteNotifyRequest;
import com.cosylab.epics.caj.impl.DBRDecoder;
import com.cosylab.epics.caj.impl.Transport;
import gov.aps.jca.CAStatus;
import gov.aps.jca.CAStatusException;
import gov.aps.jca.cas.ProcessVariable;
import gov.aps.jca.cas.ProcessVariableWriteCallback;
import gov.aps.jca.cas.ServerChannel;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBR_PutAckS;
import gov.aps.jca.dbr.DBR_PutAckT;
import gov.aps.jca.dbr.Severity;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class WriteNotifyResponse
extends AbstractCASResponseHandler {
    public WriteNotifyResponse(CAJServerContext context) {
        super(context, "Write notify request");
    }

    protected void internalHandleResponse(InetSocketAddress responseFrom, Transport transport, ByteBuffer[] response) {
        ServerChannel channel;
        CASTransport casTransport = (CASTransport)transport;
        try {
            channel = casTransport.getChannelAndVerifyRequest(this.parameter1, this.dataType, this.dataCount);
        }
        catch (CAStatusException cse) {
            this.writeNotifyFailureResponse(transport, this.dataType, this.dataCount, this.parameter1, this.parameter2, cse.getStatus());
            return;
        }
        if (!channel.writeAccess()) {
            CAStatus errorStatus = transport.getMinorRevision() < 1 ? CAStatus.PUTFAIL : CAStatus.NOWTACCESS;
            this.writeNotifyFailureResponse(transport, this.dataType, this.dataCount, this.parameter1, this.parameter2, errorStatus);
            return;
        }
        DBR value = DBRDecoder.getDBR(null, this.dataType, this.dataCount, response[1]);
        if (value instanceof DBR_PutAckT) {
            short tValue = ((DBR_PutAckT)value).getShortValue()[0];
            channel.getProcessVariable().setAckT(tValue != 0);
            this.writeNotifyResponse(transport, this.dataType, this.dataCount, this.parameter1, channel.getCID(), this.parameter2, CAStatus.NORMAL);
            return;
        }
        if (value instanceof DBR_PutAckS) {
            short sValue = ((DBR_PutAckS)value).getShortValue()[0];
            Severity severity = Severity.forValue((int)sValue);
            if (severity != null) {
                channel.getProcessVariable().setAckS(severity);
                this.writeNotifyResponse(transport, this.dataType, this.dataCount, this.parameter1, channel.getCID(), this.parameter2, CAStatus.NORMAL);
            } else {
                this.writeNotifyFailureResponse(transport, this.dataType, this.dataCount, this.parameter1, this.parameter2, CAStatus.PUTFAIL);
            }
            return;
        }
        try {
            ProcessVariable pv = channel.getProcessVariable();
            value = value.convert(pv.getType(), (Object)pv.getEnumLabels());
        }
        catch (CAStatusException cse) {
            this.writeNotifyFailureResponse(transport, this.dataType, this.dataCount, this.parameter1, this.parameter2, cse.getStatus());
            return;
        }
        CAStatus status = null;
        try {
            ProcessVariableWriteCallbackImpl pvwc = new ProcessVariableWriteCallbackImpl(transport, this.dataType, this.dataCount, this.parameter1, channel.getCID(), this.parameter2);
            status = channel.write(value, (ProcessVariableWriteCallback)pvwc);
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.WARNING, "Exception caught when calling ServerChannel.write() for: " + channel.getProcessVariable().getName(), th);
            this.writeNotifyFailureResponse(transport, this.dataType, this.dataCount, this.parameter1, this.parameter2, CAStatus.DEFUNCT);
            return;
        }
        if (status == null) {
            return;
        }
        if (status != CAStatus.NORMAL) {
            this.writeNotifyFailureResponse(transport, this.dataType, this.dataCount, this.parameter1, this.parameter2, status);
            return;
        }
        this.writeNotifyResponse(transport, this.dataType, this.dataCount, this.parameter1, channel.getCID(), this.parameter2, CAStatus.NORMAL);
    }

    private void writeNotifyResponse(Transport transport, short dataType, int dataCount, int sid, int cid, int ioid, CAStatus completionStatus) {
        CAStatus status = CAStatus.NORMAL;
        if (completionStatus != CAStatus.NORMAL) {
            status = CAStatus.PUTFAIL;
        }
        try {
            new WriteNotifyRequest(transport, dataType, dataCount, status, ioid).submit();
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.WARNING, "Exception caught when responding with error to write notify request for channel with SID : " + sid, th);
        }
        if (completionStatus != CAStatus.NORMAL) {
            ByteBuffer previousHeader = ByteBuffer.allocate(16);
            previousHeader.putShort((short)19);
            previousHeader.putShort((short)0);
            previousHeader.putShort(dataType);
            previousHeader.putShort((short)dataCount);
            previousHeader.putInt(sid);
            previousHeader.putInt(ioid);
            this.sendException(transport, cid, completionStatus, previousHeader, null);
        }
    }

    private void writeNotifyFailureResponse(Transport transport, short dataType, int dataCount, int sid, int ioid, CAStatus errorStatus) {
        try {
            new WriteNotifyRequest(transport, dataType, dataCount, errorStatus, ioid).submit();
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.WARNING, "Exception caught when responding with error to write notify request for channel with SID : " + sid, th);
        }
    }

    class ProcessVariableWriteCallbackImpl
    implements ProcessVariableWriteCallback {
        private Transport transport;
        private short dataType;
        private int dataCount;
        private int sid;
        private int cid;
        private int ioid;

        public ProcessVariableWriteCallbackImpl(Transport transport, short dataType, int dataCount, int sid, int cid, int ioid) {
            this.transport = transport;
            this.dataType = dataType;
            this.dataCount = dataCount;
            this.sid = sid;
            this.cid = cid;
            this.ioid = ioid;
        }

        public void processVariableWriteCompleted(CAStatus status) {
            if (status == null) {
                status = CAStatus.DEFUNCT;
            }
            WriteNotifyResponse.this.writeNotifyResponse(this.transport, this.dataType, this.dataCount, this.sid, this.cid, this.ioid, status);
        }

        public void canceled() {
            WriteNotifyResponse.this.writeNotifyFailureResponse(this.transport, this.dataType, this.dataCount, this.sid, this.ioid, CAStatus.PUTFAIL);
        }
    }
}

