/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas.handlers;

import com.cosylab.epics.caj.cas.CAJServerContext;
import com.cosylab.epics.caj.cas.CASTransport;
import com.cosylab.epics.caj.cas.handlers.AbstractCASResponseHandler;
import com.cosylab.epics.caj.impl.DBRDecoder;
import com.cosylab.epics.caj.impl.Transport;
import gov.aps.jca.CAStatus;
import gov.aps.jca.CAStatusException;
import gov.aps.jca.cas.ProcessVariable;
import gov.aps.jca.cas.ProcessVariableWriteCallback;
import gov.aps.jca.cas.ServerChannel;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBR_PutAckS;
import gov.aps.jca.dbr.DBR_PutAckT;
import gov.aps.jca.dbr.Severity;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class WriteResponse
extends AbstractCASResponseHandler {
    public WriteResponse(CAJServerContext context) {
        super(context, "Write request");
    }

    protected void internalHandleResponse(InetSocketAddress responseFrom, Transport transport, ByteBuffer[] response) {
        ServerChannel channel2;
        CASTransport casTransport = (CASTransport)transport;
        try {
            channel2 = casTransport.getChannelAndVerifyRequest(this.parameter1, this.dataType, this.dataCount);
        }
        catch (CAStatusException cse) {
            ServerChannel channel2 = casTransport.getChannel(this.parameter1);
            int cid = channel2 == null ? 0 : channel2.getCID();
            this.sendException(transport, cid, cse.getStatus(), response[0], "get request");
            return;
        }
        if (!channel2.writeAccess()) {
            CAStatus errorStatus = transport.getMinorRevision() < 1 ? CAStatus.PUTFAIL : CAStatus.NOWTACCESS;
            this.sendException(transport, channel2.getCID(), errorStatus, response[0], "write access denied");
            return;
        }
        DBR value = DBRDecoder.getDBR(null, this.dataType, this.dataCount, response[1]);
        if (value instanceof DBR_PutAckT) {
            short tValue = ((DBR_PutAckT)value).getShortValue()[0];
            channel2.getProcessVariable().setAckT(tValue != 0);
            return;
        }
        if (value instanceof DBR_PutAckS) {
            short sValue = ((DBR_PutAckS)value).getShortValue()[0];
            Severity severity = Severity.forValue((int)sValue);
            if (severity != null) {
                channel2.getProcessVariable().setAckS(severity);
            } else {
                this.sendException(transport, channel2.getCID(), CAStatus.PUTFAIL, response[0], "Invalid severity value");
            }
            return;
        }
        try {
            ProcessVariable pv = channel2.getProcessVariable();
            value = value.convert(pv.getType(), (Object)pv.getEnumLabels());
        }
        catch (CAStatusException cse) {
            this.sendException(transport, channel2.getCID(), cse.getStatus(), response[0], cse.getMessage());
            return;
        }
        CAStatus status = null;
        try {
            ProcessVariableWriteCallbackImpl pvwci = new ProcessVariableWriteCallbackImpl(transport, channel2.getCID(), response[0]);
            status = channel2.write(value, (ProcessVariableWriteCallback)pvwci);
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.WARNING, "Exception caught when calling ServerChannel.write() for: " + channel2.getProcessVariable().getName(), th);
            this.sendException(transport, channel2.getCID(), CAStatus.DEFUNCT, response[0], th.getMessage());
            return;
        }
        if (status != null && status != CAStatus.NORMAL) {
            this.sendException(transport, channel2.getCID(), status, response[0], null);
            return;
        }
    }

    class ProcessVariableWriteCallbackImpl
    implements ProcessVariableWriteCallback {
        private Transport transport;
        private int cid;
        private ByteBuffer previousHeader;

        public ProcessVariableWriteCallbackImpl(Transport transport, int cid, ByteBuffer previousHeader) {
            this.transport = transport;
            this.cid = cid;
            this.previousHeader = ByteBuffer.allocate(previousHeader.limit());
            this.previousHeader.get(previousHeader.array(), 0, previousHeader.limit());
        }

        public void processVariableWriteCompleted(CAStatus status) {
            if (status == null) {
                WriteResponse.this.sendException(this.transport, this.cid, CAStatus.DEFUNCT, this.previousHeader, "Non-null status expected.");
            } else if (status != CAStatus.NORMAL) {
                WriteResponse.this.sendException(this.transport, this.cid, status, this.previousHeader, status.getMessage());
            }
        }

        public void canceled() {
            WriteResponse.this.sendException(this.transport, this.cid, CAStatus.DEFUNCT, this.previousHeader, "Async IO canceled.");
        }
    }
}

