/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas.requests;

import com.cosylab.epics.caj.impl.DBREncoder;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.requests.AbstractCARequest;
import gov.aps.jca.CAStatus;
import gov.aps.jca.dbr.DBR;
import java.nio.ByteBuffer;

public class EventAddRequest
extends AbstractCARequest {
    public EventAddRequest(Transport transport, int ioid, short dataType, int dataCount, CAStatus status, DBR value) {
        super(transport);
        boolean extendedHeader;
        int calculatedPayloadSize = DBREncoder.calculatePayloadSize(dataType, dataCount, value.getValue());
        int alignedPayloadSize = EventAddRequest.calculateAlignedSize(8, calculatedPayloadSize);
        int alignedMessageSize = alignedPayloadSize + 16;
        boolean bl = extendedHeader = calculatedPayloadSize >= 65535 || dataCount >= 65535;
        if (extendedHeader) {
            if (transport.getMinorRevision() < 9) {
                throw new IllegalStateException("Message payload size " + alignedPayloadSize + " or element count " + dataCount + " out of bounds for CA revision " + transport.getMinorRevision() + ".");
            }
            alignedMessageSize += 8;
        }
        this.requestMessage = ByteBuffer.allocate(alignedMessageSize);
        if (!extendedHeader) {
            this.requestMessage = EventAddRequest.insertCAHeader(transport, this.requestMessage, (short)1, alignedPayloadSize, dataType, dataCount, status.getStatusCode(), ioid);
        } else {
            this.requestMessage = EventAddRequest.insertCAHeader(transport, this.requestMessage, (short)1, 65535, dataType, 0, status.getStatusCode(), ioid);
            this.requestMessage.putInt(alignedPayloadSize);
            this.requestMessage.putInt(dataCount);
        }
        DBREncoder.insertPayload(this.requestMessage, dataType, dataCount, value);
        this.requestMessage.position(alignedMessageSize);
        this.requestMessage = EventAddRequest.alignBuffer(8, this.requestMessage);
    }

    public byte getPriority() {
        return 100;
    }
}

