/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas.requests;

import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.requests.AbstractCARequest;
import gov.aps.jca.CAStatus;
import java.nio.ByteBuffer;

public class ExceptionRequest
extends AbstractCARequest {
    public ExceptionRequest(Transport transport, int cid, CAStatus errorCode, ByteBuffer previousHeader, String errorMessage) {
        super(transport);
        int binaryMessageLength = 0;
        if (errorMessage != null) {
            binaryMessageLength = errorMessage.length() + 1;
        }
        int alignedMessageSize = ExceptionRequest.calculateAlignedSize(8, 16 + previousHeader.remaining() + binaryMessageLength);
        this.requestMessage = ByteBuffer.allocate(alignedMessageSize);
        this.requestMessage = ExceptionRequest.insertCAHeader(transport, this.requestMessage, (short)11, (short)(alignedMessageSize - 16), (short)0, 0, cid, errorCode.getStatusCode());
        this.requestMessage.put(previousHeader);
        if (binaryMessageLength > 0) {
            this.requestMessage.put(errorMessage.getBytes());
            this.requestMessage.put((byte)0);
        }
        this.requestMessage = ExceptionRequest.alignBuffer(8, this.requestMessage);
    }

    public byte getPriority() {
        return 100;
    }
}

