/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas.requests;

import com.cosylab.epics.caj.impl.DBREncoder;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.requests.AbstractCARequest;
import gov.aps.jca.dbr.DBR;
import java.nio.ByteBuffer;

public class ReadNotifyRequest
extends AbstractCARequest {
    public ReadNotifyRequest(Transport transport, int sid, int ioid, int dataType, int dataCount, DBR value) {
        super(transport);
        boolean extendedHeader;
        int calculatedPayloadSize = 0;
        if (value != null) {
            calculatedPayloadSize = DBREncoder.calculatePayloadSize((short)dataType, dataCount, value.getValue());
        }
        int alignedPayloadSize = ReadNotifyRequest.calculateAlignedSize(8, calculatedPayloadSize);
        int alignedMessageSize = alignedPayloadSize + 16;
        boolean bl = extendedHeader = calculatedPayloadSize >= 65535 || dataCount >= 65535;
        if (extendedHeader) {
            if (transport.getMinorRevision() < 9) {
                throw new IllegalStateException("Message payload size " + alignedPayloadSize + " or element count " + dataCount + " out of bounds for CA revision " + transport.getMinorRevision() + ".");
            }
            alignedMessageSize += 8;
        }
        this.requestMessage = ByteBuffer.allocate(alignedMessageSize);
        if (!extendedHeader) {
            this.requestMessage = ReadNotifyRequest.insertCAHeader(transport, this.requestMessage, (short)15, alignedPayloadSize, (short)dataType, dataCount, sid, ioid);
        } else {
            this.requestMessage = ReadNotifyRequest.insertCAHeader(transport, this.requestMessage, (short)15, 65535, (short)dataType, 0, sid, ioid);
            this.requestMessage.putInt(alignedPayloadSize);
            this.requestMessage.putInt(dataCount);
        }
        if (value != null) {
            DBREncoder.insertPayload(this.requestMessage, (short)dataType, dataCount, value);
        }
        this.requestMessage.position(alignedMessageSize);
        this.requestMessage = ReadNotifyRequest.alignBuffer(8, this.requestMessage);
    }

    public byte getPriority() {
        return 100;
    }
}

