/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl;

import com.cosylab.epics.caj.impl.BroadcastTransport;
import com.cosylab.epics.caj.impl.CAContext;
import com.cosylab.epics.caj.impl.ConnectionException;
import com.cosylab.epics.caj.impl.Connector;
import com.cosylab.epics.caj.impl.ResponseHandler;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.TransportClient;
import com.cosylab.epics.caj.impl.reactor.ReactorHandler;
import com.cosylab.epics.caj.impl.reactor.lf.LeaderFollowersHandler;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public class BroadcastConnector
implements Connector {
    private CAContext context;

    public BroadcastConnector(CAContext context) {
        this.context = context;
    }

    public Transport connect(TransportClient client, ResponseHandler responseHandler, InetSocketAddress connectAddress, short transportRevision, short priority) throws ConnectionException {
        this.context.getLogger().finer("Creating datagram socket to: " + connectAddress);
        DatagramChannel socket = null;
        try {
            BroadcastTransport transport;
            socket = DatagramChannel.open();
            socket.configureBlocking(false);
            socket.socket().setBroadcast(true);
            ReactorHandler handler = transport = new BroadcastTransport(this.context, responseHandler, socket, connectAddress, transportRevision);
            if (this.context.getLeaderFollowersThreadPool() != null) {
                handler = new LeaderFollowersHandler(this.context.getReactor(), handler, this.context.getLeaderFollowersThreadPool());
            }
            this.context.getReactor().register(socket, 1, handler);
            return transport;
        }
        catch (Throwable th) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw new ConnectionException("Failed to connect to '" + connectAddress + "'.", connectAddress, th);
        }
    }
}

