/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl;

import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.impl.ResponseHandler;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.handlers.AccessRightsResponse;
import com.cosylab.epics.caj.impl.handlers.BadResponse;
import com.cosylab.epics.caj.impl.handlers.BeaconResponse;
import com.cosylab.epics.caj.impl.handlers.ChannelDisconnectedResponse;
import com.cosylab.epics.caj.impl.handlers.ClearChannelResponse;
import com.cosylab.epics.caj.impl.handlers.CreateChannelFailedResponse;
import com.cosylab.epics.caj.impl.handlers.CreateChannelResponse;
import com.cosylab.epics.caj.impl.handlers.EchoResponse;
import com.cosylab.epics.caj.impl.handlers.EventAddResponse;
import com.cosylab.epics.caj.impl.handlers.EventCancelResponse;
import com.cosylab.epics.caj.impl.handlers.ExceptionResponse;
import com.cosylab.epics.caj.impl.handlers.NoopResponse;
import com.cosylab.epics.caj.impl.handlers.ReadNotifyResponse;
import com.cosylab.epics.caj.impl.handlers.RepeaterConfirmResponse;
import com.cosylab.epics.caj.impl.handlers.SearchResponse;
import com.cosylab.epics.caj.impl.handlers.VersionResponse;
import com.cosylab.epics.caj.impl.handlers.WriteNotifyResponse;
import com.cosylab.epics.caj.util.HexDump;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public class CAResponseHandler
implements ResponseHandler {
    private ResponseHandler[] handlerTable;
    private CAJContext context;

    public CAResponseHandler(CAJContext context) {
        this.context = context;
        this.intializeHandlerTable();
    }

    private void intializeHandlerTable() {
        BadResponse badResponse = new BadResponse(this.context);
        this.handlerTable = new ResponseHandler[]{new VersionResponse(this.context), new EventAddResponse(this.context), new EventCancelResponse(this.context), badResponse, badResponse, badResponse, new SearchResponse(this.context), badResponse, badResponse, badResponse, badResponse, new ExceptionResponse(this.context), new ClearChannelResponse(this.context), new BeaconResponse(this.context), new NoopResponse(this.context, "Channel not found"), new ReadNotifyResponse(this.context), badResponse, new RepeaterConfirmResponse(this.context), new CreateChannelResponse(this.context), new WriteNotifyResponse(this.context), badResponse, badResponse, new AccessRightsResponse(this.context), new EchoResponse(this.context), badResponse, badResponse, new CreateChannelFailedResponse(this.context), new ChannelDisconnectedResponse(this.context)};
    }

    public void handleResponse(InetSocketAddress responseFrom, Transport transport, ByteBuffer[] response) {
        ByteBuffer headerBuffer = response[0];
        int headerBufferSize = headerBuffer.limit() - headerBuffer.position();
        if (headerBufferSize < 16) {
            this.context.getLogger().fine("Invalid response header (16 bytes expected, " + headerBufferSize + " received) from " + responseFrom + ".");
            HexDump.hexDump("Invalid CA Header", headerBuffer.array(), headerBuffer.position(), headerBufferSize);
            headerBuffer.position(headerBuffer.limit());
            return;
        }
        short commandID = headerBuffer.getShort(headerBuffer.position());
        if (commandID < 0 || commandID >= this.handlerTable.length) {
            this.context.getLogger().fine("Invalid (or unsupported) command: " + commandID + ".");
            HexDump.hexDump("Invalid CA Header", headerBuffer.array(), headerBuffer.position(), headerBufferSize);
            headerBuffer.position(headerBuffer.limit());
            return;
        }
        this.handlerTable[commandID].handleResponse(responseFrom, transport, response);
    }
}

