/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl;

import com.cosylab.epics.caj.CAJChannel;
import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.impl.requests.VersionRequest;
import com.cosylab.epics.caj.util.ArrayFIFO;
import com.cosylab.epics.caj.util.Timer;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;

public class ChannelSearchManager {
    private static final int MAX_FRAMES_PER_TRY = 64;
    private static final long MIN_RTT = 32L;
    private static final long MAX_RTT = 64L;
    private static final double SUCCESS_RATE = 0.9;
    private CAJContext context;
    private volatile boolean canceled = false;
    private volatile double rttmean = 32.0;
    private SearchTimer[] timers;
    private int beaconAnomalyTimerIndex;
    private volatile int sequenceNumber = 0;
    private static final long MAX_SEARCH_PERIOD = 300000L;
    private static final long MAX_SEARCH_PERIOD_LOWER_LIMIT = 60000L;
    private static final long BEACON_ANOMALY_SEARCH_PERIOD = 5000L;
    private static final int MAX_TIMERS = 18;
    private ByteBuffer sendBuffer;
    private volatile long timeAtLastSend;
    private Set channels = new HashSet();

    public ChannelSearchManager(CAJContext context) {
        this.context = context;
        this.sendBuffer = ByteBuffer.allocateDirect(1024);
        this.initializeSendBuffer();
        long maxPeriod = 300000L;
        maxPeriod = Math.min(maxPeriod, 60000L);
        double powerOfTwo = Math.log((double)maxPeriod / 32.0) / Math.log(2.0);
        int numberOfTimers = (int)(powerOfTwo + 1.0);
        numberOfTimers = Math.min(numberOfTimers, 18);
        powerOfTwo = Math.log(156.25) / Math.log(2.0);
        this.beaconAnomalyTimerIndex = (int)(powerOfTwo + 1.0);
        this.beaconAnomalyTimerIndex = Math.min(this.beaconAnomalyTimerIndex, numberOfTimers - 1);
        this.timers = new SearchTimer[numberOfTimers];
        for (int i = 0; i < numberOfTimers; ++i) {
            this.timers[i] = new SearchTimer(i, i > this.beaconAnomalyTimerIndex, i != numberOfTimers - 1);
        }
    }

    public synchronized void cancel() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        if (this.timers != null) {
            for (int i = 0; i < this.timers.length; ++i) {
                this.timers[i].shutdown();
            }
        }
    }

    private void initializeSendBuffer() {
        this.sendBuffer.clear();
        ++this.sequenceNumber;
        VersionRequest.generateVersionRequestMessage(this.context.getBroadcastTransport(), this.sendBuffer, (short)0, this.sequenceNumber, true);
    }

    private synchronized void flushSendBuffer() {
        this.timeAtLastSend = System.currentTimeMillis();
        this.context.getBroadcastTransport().send(this.sendBuffer);
        this.initializeSendBuffer();
    }

    private synchronized boolean generateSearchRequestMessage(CAJChannel channel, boolean allowNewFrame) {
        boolean success = channel.generateSearchRequestMessage(this.context.getBroadcastTransport(), this.sendBuffer);
        if (!success) {
            this.flushSendBuffer();
            if (allowNewFrame) {
                channel.generateSearchRequestMessage(this.context.getBroadcastTransport(), this.sendBuffer);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registeredChannelCount() {
        Set set = this.channels;
        synchronized (set) {
            return this.channels.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChannel(CAJChannel channel) {
        if (this.canceled) {
            return;
        }
        Set set = this.channels;
        synchronized (set) {
            if (this.channels.contains(channel)) {
                return;
            }
            this.channels.add(channel);
            this.timers[0].installChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterChannel(CAJChannel channel) {
        Set set = this.channels;
        synchronized (set) {
            if (!this.channels.contains(channel)) {
                return;
            }
            this.channels.remove(channel);
            channel.removeAndUnsetListOwnership();
        }
    }

    public void searchResponse(CAJChannel channel, int responseSequenceNumber, boolean isSequenceNumberValid, long responseTime) {
        int timerIndex = channel.getOwnerIndex();
        this.unregisterChannel(channel);
        this.timers[timerIndex].searchResponse(responseSequenceNumber, isSequenceNumberValid, responseTime);
    }

    private void searchResponseTimeout(CAJChannel channel, int timerIndex) {
        int newTimerIndex = Math.min(++timerIndex, this.timers.length - 1);
        this.timers[newTimerIndex].installChannel(channel);
    }

    public void beaconAnomalyNotify() {
        for (int i = this.beaconAnomalyTimerIndex + 1; i < this.timers.length; ++i) {
            this.timers[i].moveChannels(this.timers[this.beaconAnomalyTimerIndex]);
        }
    }

    private void boostSearching(CAJChannel channel, int timerIndex) {
        this.timers[timerIndex].installChannel(channel);
    }

    private final void updateRTTE(long rtt) {
        double error = (double)rtt - this.rttmean;
        this.rttmean += error / 4.0;
    }

    private final double getRTTE() {
        return Math.min(Math.max(this.rttmean, 32.0), 64.0);
    }

    private final int getSequenceNumber() {
        return this.sequenceNumber;
    }

    private final long getTimeAtLastSend() {
        return this.timeAtLastSend;
    }

    private class SearchTimer
    implements Timer.TimerRunnable {
        volatile int searchAttempts = 0;
        volatile int searchRespones = 0;
        double framesPerTry = 1.0;
        double framesPerTryCongestThresh = Double.MAX_VALUE;
        volatile int startSequenceNumber = 0;
        volatile int endSequenceNumber = 0;
        final int timerIndex;
        final boolean allowBoost;
        final boolean allowSlowdown;
        final ArrayFIFO requestPendingChannels = new ArrayFIFO();
        final ArrayFIFO responsePendingChannels = new ArrayFIFO();
        Object timerTaskID = null;
        volatile boolean canceled = false;
        long timeAtResponseCheck = 0L;

        public SearchTimer(int timerIndex, boolean allowBoost, boolean allowSlowdown) {
            this.timerIndex = timerIndex;
            this.allowBoost = allowBoost;
            this.allowSlowdown = allowSlowdown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void shutdown() {
            if (this.canceled) {
                return;
            }
            this.canceled = true;
            ArrayFIFO arrayFIFO = this.requestPendingChannels;
            synchronized (arrayFIFO) {
                if (this.timerTaskID != null) {
                    Timer.cancel(this.timerTaskID);
                    this.timerTaskID = null;
                }
            }
            this.requestPendingChannels.clear();
            this.responsePendingChannels.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void installChannel(CAJChannel channel) {
            if (this.canceled) {
                return;
            }
            ArrayFIFO arrayFIFO = this.requestPendingChannels;
            synchronized (arrayFIFO) {
                boolean startImmediately = this.requestPendingChannels.isEmpty();
                channel.addAndSetListOwnership(this.requestPendingChannels, this.timerIndex);
                if (startImmediately) {
                    if (this.timerTaskID != null) {
                        Timer.cancel(this.timerTaskID);
                    }
                    if (this.timeAtResponseCheck == 0L) {
                        this.timeAtResponseCheck = System.currentTimeMillis();
                    }
                    this.timerTaskID = ChannelSearchManager.this.context.getTimer().executeAfterDelay(10L, this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void moveChannels(SearchTimer destination) {
            CAJChannel channel;
            while ((channel = (CAJChannel)this.responsePendingChannels.pop()) != null) {
                if (this.searchAttempts > 0) {
                    --this.searchAttempts;
                }
                destination.installChannel(channel);
            }
            ArrayFIFO arrayFIFO = this.requestPendingChannels;
            synchronized (arrayFIFO) {
                while (!this.requestPendingChannels.isEmpty()) {
                    destination.installChannel((CAJChannel)this.requestPendingChannels.pop());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeout(long timeoutTime) {
            CAJChannel channel;
            long now;
            if (this.canceled) {
                return;
            }
            ArrayFIFO arrayFIFO = this.requestPendingChannels;
            synchronized (arrayFIFO) {
                this.timerTaskID = null;
            }
            if (this.allowBoost && this.searchRespones > 0) {
                arrayFIFO = this.requestPendingChannels;
                synchronized (arrayFIFO) {
                    while (!this.requestPendingChannels.isEmpty()) {
                        CAJChannel channel2 = (CAJChannel)this.requestPendingChannels.peek();
                        int boostIndex = ChannelSearchManager.this.beaconAnomalyTimerIndex;
                        if (channel2.getOwnerIndex() <= boostIndex) continue;
                        this.requestPendingChannels.pop();
                        channel2.unsetListOwnership();
                        ChannelSearchManager.this.boostSearching(channel2, boostIndex);
                    }
                }
            }
            if ((now = System.currentTimeMillis()) - this.timeAtResponseCheck >= this.period()) {
                this.timeAtResponseCheck = now;
                while ((channel = (CAJChannel)this.responsePendingChannels.pop()) != null) {
                    if (this.allowSlowdown) {
                        channel.unsetListOwnership();
                        ChannelSearchManager.this.searchResponseTimeout(channel, this.timerIndex);
                        continue;
                    }
                    channel.addAndSetListOwnership(this.requestPendingChannels, this.timerIndex);
                }
                if (this.searchAttempts > 0) {
                    if ((double)this.searchRespones >= (double)this.searchAttempts * 0.9) {
                        if (this.framesPerTry < 64.0) {
                            this.framesPerTry = this.framesPerTry < this.framesPerTryCongestThresh ? Math.min(2.0 * this.framesPerTry, this.framesPerTryCongestThresh) : (this.framesPerTry += 1.0 / this.framesPerTry);
                        }
                    } else {
                        this.framesPerTryCongestThresh = this.framesPerTry / 2.0;
                        this.framesPerTry = 1.0;
                    }
                }
            }
            this.startSequenceNumber = ChannelSearchManager.this.getSequenceNumber();
            this.searchAttempts = 0;
            this.searchRespones = 0;
            int framesSent = 0;
            int triesInFrame = 0;
            while ((channel = (CAJChannel)this.requestPendingChannels.pop()) != null) {
                boolean frameWasSent;
                channel.unsetListOwnership();
                boolean requestSent = true;
                boolean allowNewFrame = (double)(framesSent + 1) < this.framesPerTry;
                this.endSequenceNumber = ChannelSearchManager.this.getSequenceNumber() + 1;
                try {
                    frameWasSent = ChannelSearchManager.this.generateSearchRequestMessage(channel, allowNewFrame);
                }
                catch (Throwable th) {
                    channel.addAndSetListOwnership(this.responsePendingChannels, this.timerIndex);
                    break;
                }
                if (frameWasSent) {
                    ++framesSent;
                    triesInFrame = 0;
                    if (!allowNewFrame) {
                        channel.addAndSetListOwnership(this.requestPendingChannels, this.timerIndex);
                        requestSent = false;
                    } else {
                        ++triesInFrame;
                    }
                } else {
                    ++triesInFrame;
                }
                if (requestSent) {
                    channel.addAndSetListOwnership(this.responsePendingChannels, this.timerIndex);
                    if (this.searchAttempts < Integer.MAX_VALUE) {
                        ++this.searchAttempts;
                    }
                }
                if (triesInFrame != 0 || allowNewFrame) continue;
                break;
            }
            if (triesInFrame > 0) {
                try {
                    this.endSequenceNumber = ChannelSearchManager.this.getSequenceNumber() + 1;
                    ChannelSearchManager.this.flushSendBuffer();
                    ++framesSent;
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
            this.endSequenceNumber = ChannelSearchManager.this.getSequenceNumber();
            ArrayFIFO arrayFIFO2 = this.requestPendingChannels;
            synchronized (arrayFIFO2) {
                if (!this.canceled && this.timerTaskID == null) {
                    boolean someWorkToDo;
                    boolean bl = someWorkToDo = !this.requestPendingChannels.isEmpty() || !this.responsePendingChannels.isEmpty();
                    if (someWorkToDo) {
                        this.timerTaskID = ChannelSearchManager.this.context.getTimer().executeAfterDelay(this.period(), this);
                    }
                }
            }
        }

        public void searchResponse(int responseSequenceNumber, boolean isSequenceNumberValid, long responseTime) {
            if (this.canceled) {
                return;
            }
            boolean validResponse = true;
            if (isSequenceNumberValid) {
                boolean bl = validResponse = this.startSequenceNumber <= ChannelSearchManager.this.sequenceNumber && ChannelSearchManager.this.sequenceNumber <= this.endSequenceNumber;
            }
            if (validResponse) {
                long dt = responseTime - ChannelSearchManager.this.getTimeAtLastSend();
                ChannelSearchManager.this.updateRTTE(dt);
                if (this.searchRespones < Integer.MAX_VALUE) {
                    ++this.searchRespones;
                    if (this.searchRespones == this.searchAttempts && this.requestPendingChannels.size() > 0) {
                        if (this.timerTaskID != null) {
                            Timer.cancel(this.timerTaskID);
                        }
                        this.timerTaskID = ChannelSearchManager.this.context.getTimer().executeAfterDelay(0L, this);
                    }
                }
            }
        }

        public final long period() {
            return (long)((double)(1 << this.timerIndex) * ChannelSearchManager.this.getRTTE());
        }
    }
}

