/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl.handlers;

import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.impl.ExceptionHandler;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.handlers.AbstractCAJResponseHandler;
import com.cosylab.epics.caj.impl.handlers.ResponseRequestExceptionHandler;
import gov.aps.jca.CAStatus;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public class ExceptionResponse
extends AbstractCAJResponseHandler
implements ExceptionHandler {
    private ExceptionHandler[] handlerTable;
    protected boolean debug = false;

    public ExceptionResponse(CAJContext context) {
        super(context, "Exception respone");
        this.intializeHandlerTable();
        this.debug = System.getProperties().containsKey("CAJ_DEBUG");
    }

    private void intializeHandlerTable() {
        ExceptionResponse defaultException = this;
        ResponseRequestExceptionHandler rreh = new ResponseRequestExceptionHandler(this.context);
        this.handlerTable = new ExceptionHandler[]{defaultException, rreh, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, rreh, defaultException, defaultException, defaultException, rreh, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException};
    }

    protected void internalHandleResponse(InetSocketAddress responseFrom, Transport transport, ByteBuffer[] response) {
        int commandID;
        ByteBuffer originalHeaderBuffer = null;
        String errorMessage = null;
        ByteBuffer payloadBuffer = response.length == 1 ? response[0] : response[1];
        int payloadStart = payloadBuffer.position();
        if (this.payloadSize > 16) {
            int originalHeaderPayloadSize = payloadBuffer.getShort(payloadStart + 2) & 0xFFFF;
            int originalHeaderSize = originalHeaderPayloadSize == 65535 ? 24 : 16;
            originalHeaderBuffer = ByteBuffer.wrap(payloadBuffer.array(), payloadStart, originalHeaderSize);
            int errorMessageEnd = payloadStart + originalHeaderSize;
            byte[] bufferArray = payloadBuffer.array();
            while (bufferArray[errorMessageEnd] != 0) {
                ++errorMessageEnd;
            }
            errorMessage = new String(bufferArray, payloadStart + originalHeaderSize, errorMessageEnd - payloadStart - originalHeaderSize);
        }
        payloadBuffer.position(payloadStart + this.payloadSize);
        int n = commandID = originalHeaderBuffer != null ? (int)originalHeaderBuffer.getShort(0) : -1;
        if (commandID < 0 || commandID >= this.handlerTable.length) {
            this.context.getLogger().fine("Invalid (or unsupported) exception command: " + commandID + ".");
            this.handleException(this.parameter2, this.parameter1, errorMessage, originalHeaderBuffer);
            return;
        }
        if (this.debug) {
            this.context.getLogger().fine("Exception occured, code: " + CAStatus.forStatusCode((int)this.parameter2) + ", message: '" + errorMessage + "'.");
        }
        this.handlerTable[commandID].handleException(this.parameter2, this.parameter1, errorMessage, originalHeaderBuffer);
    }

    public void handleException(int errorCode, int cid, String errorMessage, ByteBuffer originalHeaderBuffer) {
        this.context.getLogger().fine("Exception occured, code: " + CAStatus.forStatusCode((int)errorCode) + ", message: '" + errorMessage + "'.");
    }
}

