/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl.requests;

import com.cosylab.epics.caj.CAJChannel;
import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.CAJMonitor;
import com.cosylab.epics.caj.impl.DBRDecoder;
import com.cosylab.epics.caj.impl.NotifyResponseRequest;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.requests.AbstractCARequest;
import com.cosylab.epics.caj.impl.requests.SubscriptionUpdateRequest;
import gov.aps.jca.CAStatus;
import gov.aps.jca.Channel;
import gov.aps.jca.Context;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.event.ContextExceptionEvent;
import gov.aps.jca.event.MonitorEvent;
import gov.aps.jca.event.MonitorListener;
import java.io.IOException;
import java.nio.ByteBuffer;

public class EventAddRequest
extends AbstractCARequest
implements NotifyResponseRequest {
    protected CAJContext context;
    protected int subsid;
    protected CAJMonitor monitor;
    protected CAJChannel channel;
    protected byte priority = (byte)49;
    private boolean subscriptionUpdateNeeded = false;
    protected int requestedDataType;
    protected int requestedDataCount;

    public EventAddRequest(CAJChannel channel, CAJMonitor monitor, Transport transport, int sid, int dataType, int dataCount, int mask) {
        super(transport);
        this.channel = channel;
        this.monitor = monitor;
        this.requestedDataType = dataType;
        this.requestedDataCount = dataCount;
        this.context = (CAJContext)channel.getContext();
        this.subsid = this.context.registerResponseRequest(this);
        channel.registerResponseRequest(this);
        if (dataCount < 65535) {
            this.requestMessage = ByteBuffer.allocate(32);
            this.requestMessage = EventAddRequest.insertCAHeader(transport, this.requestMessage, (short)1, 16, (short)dataType, dataCount, sid, this.subsid);
        } else {
            this.requestMessage = ByteBuffer.allocate(40);
            this.requestMessage = EventAddRequest.insertCAHeader(transport, this.requestMessage, (short)1, 65535, (short)dataType, 0, sid, this.subsid);
            this.requestMessage.putInt(16);
            this.requestMessage.putInt(dataCount);
        }
        this.requestMessage.putFloat(0.0f);
        this.requestMessage.putFloat(0.0f);
        this.requestMessage.putFloat(0.0f);
        this.requestMessage.putShort((short)mask);
        this.requestMessage.putShort((short)0);
    }

    public void updateSubscription() throws IOException {
        if (this.subscriptionUpdateNeeded) {
            this.subscriptionUpdateNeeded = false;
            new SubscriptionUpdateRequest(this.transport, this.requestMessage.getInt(8), this.requestMessage.getInt(12), this.requestMessage.getShort(4), this.requestMessage.getShort(6)).submit();
        }
    }

    public void submit() throws IOException {
        if (this.transport == null) {
            return;
        }
        super.submit();
    }

    public void resubscribeSubscription(Transport transport) throws IOException {
        this.transport = transport;
        this.requestMessage.putInt(8, this.channel.getServerChannelID());
        this.priority = (byte)100;
        transport.submit(this);
    }

    public int getIOID() {
        return this.subsid;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void response(int status, short dataType, int dataCount, ByteBuffer dataPayloadBuffer) {
        DBR readVal = null;
        CAStatus caStatus = CAStatus.forStatusCode((int)status);
        if (caStatus == CAStatus.NORMAL) {
            this.subscriptionUpdateNeeded = false;
            if (dataPayloadBuffer.limit() <= 0) {
                this.cancel();
                return;
            }
            readVal = DBRDecoder.getDBR(readVal, dataType, dataCount, dataPayloadBuffer);
        } else {
            this.cancel();
        }
        this.context.getEventDispatcher().dispatch(new MonitorEvent((Channel)this.channel, readVal, caStatus), (MonitorListener)this.monitor);
    }

    public synchronized void cancel() {
        this.context.unregisterResponseRequest(this);
        this.channel.unregisterResponseRequest(this);
    }

    public void timeout() {
        this.cancel();
        this.context.getEventDispatcher().dispatch(new MonitorEvent((Channel)this.channel, null, CAStatus.TIMEOUT), (MonitorListener)this.monitor);
    }

    public void exception(int errorCode, String errorMessage) {
        CAStatus status = CAStatus.forStatusCode((int)errorCode);
        if (status == CAStatus.CHANDESTROY) {
            this.cancel();
            return;
        }
        if (this.monitor.isCleared()) {
            return;
        }
        this.subscriptionUpdateNeeded = true;
        if (status != CAStatus.DISCONN) {
            if (errorMessage == null && status != null) {
                errorMessage = status.getMessage();
            }
            ContextExceptionEvent cee = new ContextExceptionEvent((Context)this.context, (Channel)this.channel, DBRType.forValue((int)this.requestedDataType), this.requestedDataCount, null, errorMessage);
            this.context.notifyException(cee);
        }
    }

    public byte getPriority() {
        return this.priority;
    }
}

