/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl.requests;

import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.requests.AbstractCARequest;
import java.net.InetAddress;
import java.nio.ByteBuffer;

public class HostNameRequest
extends AbstractCARequest {
    private static String hostName = null;
    private static final String HOSTNAME_KEY = "HOSTNAME";

    private static synchronized String getHostName() {
        if (hostName == null) {
            int dotPos;
            hostName = "localhost";
            try {
                InetAddress localAddress = InetAddress.getLocalHost();
                hostName = localAddress.getHostName();
            }
            catch (Throwable uhe) {
                try {
                    String envHN = System.getenv(HOSTNAME_KEY);
                    if (envHN != null) {
                        hostName = envHN;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                hostName = System.getProperty(HOSTNAME_KEY, hostName);
            }
            if (System.getProperties().contains("CAJ_STRIP_HOSTNAME") && (dotPos = hostName.indexOf(46)) > 0) {
                hostName = hostName.substring(0, dotPos);
            }
        }
        return hostName;
    }

    public HostNameRequest(Transport transport) {
        super(transport);
        if (transport.getMinorRevision() < 1) {
            return;
        }
        String hostName = HostNameRequest.getHostName();
        int alignedMessageSize = HostNameRequest.calculateAlignedSize(8, 16 + hostName.length() + 1);
        this.requestMessage = ByteBuffer.allocate(alignedMessageSize);
        this.requestMessage = HostNameRequest.insertCAHeader(transport, this.requestMessage, (short)21, (short)(alignedMessageSize - 16), (short)0, 0, 0, 0);
        this.requestMessage.put(hostName.getBytes());
        this.requestMessage.put((byte)0);
        this.requestMessage = HostNameRequest.alignBuffer(8, this.requestMessage);
    }

    public byte getPriority() {
        return 100;
    }
}

