/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl.requests;

import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.requests.AbstractCARequest;
import java.nio.ByteBuffer;

public class SearchRequest
extends AbstractCARequest {
    public SearchRequest(Transport transport, String name, int cid) {
        super(transport);
        this.requestMessage = SearchRequest.generateSearchRequestMessage(transport, null, name, cid);
    }

    public static final ByteBuffer generateSearchRequestMessage(Transport transport, ByteBuffer requestMessage, String name, int cid) {
        if (name.length() > Math.min(1008, 65535)) {
            throw new IllegalArgumentException("name too long");
        }
        int alignedMessageSize = SearchRequest.calculateAlignedSize(8, 16 + name.length() + 1);
        if (requestMessage == null) {
            requestMessage = ByteBuffer.allocate(alignedMessageSize);
        } else if (requestMessage.remaining() < alignedMessageSize) {
            return null;
        }
        requestMessage = SearchRequest.insertCAHeader(transport, requestMessage, (short)6, (short)(alignedMessageSize - 16), (short)5, transport.getMinorRevision(), cid, cid);
        requestMessage.put(name.getBytes());
        requestMessage.put((byte)0);
        requestMessage = SearchRequest.alignBuffer(8, requestMessage);
        return requestMessage;
    }
}

