/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl.requests;

import com.cosylab.epics.caj.CAJChannel;
import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.impl.DBREncoder;
import com.cosylab.epics.caj.impl.NotifyResponseRequest;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.requests.AbstractCARequest;
import gov.aps.jca.CAStatus;
import gov.aps.jca.Channel;
import gov.aps.jca.Context;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.event.ContextExceptionEvent;
import gov.aps.jca.event.PutEvent;
import gov.aps.jca.event.PutListener;
import java.nio.ByteBuffer;

public class WriteNotifyRequest
extends AbstractCARequest
implements NotifyResponseRequest {
    protected CAJContext context;
    protected int ioid;
    protected PutListener callback;
    protected CAJChannel channel;
    protected int requestedDataType;
    protected int requestedDataCount;

    public WriteNotifyRequest(CAJChannel channel, PutListener callback, Transport transport, int sid, int dataType, int dataCount, Object value) {
        super(transport);
        boolean extendedHeader;
        this.channel = channel;
        this.callback = callback;
        this.requestedDataType = dataType;
        this.requestedDataCount = dataCount;
        this.context = (CAJContext)transport.getContext();
        this.ioid = this.context.registerResponseRequest(this);
        channel.registerResponseRequest(this);
        int calculatedPayloadSize = DBREncoder.calculatePayloadSize((short)dataType, dataCount, value);
        int alignedPayloadSize = WriteNotifyRequest.calculateAlignedSize(8, calculatedPayloadSize);
        int alignedMessageSize = alignedPayloadSize + 16;
        boolean bl = extendedHeader = calculatedPayloadSize >= 65535 || dataCount >= 65535;
        if (extendedHeader) {
            if (transport.getMinorRevision() < 9) {
                throw new IllegalStateException("Message payload size " + alignedPayloadSize + " or element count " + dataCount + " out of bounds for CA revision " + transport.getMinorRevision() + ".");
            }
            alignedMessageSize += 8;
        }
        this.requestMessage = ByteBuffer.allocate(alignedMessageSize);
        if (!extendedHeader) {
            this.requestMessage = WriteNotifyRequest.insertCAHeader(transport, this.requestMessage, (short)19, alignedPayloadSize, (short)dataType, dataCount, sid, this.ioid);
        } else {
            this.requestMessage = WriteNotifyRequest.insertCAHeader(transport, this.requestMessage, (short)19, 65535, (short)dataType, 0, sid, this.ioid);
            this.requestMessage.putInt(alignedPayloadSize);
            this.requestMessage.putInt(dataCount);
        }
        DBREncoder.insertPayload(this.requestMessage, (short)dataType, dataCount, value);
        this.requestMessage = WriteNotifyRequest.alignBuffer(8, this.requestMessage);
    }

    public int getIOID() {
        return this.ioid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void response(int status, short dataType, int dataCount, ByteBuffer dataPayloadBuffer) {
        try {
            if (this.callback != null) {
                DBRType type = DBRType.forValue((int)dataType);
                CAStatus caStatus = CAStatus.forStatusCode((int)status);
                this.context.getEventDispatcher().dispatch(new PutEvent((Channel)this.channel, type, dataCount, caStatus), this.callback);
            }
        }
        finally {
            this.cancel();
        }
    }

    public void cancel() {
        this.context.unregisterResponseRequest(this);
        this.channel.unregisterResponseRequest(this);
    }

    public void timeout() {
        this.cancel();
        if (this.callback != null) {
            this.context.getEventDispatcher().dispatch(new PutEvent((Channel)this.channel, DBRType.UNKNOWN, 0, CAStatus.TIMEOUT), this.callback);
        }
    }

    public void exception(int errorCode, String errorMessage) {
        CAStatus status;
        this.cancel();
        if (errorMessage == null && (status = CAStatus.forStatusCode((int)errorCode)) != null) {
            errorMessage = status.getMessage();
        }
        ContextExceptionEvent cee = new ContextExceptionEvent((Context)this.context, (Channel)this.channel, DBRType.forValue((int)this.requestedDataType), this.requestedDataCount, null, errorMessage);
        this.context.notifyException(cee);
    }
}

