/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import java.util.concurrent.locks.ReentrantLock;
import org.epics.pvaClient.PvaClient;
import org.epics.pvaClient.PvaClientChannel;
import org.epics.pvaClient.PvaClientMultiGetDouble;
import org.epics.pvaClient.PvaClientMultiMonitorDouble;
import org.epics.pvaClient.PvaClientMultiPutDouble;
import org.epics.pvaClient.PvaClientNTMultiGet;
import org.epics.pvaClient.PvaClientNTMultiMonitor;
import org.epics.pvaClient.PvaClientNTMultiPut;
import org.epics.pvaccess.client.Channel;
import org.epics.pvdata.copy.CreateRequest;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;

public class PvaClientMultiChannel {
    private static final StatusCreate statusCreate = StatusFactory.getStatusCreate();
    private final CreateRequest createRequest = CreateRequest.create();
    private final PvaClient pvaClient;
    private final String[] channelName;
    private final String providerName;
    private final int maxNotConnected;
    private final int numChannel;
    private final ReentrantLock lock = new ReentrantLock();
    private int numConnected = 0;
    private PvaClientChannel[] pvaClientChannelArray;
    boolean[] isConnected;
    boolean isDestroyed = false;

    public static PvaClientMultiChannel create(PvaClient pvaClient, String[] channelNames) {
        return PvaClientMultiChannel.create(pvaClient, channelNames, "pva", 0);
    }

    public static PvaClientMultiChannel create(PvaClient pvaClient, String[] channelNames, String providerName) {
        return PvaClientMultiChannel.create(pvaClient, channelNames, providerName, 0);
    }

    public static PvaClientMultiChannel create(PvaClient pvaClient, String[] channelNames, String providerName, int maxNotConnected) {
        return new PvaClientMultiChannel(pvaClient, channelNames, providerName, maxNotConnected);
    }

    private PvaClientMultiChannel(PvaClient pvaClient, String[] channelNames, String providerName, int maxNotConnected) {
        this.pvaClient = pvaClient;
        this.channelName = channelNames;
        this.providerName = providerName;
        this.maxNotConnected = maxNotConnected;
        this.numChannel = this.channelName.length;
        this.pvaClientChannelArray = new PvaClientChannel[this.numChannel];
        this.isConnected = new boolean[this.numChannel];
        for (int i = 0; i < this.numChannel; ++i) {
            this.pvaClientChannelArray[i] = null;
            this.isConnected[i] = false;
        }
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientMultiChannel::PvaClientMultiChannel()");
        }
    }

    private void checkConnected() {
        if (this.numConnected == 0) {
            this.connect();
        }
    }

    public void destroy() {
        this.lock.lock();
        try {
            if (this.isDestroyed) {
                return;
            }
            this.isDestroyed = true;
        }
        finally {
            this.lock.unlock();
        }
        for (int i = 0; i < this.numChannel; ++i) {
            if (this.pvaClientChannelArray != null) {
                this.pvaClientChannelArray[i].destroy();
            }
            this.pvaClientChannelArray[i] = null;
        }
        this.pvaClientChannelArray = null;
    }

    public String[] getChannelNames() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMultiChannel was destroyed");
        }
        return this.channelName;
    }

    public Status connect() {
        return this.connect(5.0);
    }

    public Status connect(double timeout) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMultiChannel was destroyed");
        }
        for (int i = 0; i < this.numChannel; ++i) {
            this.pvaClientChannelArray[i] = this.pvaClient.createChannel(this.channelName[i], this.providerName);
            this.pvaClientChannelArray[i].issueConnect();
        }
        Status returnStatus = statusCreate.getStatusOK();
        Status status = statusCreate.getStatusOK();
        int numBad = 0;
        for (int i = 0; i < this.numChannel; ++i) {
            status = numBad == 0 ? this.pvaClientChannelArray[i].waitConnect(timeout) : this.pvaClientChannelArray[i].waitConnect(0.001);
            if (status.isOK()) {
                ++this.numConnected;
                this.isConnected[i] = true;
                continue;
            }
            if (returnStatus.isOK()) {
                returnStatus = status;
            }
            if (++numBad > this.maxNotConnected) break;
        }
        return numBad > this.maxNotConnected ? returnStatus : statusCreate.getStatusOK();
    }

    public boolean allConnected() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMultiChannel was destroyed");
        }
        return this.numConnected == this.numChannel;
    }

    public boolean connectionChange() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMultiChannel was destroyed");
        }
        for (int i = 0; i < this.numChannel; ++i) {
            boolean connectedNow;
            PvaClientChannel pvaClientChannel = this.pvaClientChannelArray[i];
            Channel channel = pvaClientChannel.getChannel();
            Channel.ConnectionState stateNow = channel.getConnectionState();
            boolean bl = connectedNow = stateNow == Channel.ConnectionState.CONNECTED;
            if (connectedNow == this.isConnected[i]) continue;
            return true;
        }
        return false;
    }

    public boolean[] getIsConnected() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMultiChannel was destroyed");
        }
        for (int i = 0; i < this.numChannel; ++i) {
            Channel channel;
            Channel.ConnectionState stateNow;
            PvaClientChannel pvaClientChannel = this.pvaClientChannelArray[i];
            this.isConnected[i] = pvaClientChannel == null ? false : (stateNow = (channel = pvaClientChannel.getChannel()).getConnectionState()) == Channel.ConnectionState.CONNECTED;
        }
        return this.isConnected;
    }

    public PvaClientChannel[] getPvaClientChannelArray() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMultiChannel was destroyed");
        }
        return this.pvaClientChannelArray;
    }

    public PvaClient getPvaClient() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMultiChannel was destroyed");
        }
        return this.pvaClient;
    }

    public PvaClientMultiGetDouble createGet() {
        this.checkConnected();
        return PvaClientMultiGetDouble.create(this, this.pvaClientChannelArray);
    }

    public PvaClientMultiPutDouble createPut() {
        this.checkConnected();
        return PvaClientMultiPutDouble.create(this, this.pvaClientChannelArray);
    }

    public PvaClientMultiMonitorDouble createMonitor() {
        this.checkConnected();
        return PvaClientMultiMonitorDouble.create(this, this.pvaClientChannelArray);
    }

    public PvaClientNTMultiPut createNTPut() {
        this.checkConnected();
        return PvaClientNTMultiPut.create(this, this.pvaClientChannelArray);
    }

    public PvaClientNTMultiGet createNTGet() {
        return this.createNTGet("value,alarm,timeStamp");
    }

    public PvaClientNTMultiGet createNTGet(String request) {
        this.checkConnected();
        PVStructure pvRequest = this.createRequest.createRequest(request);
        if (pvRequest == null) {
            String message = " PvaClientMultiChannel::createNTGet invalid pvRequest: " + this.createRequest.getMessage();
            throw new RuntimeException(message);
        }
        return PvaClientNTMultiGet.create(this, this.pvaClientChannelArray, pvRequest);
    }

    public PvaClientNTMultiMonitor createNTMonitor() {
        return this.createNTMonitor("value,alarm,timeStamp");
    }

    public PvaClientNTMultiMonitor createNTMonitor(String request) {
        this.checkConnected();
        PVStructure pvRequest = this.createRequest.createRequest(request);
        if (pvRequest == null) {
            String message = " PvaClientMultiChannel::createNTMonitor invalid pvRequest: " + this.createRequest.getMessage();
            throw new RuntimeException(message);
        }
        return PvaClientNTMultiMonitor.create(this, this.pvaClientChannelArray, pvRequest);
    }
}

