/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import java.util.concurrent.locks.ReentrantLock;
import org.epics.pvaClient.PvaClient;
import org.epics.pvaClient.PvaClientChannel;
import org.epics.pvaClient.PvaClientGet;
import org.epics.pvaClient.PvaClientMultiChannel;
import org.epics.pvaClient.PvaClientNTMultiData;
import org.epics.pvdata.factory.FieldFactory;
import org.epics.pvdata.pv.FieldCreate;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.Union;

public class PvaClientNTMultiGet {
    private static final FieldCreate fieldCreate = FieldFactory.getFieldCreate();
    private final PvaClientMultiChannel pvaClientMultiChannel;
    private final PvaClientChannel[] pvaClientChannelArray;
    private final int nchannel;
    private final ReentrantLock lock = new ReentrantLock();
    private final PVStructure pvRequest;
    private PvaClientNTMultiData pvaClientNTMultiData;
    private PvaClientGet[] pvaClientGet;
    private boolean isConnected = false;
    private boolean isDestroyed = false;

    public static PvaClientNTMultiGet create(PvaClientMultiChannel pvaClientMultiChannel, PvaClientChannel[] pvaClientChannelArray, PVStructure pvRequest) {
        Union u = fieldCreate.createVariantUnion();
        return new PvaClientNTMultiGet(u, pvaClientMultiChannel, pvaClientChannelArray, pvRequest);
    }

    public void destroy() {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientNTMultiGet::destroy()");
        }
        this.lock.lock();
        try {
            if (this.isDestroyed) {
                return;
            }
            this.isDestroyed = true;
        }
        finally {
            this.lock.unlock();
        }
        for (int i = 0; i < this.nchannel; ++i) {
            this.pvaClientChannelArray[i] = null;
        }
    }

    public void connect() {
        int i;
        boolean[] isConnected = this.pvaClientMultiChannel.getIsConnected();
        String request = "value";
        if (this.pvRequest.getSubField("field.alarm") != null) {
            request = request + ",alarm";
        }
        if (this.pvRequest.getSubField("field.timeStamp") != null) {
            request = request + ",timeStamp";
        }
        for (i = 0; i < this.nchannel; ++i) {
            if (!isConnected[i]) continue;
            this.pvaClientGet[i] = this.pvaClientChannelArray[i].createGet(request);
            this.pvaClientGet[i].issueConnect();
        }
        for (i = 0; i < this.nchannel; ++i) {
            Status status;
            if (!isConnected[i] || (status = this.pvaClientGet[i].waitConnect()).isOK()) continue;
            String message = "channel " + this.pvaClientChannelArray[i].getChannelName() + " PvaChannelGet::waitConnect " + status.getMessage();
            throw new RuntimeException(message);
        }
        this.isConnected = true;
    }

    public void get() {
        int i;
        if (!this.isConnected) {
            this.connect();
        }
        boolean[] isConnected = this.pvaClientMultiChannel.getIsConnected();
        for (i = 0; i < this.nchannel; ++i) {
            if (!isConnected[i]) continue;
            this.pvaClientGet[i].issueGet();
        }
        for (i = 0; i < this.nchannel; ++i) {
            Status status;
            if (!isConnected[i] || (status = this.pvaClientGet[i].waitGet()).isOK()) continue;
            String message = "channel " + this.pvaClientChannelArray[i].getChannelName() + " PvaChannelGet::waitGet " + status.getMessage();
            throw new RuntimeException(message);
        }
        this.pvaClientNTMultiData.startDeltaTime();
        for (i = 0; i < this.nchannel; ++i) {
            if (!isConnected[i]) continue;
            this.pvaClientNTMultiData.setPVStructure(this.pvaClientGet[i].getData().getPVStructure(), i);
        }
        this.pvaClientNTMultiData.endDeltaTime();
    }

    public PvaClientNTMultiData getData() {
        return this.pvaClientNTMultiData;
    }

    private PvaClientNTMultiGet(Union u, PvaClientMultiChannel pvaClientMultiChannel, PvaClientChannel[] pvaClientChannelArray, PVStructure pvRequest) {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientNTMultiGet::PvaClientNTMultiGet()");
        }
        this.pvaClientMultiChannel = pvaClientMultiChannel;
        this.pvaClientChannelArray = pvaClientChannelArray;
        this.pvRequest = pvRequest;
        this.nchannel = pvaClientChannelArray.length;
        this.pvaClientNTMultiData = PvaClientNTMultiData.create(u, pvaClientMultiChannel, pvaClientChannelArray, pvRequest);
        this.pvaClientGet = new PvaClientGet[this.nchannel];
        for (int i = 0; i < this.nchannel; ++i) {
            this.pvaClientGet[i] = null;
        }
    }
}

