/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.epics.pvaClient.PvaClientChannel;
import org.epics.pvaccess.ClientFactory;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelProviderRegistry;
import org.epics.pvaccess.client.ChannelProviderRegistryFactory;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.Requester;

public class PvaClient
implements Requester {
    private static PvaClient pvaClient = null;
    private static boolean debug = false;
    private boolean pvaStarted = false;
    private boolean caStarted = false;
    private static final PvaClientChannelCache pvaClientChannelCache = new PvaClientChannelCache();
    private static final String pvaClientName = "pvaClient";
    private static final String defaultProvider = "pva";
    private Requester requester = null;
    private boolean isDestroyed = false;

    public static synchronized PvaClient get(String providerNames) {
        if (pvaClient == null) {
            String[] names;
            ChannelProviderRegistry registry = ChannelProviderRegistryFactory.getChannelProviderRegistry();
            pvaClient = new PvaClient();
            for (String name : names = providerNames.split("\\s+")) {
                if (name.equals(defaultProvider)) {
                    ClientFactory.start();
                    PvaClient.pvaClient.pvaStarted = true;
                    continue;
                }
                if (name.equals("ca")) {
                    org.epics.ca.ClientFactory.start();
                    PvaClient.pvaClient.caStarted = true;
                    continue;
                }
                if (registry.getProvider(name) != null) continue;
                System.err.println("PvaClient::get provider " + name + " not known");
            }
        }
        return pvaClient;
    }

    public static synchronized PvaClient get() {
        return PvaClient.get("pva ca");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        PvaClient pvaClient = this;
        synchronized (pvaClient) {
            if (this.isDestroyed) {
                System.out.println("Why was PvaClient::destroy() called more then once????");
                return;
            }
            this.isDestroyed = true;
        }
        if (PvaClient.getDebug()) {
            System.out.println(pvaClientChannelCache.toString());
        }
        pvaClientChannelCache.destroy();
        if (this.pvaStarted) {
            System.out.println("calling org.epics.pvaccess.ClientFactory::stop()");
            ClientFactory.stop();
        }
        if (this.caStarted) {
            System.out.println("calling org.epics.ca.ClientFactory::stop()");
            org.epics.ca.ClientFactory.stop();
        }
    }

    public String getRequesterName() {
        if (this.requester != null) {
            return this.requester.getRequesterName();
        }
        return pvaClientName;
    }

    public void message(String message, MessageType messageType) {
        if (this.requester != null) {
            this.requester.message(message, messageType);
            return;
        }
        System.out.printf("%s %s%n", messageType.name(), message);
    }

    public PvaClientChannel channel(String channelName) {
        return this.channel(channelName, defaultProvider, 5.0);
    }

    public PvaClientChannel channel(String channelName, String providerName) {
        return this.channel(channelName, providerName, 5.0);
    }

    public PvaClientChannel channel(String channelName, String providerName, double timeOut) {
        PvaClientChannel pvaClientChannel = pvaClientChannelCache.getChannel(channelName, providerName);
        if (pvaClientChannel != null) {
            return pvaClientChannel;
        }
        pvaClientChannel = this.createChannel(channelName, providerName);
        pvaClientChannel.connect(timeOut);
        pvaClientChannelCache.addChannel(pvaClientChannel);
        return pvaClientChannel;
    }

    public PvaClientChannel createChannel(String channelName) {
        return this.createChannel(channelName, defaultProvider);
    }

    public PvaClientChannel createChannel(String channelName, String providerName) {
        if (this.isDestroyed) {
            return null;
        }
        return PvaClientChannel.create(this, channelName, providerName);
    }

    public void setRequester(Requester requester) {
        this.requester = requester;
    }

    public void clearRequester() {
        this.requester = null;
    }

    public String showCache() {
        return pvaClientChannelCache.toString();
    }

    public int cacheSize() {
        return pvaClientChannelCache.cacheSize();
    }

    public static void setDebug(boolean value) {
        debug = value;
    }

    public static boolean getDebug() {
        return debug;
    }

    private static class PvaClientChannelCache {
        private Map<String, PvaClientChannel> pvaClientChannelMap = new TreeMap<String, PvaClientChannel>();

        void destroy() {
            Set<String> names = this.pvaClientChannelMap.keySet();
            Iterator<String> iter = names.iterator();
            while (iter.hasNext()) {
                PvaClientChannel pvaChannel = this.pvaClientChannelMap.get(iter.next());
                pvaChannel.destroy();
            }
            this.pvaClientChannelMap.clear();
        }

        PvaClientChannel getChannel(String channelName, String providerName) {
            String name = channelName + providerName;
            return this.pvaClientChannelMap.get(name);
        }

        void addChannel(PvaClientChannel pvaClientChannel) {
            Channel channel = pvaClientChannel.getChannel();
            String name = channel.getChannelName() + channel.getProvider().getProviderName();
            if (this.pvaClientChannelMap.get(name) != null) {
                throw new RuntimeException("pvaClientChannelCache::addChannel channel already cached");
            }
            this.pvaClientChannelMap.put(name, pvaClientChannel);
        }

        public String toString() {
            String result = "";
            Set<String> names = this.pvaClientChannelMap.keySet();
            Iterator<String> iter = names.iterator();
            while (iter.hasNext()) {
                PvaClientChannel pvaChannel = this.pvaClientChannelMap.get(iter.next());
                Channel channel = pvaChannel.getChannel();
                String channelName = channel.getChannelName();
                String providerName = channel.getProvider().getProviderName();
                result = result + "channel " + channelName + " providerName " + providerName + "\n";
                result = result + "  get and put cacheSize " + pvaChannel.cacheSize() + "\n";
                result = result + "  get and put cache\n" + pvaChannel.showCache();
            }
            return result;
        }

        int cacheSize() {
            return this.pvaClientChannelMap.size();
        }
    }
}

