/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import java.util.concurrent.locks.ReentrantLock;
import org.epics.pvaClient.PvaClient;
import org.epics.pvaClient.PvaClientChannel;
import org.epics.pvaClient.PvaClientMonitor;
import org.epics.pvaClient.PvaClientMultiChannel;
import org.epics.pvaClient.PvaClientNTMultiData;
import org.epics.pvdata.factory.FieldFactory;
import org.epics.pvdata.property.TimeStamp;
import org.epics.pvdata.property.TimeStampFactory;
import org.epics.pvdata.pv.FieldCreate;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.Union;

public class PvaClientNTMultiMonitor {
    private static final FieldCreate fieldCreate = FieldFactory.getFieldCreate();
    private final PvaClientMultiChannel pvaClientMultiChannel;
    private final PvaClientChannel[] pvaClientChannelArray;
    private final PVStructure pvRequest;
    private final int nchannel;
    private final ReentrantLock lock = new ReentrantLock();
    private PvaClientNTMultiData pvaClientNTMultiData;
    private PvaClientMonitor[] pvaClientMonitor;
    private boolean isConnected = false;
    private boolean isDestroyed = false;
    private TimeStamp start = TimeStampFactory.create();
    private TimeStamp now = TimeStampFactory.create();

    public static PvaClientNTMultiMonitor create(PvaClientMultiChannel pvaClientMultiChannel, PvaClientChannel[] pvaClientChannelArray, PVStructure pvRequest) {
        Union u = fieldCreate.createVariantUnion();
        return new PvaClientNTMultiMonitor(u, pvaClientMultiChannel, pvaClientChannelArray, pvRequest);
    }

    private PvaClientNTMultiMonitor(Union u, PvaClientMultiChannel pvaClientMultiChannel, PvaClientChannel[] pvaClientChannelArray, PVStructure pvRequest) {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientNTMultiMonitor::PvaClientNTMultiMonitor()");
        }
        this.pvaClientMultiChannel = pvaClientMultiChannel;
        this.pvaClientChannelArray = pvaClientChannelArray;
        this.pvRequest = pvRequest;
        this.nchannel = pvaClientChannelArray.length;
        this.pvaClientNTMultiData = PvaClientNTMultiData.create(u, pvaClientMultiChannel, pvaClientChannelArray, pvRequest);
        this.pvaClientMonitor = new PvaClientMonitor[this.nchannel];
        for (int i = 0; i < this.nchannel; ++i) {
            this.pvaClientMonitor[i] = null;
        }
    }

    public void destroy() {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientNTMultiMonitor::destroy()");
        }
        this.lock.lock();
        try {
            if (this.isDestroyed) {
                return;
            }
            this.isDestroyed = true;
        }
        finally {
            this.lock.unlock();
        }
        for (int i = 0; i < this.nchannel; ++i) {
            this.pvaClientChannelArray[i] = null;
        }
    }

    public void connect() {
        int i;
        boolean[] isConnected = this.pvaClientMultiChannel.getIsConnected();
        String request = "value";
        if (this.pvRequest.getSubField("field.alarm") != null) {
            request = request + ",alarm";
        }
        if (this.pvRequest.getSubField("field.timeStamp") != null) {
            request = request + ",timeStamp";
        }
        for (i = 0; i < this.nchannel; ++i) {
            if (!isConnected[i]) continue;
            this.pvaClientMonitor[i] = this.pvaClientChannelArray[i].createMonitor(request);
            this.pvaClientMonitor[i].issueConnect();
        }
        for (i = 0; i < this.nchannel; ++i) {
            Status status;
            if (!isConnected[i] || (status = this.pvaClientMonitor[i].waitConnect()).isOK()) continue;
            String message = "channel " + this.pvaClientChannelArray[i].getChannelName() + " PvaChannelMonitor::waitConnect " + status.getMessage();
            throw new RuntimeException(message);
        }
        for (i = 0; i < this.nchannel; ++i) {
            if (!isConnected[i]) continue;
            this.pvaClientMonitor[i].start();
        }
        this.isConnected = true;
    }

    public boolean poll() {
        if (!this.isConnected) {
            this.connect();
        }
        boolean result = false;
        boolean[] isConnected = this.pvaClientMultiChannel.getIsConnected();
        this.pvaClientNTMultiData.startDeltaTime();
        for (int i = 0; i < this.nchannel; ++i) {
            if (!isConnected[i] || !this.pvaClientMonitor[i].poll()) continue;
            this.pvaClientNTMultiData.setPVStructure(this.pvaClientMonitor[i].getData().getPVStructure(), i);
            this.pvaClientMonitor[i].releaseEvent();
            result = true;
        }
        if (result) {
            this.pvaClientNTMultiData.endDeltaTime();
        }
        return result;
    }

    public boolean waitEvent(double waitForEvent) {
        double diff;
        if (this.poll()) {
            return true;
        }
        this.start.getCurrentTime();
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.poll()) {
                return true;
            }
            this.now.getCurrentTime();
        } while (!((diff = this.now.diff(this.now, this.start)) >= waitForEvent));
        return false;
    }

    public PvaClientNTMultiData getData() {
        return this.pvaClientNTMultiData;
    }
}

