/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.epics.pvaClient.PvaClient;
import org.epics.pvaClient.PvaClientPutData;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelPut;
import org.epics.pvaccess.client.ChannelPutRequester;
import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;
import org.epics.pvdata.pv.Structure;

public class PvaClientPut
implements ChannelPutRequester {
    private static final StatusCreate statusCreate = StatusFactory.getStatusCreate();
    private static final Convert convert = ConvertFactory.getConvert();
    private final PvaClient pvaClient;
    private final Channel channel;
    private final PVStructure pvRequest;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition waitForConnect = this.lock.newCondition();
    private final Condition waitForPutGet = this.lock.newCondition();
    private PvaClientPutData pvaClientData = null;
    private volatile boolean isDestroyed = false;
    private volatile Status channelPutConnectStatus = statusCreate.getStatusOK();
    private volatile Status channelGetPutStatus = statusCreate.getStatusOK();
    private volatile ChannelPut channelPut = null;
    private volatile PutConnectState connectState = PutConnectState.connectIdle;
    private volatile PutGetState putGetState = PutGetState.putGetIdle;

    static PvaClientPut create(PvaClient pvaClient, Channel channel, PVStructure pvRequest) {
        return new PvaClientPut(pvaClient, channel, pvRequest);
    }

    private PvaClientPut(PvaClient pvaClient, Channel channel, PVStructure pvRequest) {
        this.pvaClient = pvaClient;
        this.channel = channel;
        this.pvRequest = pvRequest;
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientPut::PvaClientPut");
        }
    }

    void checkPutState() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPut was destroyed");
        }
        if (this.connectState == PutConnectState.connectIdle) {
            this.connect();
            this.get();
        }
    }

    public String getRequesterName() {
        return this.pvaClient.getRequesterName();
    }

    public void message(String message, MessageType messageType) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPut was destroyed");
        }
        this.pvaClient.message(message, messageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelPutConnect(Status status, ChannelPut channelPut, Structure structure) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPut was destroyed");
        }
        this.lock.lock();
        try {
            if (PvaClient.getDebug()) {
                System.out.println("PvaClientPut::clientPutConnect channelName " + this.channel.getChannelName() + " status " + status);
            }
            this.channelPutConnectStatus = status;
            this.connectState = PutConnectState.connected;
            this.channelPut = channelPut;
            if (status.isOK()) {
                this.pvaClientData = PvaClientPutData.create(structure);
                this.pvaClientData.setMessagePrefix(this.channel.getChannelName());
            }
            this.waitForConnect.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDone(Status status, ChannelPut channelPut, PVStructure pvStructure, BitSet bitSet) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPut was destroyed");
        }
        this.lock.lock();
        try {
            if (PvaClient.getDebug()) {
                System.out.println("PvaClientPut::getDone channelName " + this.channel.getChannelName() + " status " + status);
            }
            this.channelGetPutStatus = status;
            if (status.isOK()) {
                PVStructure pvs = this.pvaClientData.getPVStructure();
                convert.copyStructure(pvStructure, pvs);
                BitSet bs = this.pvaClientData.getChangedBitSet();
                bs.clear();
                bs.or(bitSet);
            }
            this.putGetState = PutGetState.putGetComplete;
            this.waitForPutGet.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void putDone(Status status, ChannelPut channelPut) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPut was destroyed");
        }
        this.lock.lock();
        try {
            if (PvaClient.getDebug()) {
                System.out.println("PvaClientPut::putDone channelName " + this.channel.getChannelName() + " status " + status);
            }
            this.channelGetPutStatus = status;
            this.putGetState = PutGetState.putGetComplete;
            this.waitForPutGet.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientPut::destroy");
        }
        PvaClientPut pvaClientPut = this;
        synchronized (pvaClientPut) {
            if (this.isDestroyed) {
                return;
            }
            this.isDestroyed = true;
        }
        if (this.channelPut != null) {
            this.channelPut.destroy();
        }
    }

    public void connect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPut was destroyed");
        }
        this.issueConnect();
        Status status = this.waitConnect();
        if (status.isOK()) {
            return;
        }
        String message = "channel " + this.channel.getChannelName() + " PvaClientPut::connect " + status.getMessage();
        throw new RuntimeException(message);
    }

    public void issueConnect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPut was destroyed");
        }
        if (this.connectState != PutConnectState.connectIdle) {
            String message = "channel " + this.channel.getChannelName() + "  pvaClientPut already connected";
            throw new RuntimeException(message);
        }
        this.connectState = PutConnectState.connectActive;
        this.channelPut = this.channel.createChannelPut((ChannelPutRequester)this, this.pvRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status waitConnect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPut was destroyed");
        }
        this.lock.lock();
        try {
            if (this.connectState == PutConnectState.connected) {
                if (!this.channelPutConnectStatus.isOK()) {
                    this.connectState = PutConnectState.connectIdle;
                }
                Status status = this.channelPutConnectStatus;
                return status;
            }
            if (this.connectState != PutConnectState.connectActive) {
                String message = "channel " + this.channel.getChannelName() + " pvaClientGet illegal connect state ";
                Status status = statusCreate.createStatus(Status.StatusType.ERROR, message, null);
                return status;
            }
            try {
                this.waitForConnect.await();
            }
            catch (InterruptedException e) {
                String message = "channel " + this.channel.getChannelName() + " InterruptedException " + e.getMessage();
                Status status = statusCreate.createStatus(Status.StatusType.ERROR, message, e.fillInStackTrace());
                this.lock.unlock();
                return status;
            }
            if (!this.channelPutConnectStatus.isOK()) {
                this.connectState = PutConnectState.connectIdle;
            }
            Status status = this.channelPutConnectStatus;
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void get() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPut was destroyed");
        }
        this.issueGet();
        Status status = this.waitGet();
        if (status.isOK()) {
            return;
        }
        String message = "channel " + this.channel.getChannelName() + " PvaClientPut::get " + status.getMessage();
        throw new RuntimeException(message);
    }

    public void issueGet() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPut was destroyed");
        }
        if (this.connectState == PutConnectState.connectIdle) {
            this.connect();
        }
        if (this.putGetState != PutGetState.putGetIdle) {
            String message = "channel " + this.channel.getChannelName() + " PvaClientPut::issueGet get or put aleady active ";
            throw new RuntimeException(message);
        }
        this.putGetState = PutGetState.putGetActive;
        this.channelPut.get();
    }

    public Status waitGet() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPut was destroyed");
        }
        this.lock.lock();
        try {
            if (this.putGetState == PutGetState.putGetComplete) {
                this.putGetState = PutGetState.putGetIdle;
                Status status = this.channelGetPutStatus;
                return status;
            }
            if (this.putGetState != PutGetState.putGetActive) {
                String message = "channel " + this.channel.getChannelName() + " PvaClientPut::waitGet llegal putGet state ";
                throw new RuntimeException(message);
            }
            try {
                this.waitForPutGet.await();
            }
            catch (InterruptedException e) {
                String message = "channel " + this.channel.getChannelName() + " InterruptedException " + e.getMessage();
                throw new RuntimeException(message);
            }
            this.putGetState = PutGetState.putGetIdle;
            Status status = this.channelGetPutStatus;
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void put() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPut was destroyed");
        }
        this.issuePut();
        Status status = this.waitPut();
        if (status.isOK()) {
            return;
        }
        String message = "channel " + this.channel.getChannelName() + " PvaClientPut::put " + status.getMessage();
        throw new RuntimeException(message);
    }

    public void issuePut() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPut was destroyed");
        }
        if (this.connectState == PutConnectState.connectIdle) {
            this.connect();
        }
        if (this.putGetState != PutGetState.putGetIdle) {
            String message = "channel " + this.channel.getChannelName() + " PvaClientPut::issueGet get or put aleady active ";
            throw new RuntimeException(message);
        }
        this.putGetState = PutGetState.putGetActive;
        this.channelPut.put(this.pvaClientData.getPVStructure(), this.pvaClientData.getChangedBitSet());
    }

    public Status waitPut() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPut was destroyed");
        }
        this.lock.lock();
        try {
            if (this.putGetState == PutGetState.putGetComplete) {
                this.putGetState = PutGetState.putGetIdle;
                Status status = this.channelGetPutStatus;
                return status;
            }
            if (this.putGetState != PutGetState.putGetActive) {
                String message = "channel " + this.channel.getChannelName() + " PvaClientPut::waitPut llegal putGet state ";
                throw new RuntimeException(message);
            }
            try {
                this.waitForPutGet.await();
            }
            catch (InterruptedException e) {
                String message = "channel " + this.channel.getChannelName() + " InterruptedException " + e.getMessage();
                throw new RuntimeException(message);
            }
            this.putGetState = PutGetState.putGetIdle;
            if (this.channelGetPutStatus.isOK()) {
                this.pvaClientData.getChangedBitSet().clear();
            }
            Status status = this.channelGetPutStatus;
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    public PvaClientPutData getData() {
        this.checkPutState();
        return this.pvaClientData;
    }

    private static enum PutGetState {
        putGetIdle,
        putGetActive,
        putGetComplete;

    }

    private static enum PutConnectState {
        connectIdle,
        connectActive,
        connected;

    }
}

