/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.epics.pvaClient.PvaClient;
import org.epics.pvaClient.PvaClientGetData;
import org.epics.pvaClient.PvaClientPutData;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelPutGet;
import org.epics.pvaccess.client.ChannelPutGetRequester;
import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;
import org.epics.pvdata.pv.Structure;

public class PvaClientPutGet
implements ChannelPutGetRequester {
    private static final StatusCreate statusCreate = StatusFactory.getStatusCreate();
    private static final Convert convert = ConvertFactory.getConvert();
    private final PvaClient pvaClient;
    private final Channel channel;
    private final PVStructure pvRequest;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition waitForConnect = this.lock.newCondition();
    private final Condition waitForPutGet = this.lock.newCondition();
    private PvaClientGetData pvaClientGetData = null;
    private PvaClientPutData pvaClientPutGetData = null;
    private volatile boolean isDestroyed = false;
    private volatile Status channelPutGetConnectStatus = statusCreate.getStatusOK();
    private volatile Status channelPutGetStatus = statusCreate.getStatusOK();
    private volatile ChannelPutGet channelPutGet = null;
    private volatile PutGetConnectState connectState = PutGetConnectState.connectIdle;
    private volatile PutGetState putGetState = PutGetState.putGetIdle;

    public static PvaClientPutGet create(PvaClient pvaClient, Channel channel, PVStructure pvRequest) {
        return new PvaClientPutGet(pvaClient, channel, pvRequest);
    }

    private PvaClientPutGet(PvaClient pvaClient, Channel channel, PVStructure pvRequest) {
        this.pvaClient = pvaClient;
        this.channel = channel;
        this.pvRequest = pvRequest;
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientPutGet::PvaClientPutGet");
        }
    }

    void checkPutGetState() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGetGet was destroyed");
        }
        if (this.connectState == PutGetConnectState.connectIdle) {
            this.connect();
            this.getPut();
        }
    }

    public String getRequesterName() {
        return this.pvaClient.getRequesterName();
    }

    public void message(String message, MessageType messageType) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGetGet was destroyed");
        }
        this.pvaClient.message(message, messageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelPutGetConnect(Status status, ChannelPutGet channelPutGet, Structure putStructure, Structure getStructure) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGet was destroyed");
        }
        this.lock.lock();
        try {
            if (PvaClient.getDebug()) {
                System.out.println("PvaClientPutGet::channelPutGetConnect channelName " + this.channel.getChannelName() + " status " + status);
            }
            this.channelPutGetConnectStatus = status;
            this.connectState = PutGetConnectState.connected;
            this.channelPutGet = channelPutGet;
            if (status.isOK()) {
                this.pvaClientPutGetData = PvaClientPutData.create(putStructure);
                this.pvaClientPutGetData.setMessagePrefix(this.channel.getChannelName());
                this.pvaClientGetData = PvaClientGetData.create(getStructure);
                this.pvaClientGetData.setMessagePrefix(this.channel.getChannelName());
            }
            this.waitForConnect.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putGetDone(Status status, ChannelPutGet channelPutGet, PVStructure getPVStructure, BitSet getBitSet) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGet was destroyed");
        }
        this.lock.lock();
        try {
            if (PvaClient.getDebug()) {
                System.out.println("PvaClientPutGet::channelPutGetDone channelName " + this.channel.getChannelName() + " status " + status);
            }
            this.channelPutGetStatus = status;
            this.putGetState = PutGetState.putGetComplete;
            if (status.isOK()) {
                this.pvaClientGetData.setData(getPVStructure, getBitSet);
            }
            this.waitForPutGet.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPutDone(Status status, ChannelPutGet channelPutGet, PVStructure putPVStructure, BitSet putBitSet) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGet was destroyed");
        }
        this.lock.lock();
        try {
            if (PvaClient.getDebug()) {
                System.out.println("PvaClientPutGet::channelGetPutDone channelName " + this.channel.getChannelName() + " status " + status);
            }
            this.channelPutGetStatus = status;
            this.putGetState = PutGetState.putGetComplete;
            if (status.isOK()) {
                PVStructure pvs = this.pvaClientPutGetData.getPVStructure();
                convert.copyStructure(putPVStructure, pvs);
                BitSet bs = this.pvaClientPutGetData.getChangedBitSet();
                bs.clear();
                bs.or(putBitSet);
            }
            this.waitForPutGet.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getGetDone(Status status, ChannelPutGet channelPutGet, PVStructure getPVStructure, BitSet getBitSet) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGet was destroyed");
        }
        this.lock.lock();
        try {
            if (PvaClient.getDebug()) {
                System.out.println("PvaClientPutGet::channelGetGetDone channelName " + this.channel.getChannelName() + " status " + status);
            }
            this.channelPutGetStatus = status;
            this.putGetState = PutGetState.putGetComplete;
            if (status.isOK()) {
                this.pvaClientGetData.setData(getPVStructure, getBitSet);
            }
            this.waitForPutGet.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientPutGet::destroy");
        }
        PvaClientPutGet pvaClientPutGet = this;
        synchronized (pvaClientPutGet) {
            if (this.isDestroyed) {
                return;
            }
            this.isDestroyed = true;
        }
        if (this.channelPutGet != null) {
            this.channelPutGet.destroy();
        }
    }

    public void connect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGet was destroyed");
        }
        this.issueConnect();
        Status status = this.waitConnect();
        if (status.isOK()) {
            return;
        }
        String message = "channel " + this.channel.getChannelName() + " PvaClientPut::connect " + status.getMessage();
        throw new RuntimeException(message);
    }

    public void issueConnect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGet was destroyed");
        }
        if (this.connectState != PutGetConnectState.connectIdle) {
            String message = "channel " + this.channel.getChannelName() + "  pvaClientPutGet already connected";
            throw new RuntimeException(message);
        }
        this.connectState = PutGetConnectState.connectActive;
        this.channelPutGet = this.channel.createChannelPutGet((ChannelPutGetRequester)this, this.pvRequest);
    }

    public Status waitConnect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGet was destroyed");
        }
        this.lock.lock();
        try {
            if (this.connectState == PutGetConnectState.connected) {
                if (!this.channelPutGetConnectStatus.isOK()) {
                    this.connectState = PutGetConnectState.connectIdle;
                }
                Status status = this.channelPutGetConnectStatus;
                return status;
            }
            if (this.connectState != PutGetConnectState.connectActive) {
                String message = "channel " + this.channel.getChannelName() + " pvaClientGet illegal connect state ";
                throw new RuntimeException(message);
            }
            try {
                this.waitForConnect.await();
            }
            catch (InterruptedException e) {
                String message = "channel " + this.channel.getChannelName() + " InterruptedException " + e.getMessage();
                throw new RuntimeException(message);
            }
            if (!this.channelPutGetConnectStatus.isOK()) {
                this.connectState = PutGetConnectState.connectIdle;
            }
            Status status = this.channelPutGetConnectStatus;
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void putGet() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGet was destroyed");
        }
        this.issuePutGet();
        Status status = this.waitPutGet();
        if (status.isOK()) {
            return;
        }
        String message = "channel " + this.channel.getChannelName() + " PvaClientPut::get " + status.getMessage();
        throw new RuntimeException(message);
    }

    public void issuePutGet() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGet was destroyed");
        }
        if (this.connectState == PutGetConnectState.connectIdle) {
            this.connect();
        }
        if (this.putGetState != PutGetState.putGetIdle) {
            String message = "channel " + this.channel.getChannelName() + " PvaClientPutGet::issuePutGet get or put aleady active ";
            throw new RuntimeException(message);
        }
        this.putGetState = PutGetState.putGetActive;
        this.channelPutGet.putGet(this.pvaClientPutGetData.getPVStructure(), this.pvaClientPutGetData.getChangedBitSet());
    }

    public Status waitPutGet() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGet was destroyed");
        }
        this.lock.lock();
        try {
            if (this.putGetState == PutGetState.putGetComplete) {
                this.putGetState = PutGetState.putGetIdle;
                Status status = this.channelPutGetStatus;
                return status;
            }
            if (this.putGetState != PutGetState.putGetActive) {
                String message = "channel " + this.channel.getChannelName() + " PvaClientGetGet::waitPutGet llegal putGet state ";
                throw new RuntimeException(message);
            }
            try {
                this.waitForPutGet.await();
            }
            catch (InterruptedException e) {
                String message = "channel " + this.channel.getChannelName() + " InterruptedException " + e.getMessage();
                throw new RuntimeException(message);
            }
            this.putGetState = PutGetState.putGetIdle;
            Status status = this.channelPutGetStatus;
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void getGet() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGet was destroyed");
        }
        this.issueGetGet();
        Status status = this.waitGetGet();
        if (status.isOK()) {
            return;
        }
        String message = "channel " + this.channel.getChannelName() + " PvaClientPutGet::getGet " + status.getMessage();
        throw new RuntimeException(message);
    }

    public void issueGetGet() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGet was destroyed");
        }
        if (this.connectState == PutGetConnectState.connectIdle) {
            this.connect();
        }
        if (this.putGetState != PutGetState.putGetIdle) {
            String message = "channel " + this.channel.getChannelName() + " PvaClientPutGet::issueGetGet get or put aleady active ";
            throw new RuntimeException(message);
        }
        this.putGetState = PutGetState.putGetActive;
        this.channelPutGet.getGet();
    }

    public Status waitGetGet() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGet was destroyed");
        }
        this.lock.lock();
        try {
            if (this.putGetState == PutGetState.putGetComplete) {
                this.putGetState = PutGetState.putGetIdle;
                Status status = this.channelPutGetStatus;
                return status;
            }
            if (this.putGetState != PutGetState.putGetActive) {
                String message = "channel " + this.channel.getChannelName() + " PvaClientPutGet::waitGetGet llegal get state ";
                throw new RuntimeException(message);
            }
            try {
                this.waitForPutGet.await();
            }
            catch (InterruptedException e) {
                String message = "channel " + this.channel.getChannelName() + " InterruptedException " + e.getMessage();
                throw new RuntimeException(message);
            }
            this.putGetState = PutGetState.putGetIdle;
            Status status = this.channelPutGetStatus;
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void getPut() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGet was destroyed");
        }
        this.issueGetPut();
        Status status = this.waitGetPut();
        if (status.isOK()) {
            return;
        }
        String message = "channel " + this.channel.getChannelName() + " PvaClientPut::put " + status.getMessage();
        throw new RuntimeException(message);
    }

    public void issueGetPut() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGet was destroyed");
        }
        if (this.connectState == PutGetConnectState.connectIdle) {
            this.connect();
        }
        if (this.putGetState != PutGetState.putGetIdle) {
            String message = "channel " + this.channel.getChannelName() + " PvaClientPutGet::issueGetPut get or put aleady active ";
            throw new RuntimeException(message);
        }
        this.putGetState = PutGetState.putGetActive;
        this.channelPutGet.getPut();
    }

    public Status waitGetPut() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientPutGet was destroyed");
        }
        this.lock.lock();
        try {
            if (this.putGetState == PutGetState.putGetComplete) {
                this.putGetState = PutGetState.putGetIdle;
                Status status = this.channelPutGetStatus;
                return status;
            }
            if (this.putGetState != PutGetState.putGetActive) {
                String message = "channel " + this.channel.getChannelName() + " PvaClientPutGet::waitGetPut llegal put state ";
                throw new RuntimeException(message);
            }
            try {
                this.waitForPutGet.await();
            }
            catch (InterruptedException e) {
                String message = "channel " + this.channel.getChannelName() + " InterruptedException " + e.getMessage();
                throw new RuntimeException(message);
            }
            this.putGetState = PutGetState.putGetIdle;
            Status status = this.channelPutGetStatus;
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    public PvaClientGetData getGetData() {
        this.checkPutGetState();
        return this.pvaClientGetData;
    }

    public PvaClientPutData getPutData() {
        this.checkPutGetState();
        return this.pvaClientPutGetData;
    }

    private static enum PutGetState {
        putGetIdle,
        putGetActive,
        putGetComplete;

    }

    private static enum PutGetConnectState {
        connectIdle,
        connectActive,
        connected;

    }
}

