/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import org.epics.pvaClient.PvaClient;
import org.epics.pvaClient.PvaClientChannel;
import org.epics.pvaClient.PvaClientMultiChannel;
import org.epics.pvaClient.PvaClientPut;
import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.PVScalar;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Status;

public class PvaClientMultiPutDouble {
    private final PvaClientMultiChannel pvaClientMultiChannel;
    private static final Convert convert = ConvertFactory.getConvert();
    private PvaClientChannel[] pvaClientChannelArray;
    private int nchannel;
    private PvaClientPut[] pvaClientPut;
    boolean isPutConnected = false;
    boolean isDestroyed = false;

    public static PvaClientMultiPutDouble create(PvaClientMultiChannel pvaClientMultiChannel, PvaClientChannel[] pvaClientChannelArray) {
        return new PvaClientMultiPutDouble(pvaClientMultiChannel, pvaClientChannelArray);
    }

    public void destroy() {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientMultiPutDouble::destroy()");
        }
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        this.pvaClientChannelArray = null;
    }

    public void connect() {
        int i;
        boolean[] isConnected = this.pvaClientMultiChannel.getIsConnected();
        String request = "value";
        for (i = 0; i < this.nchannel; ++i) {
            if (!isConnected[i]) continue;
            this.pvaClientPut[i] = this.pvaClientChannelArray[i].createPut(request);
            this.pvaClientPut[i].issueConnect();
        }
        for (i = 0; i < this.nchannel; ++i) {
            Status status;
            if (!isConnected[i] || (status = this.pvaClientPut[i].waitConnect()).isOK()) continue;
            String message = "channel " + this.pvaClientChannelArray[i].getChannelName();
            message = message + " PvaChannelPut::waitConnect " + status.getMessage();
            throw new RuntimeException(message);
        }
        this.isPutConnected = true;
    }

    public void put(double[] data) {
        if (!this.isPutConnected) {
            this.connect();
        }
        if (data.length != this.nchannel) {
            throw new RuntimeException("data has wrong size");
        }
        boolean[] isConnected = this.pvaClientMultiChannel.getIsConnected();
        for (int i = 0; i < this.nchannel; ++i) {
            Status status;
            if (isConnected[i]) {
                PVStructure pvTop = this.pvaClientPut[i].getData().getPVStructure();
                PVScalar pvValue = (PVScalar)pvTop.getSubField(PVScalar.class, "value");
                convert.fromDouble(pvValue, data[i]);
                this.pvaClientPut[i].issuePut();
            }
            if (!isConnected[i] || (status = this.pvaClientPut[i].waitPut()).isOK()) continue;
            String message = "channel " + this.pvaClientChannelArray[i].getChannelName();
            message = message + " PvaChannelPut::waitConnect " + status.getMessage();
            throw new RuntimeException(message);
        }
    }

    private PvaClientMultiPutDouble(PvaClientMultiChannel pvaClientMultiChannel, PvaClientChannel[] pvaClientChannelArray) {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientMultiPutDouble::PvaClientMultiPutDouble()");
        }
        this.pvaClientMultiChannel = pvaClientMultiChannel;
        this.pvaClientChannelArray = pvaClientChannelArray;
        this.nchannel = pvaClientChannelArray.length;
        this.pvaClientPut = new PvaClientPut[this.nchannel];
        for (int i = 0; i < this.nchannel; ++i) {
            this.pvaClientPut[i] = null;
        }
    }
}

