/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.factory.PVDataFactory;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.DoubleArrayData;
import org.epics.pvdata.pv.PVArray;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVDouble;
import org.epics.pvdata.pv.PVDoubleArray;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVScalar;
import org.epics.pvdata.pv.PVScalarArray;
import org.epics.pvdata.pv.PVStringArray;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.PostHandler;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.StringArrayData;
import org.epics.pvdata.pv.Structure;
import org.epics.pvdata.pv.Type;

public class PvaClientPutData {
    private static final Convert convert = ConvertFactory.getConvert();
    private static final PVDataCreate pvDataCreate = PVDataFactory.getPVDataCreate();
    private static final String noValue = "no value field";
    private static final String noScalar = "value is not a scalar";
    private static final String notCompatibleScalar = "value is not a compatible scalar";
    private static final String notArray = "value is not an array";
    private static final String notScalarArray = "value is not a scalarArray";
    private static final String notDoubleArray = "value is not a doubleArray";
    private static final String notStringArray = "value is not a stringArray";
    private PvaClientPostHandler[] postHandler;
    private final Structure structure;
    private PVStructure pvStructure = null;
    private BitSet bitSet = null;
    private String messagePrefix = "";
    private PVField pvValue = null;
    private final DoubleArrayData doubleArrayData = new DoubleArrayData();
    private final StringArrayData stringArrayData = new StringArrayData();

    static PvaClientPutData create(Structure structure) {
        return new PvaClientPutData(structure);
    }

    private PvaClientPutData(Structure structure) {
        this.structure = structure;
        this.pvStructure = pvDataCreate.createPVStructure(structure);
        int nfields = this.pvStructure.getNumberFields();
        this.bitSet = new BitSet(nfields);
        this.postHandler = new PvaClientPostHandler[nfields];
        for (int i = 0; i < nfields; ++i) {
            this.postHandler[i] = new PvaClientPostHandler(this, i);
            Object pvField = i == 0 ? this.pvStructure : this.pvStructure.getSubField(i);
            pvField.setPostHandler((PostHandler)this.postHandler[i]);
        }
        this.pvValue = this.pvStructure.getSubField("value");
    }

    private void checkValue() {
        if (this.pvValue != null) {
            return;
        }
        throw new RuntimeException(this.messagePrefix + noValue);
    }

    private void postPut(int fieldNumber) {
        this.bitSet.set(fieldNumber);
    }

    public void setMessagePrefix(String value) {
        this.messagePrefix = value + " ";
    }

    public Structure getStructure() {
        return this.structure;
    }

    public PVStructure getPVStructure() {
        return this.pvStructure;
    }

    public BitSet getChangedBitSet() {
        return this.bitSet;
    }

    public String showChanged() {
        String result = "";
        int nextSet = this.bitSet.nextSetBit(0);
        while (nextSet >= 0) {
            Object pvField = nextSet == 0 ? this.pvStructure : this.pvStructure.getSubField(nextSet);
            result = result + pvField.getFullName() + " = " + pvField + "\n";
            nextSet = this.bitSet.nextSetBit(nextSet + 1);
        }
        return result;
    }

    public boolean hasValue() {
        return this.pvValue != null;
    }

    public boolean isValueScalar() {
        if (this.pvValue == null) {
            return false;
        }
        return this.pvValue.getField().getType() == Type.scalar;
    }

    public boolean isValueScalarArray() {
        if (this.pvValue == null) {
            return false;
        }
        return this.pvValue.getField().getType() == Type.scalarArray;
    }

    public PVField getValue() {
        this.checkValue();
        return this.pvValue;
    }

    public PVScalar getScalarValue() {
        this.checkValue();
        PVScalar pv = (PVScalar)this.pvStructure.getSubField(PVScalar.class, "value");
        if (pv == null) {
            throw new RuntimeException(this.messagePrefix + noScalar);
        }
        return pv;
    }

    public PVArray getArrayValue() {
        this.checkValue();
        PVArray pv = (PVArray)this.pvStructure.getSubField(PVArray.class, "value");
        if (pv == null) {
            throw new RuntimeException(this.messagePrefix + notArray);
        }
        return pv;
    }

    public PVScalarArray getScalarArrayValue() {
        this.checkValue();
        PVScalarArray pv = (PVScalarArray)this.pvStructure.getSubField(PVScalarArray.class, "value");
        if (pv == null) {
            throw new RuntimeException(this.messagePrefix + notScalarArray);
        }
        return pv;
    }

    public double getDouble() {
        PVScalar pvScalar = this.getScalarValue();
        ScalarType scalarType = pvScalar.getScalar().getScalarType();
        if (scalarType == ScalarType.pvDouble) {
            PVDouble pv = (PVDouble)pvScalar;
            return pv.get();
        }
        if (!scalarType.isNumeric()) {
            throw new RuntimeException(this.messagePrefix + notCompatibleScalar);
        }
        return convert.toDouble(pvScalar);
    }

    public String getString() {
        PVScalar pvScalar = this.getScalarValue();
        return convert.toString(pvScalar);
    }

    public double[] getDoubleArray() {
        this.checkValue();
        PVDoubleArray pvDoubleArray = (PVDoubleArray)this.pvStructure.getSubField(PVDoubleArray.class, "value");
        if (pvDoubleArray == null) {
            throw new RuntimeException(this.messagePrefix + notDoubleArray);
        }
        int length = pvDoubleArray.getLength();
        double[] data = new double[length];
        pvDoubleArray.get(0, length, this.doubleArrayData);
        for (int i = 0; i < length; ++i) {
            data[i] = ((double[])this.doubleArrayData.data)[i];
        }
        return data;
    }

    public String[] getStringArray() {
        this.checkValue();
        PVStringArray pvStringArray = (PVStringArray)this.pvStructure.getSubField(PVStringArray.class, "value");
        if (pvStringArray == null) {
            throw new RuntimeException(this.messagePrefix + notStringArray);
        }
        int length = pvStringArray.getLength();
        String[] data = new String[length];
        pvStringArray.get(0, length, this.stringArrayData);
        for (int i = 0; i < length; ++i) {
            data[i] = ((String[])this.stringArrayData.data)[i];
        }
        return data;
    }

    public int getDoubleArray(double[] value, int length) {
        this.checkValue();
        PVDoubleArray pvDoubleArray = (PVDoubleArray)this.pvStructure.getSubField(PVDoubleArray.class, "value");
        if (pvDoubleArray == null) {
            throw new RuntimeException(this.messagePrefix + notDoubleArray);
        }
        if (pvDoubleArray.getLength() < length) {
            length = pvDoubleArray.getLength();
        }
        pvDoubleArray.get(0, length, this.doubleArrayData);
        for (int i = 0; i < length; ++i) {
            value[i] = ((double[])this.doubleArrayData.data)[i];
        }
        return length;
    }

    public int getStringArray(String[] value, int length) {
        this.checkValue();
        PVStringArray pvStringArray = (PVStringArray)this.pvStructure.getSubField(PVStringArray.class, "value");
        if (pvStringArray == null) {
            throw new RuntimeException(this.messagePrefix + notStringArray);
        }
        if (pvStringArray.getLength() < length) {
            length = pvStringArray.getLength();
        }
        pvStringArray.get(0, length, this.stringArrayData);
        for (int i = 0; i < length; ++i) {
            value[i] = ((String[])this.stringArrayData.data)[i];
        }
        return length;
    }

    public void putDouble(double value) {
        PVScalar pvScalar = this.getScalarValue();
        ScalarType scalarType = pvScalar.getScalar().getScalarType();
        if (scalarType == ScalarType.pvDouble) {
            PVDouble pvDouble = (PVDouble)pvScalar;
            pvDouble.put(value);
            return;
        }
        if (!scalarType.isNumeric()) {
            throw new RuntimeException(this.messagePrefix + notCompatibleScalar);
        }
        convert.fromDouble(pvScalar, value);
    }

    public void putString(String value) {
        PVScalar pvScalar = this.getScalarValue();
        convert.fromString(pvScalar, value);
    }

    public void putDoubleArray(double[] value) {
        this.checkValue();
        PVDoubleArray pv = (PVDoubleArray)this.pvStructure.getSubField(PVDoubleArray.class, "value");
        if (pv == null) {
            throw new RuntimeException(this.messagePrefix + notDoubleArray);
        }
        convert.fromDoubleArray((PVScalarArray)pv, 0, value.length, value, 0);
    }

    public void putStringArray(String[] value) {
        this.checkValue();
        PVStringArray pv = (PVStringArray)this.pvStructure.getSubField(PVStringArray.class, "value");
        if (pv == null) {
            throw new RuntimeException(this.messagePrefix + notStringArray);
        }
        convert.fromStringArray((PVScalarArray)pv, 0, value.length, value, 0);
    }

    private static class PvaClientPostHandler
    implements PostHandler {
        private PvaClientPutData putData;
        private int fieldNumber;

        public PvaClientPostHandler(PvaClientPutData putData, int fieldNumber) {
            this.putData = putData;
            this.fieldNumber = fieldNumber;
        }

        public void postPut() {
            this.putData.postPut(this.fieldNumber);
        }
    }
}

