/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.epics.pvaClient.PvaClient;
import org.epics.pvaClient.PvaClientArray;
import org.epics.pvaClient.PvaClientChannelStateChangeRequester;
import org.epics.pvaClient.PvaClientField;
import org.epics.pvaClient.PvaClientGet;
import org.epics.pvaClient.PvaClientMonitor;
import org.epics.pvaClient.PvaClientMonitorRequester;
import org.epics.pvaClient.PvaClientProcess;
import org.epics.pvaClient.PvaClientPut;
import org.epics.pvaClient.PvaClientPutGet;
import org.epics.pvaClient.PvaClientRPC;
import org.epics.pvaClient.PvaClientUnlistenRequester;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelProvider;
import org.epics.pvaccess.client.ChannelProviderRegistryFactory;
import org.epics.pvaccess.client.ChannelRequester;
import org.epics.pvdata.copy.CreateRequest;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Requester;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;

public class PvaClientChannel
implements ChannelRequester,
Requester {
    private static final StatusCreate statusCreate = StatusFactory.getStatusCreate();
    private final PvaClient pvaClient;
    private final String channelName;
    private final String providerName;
    private volatile ConnectState connectState = ConnectState.connectIdle;
    private volatile boolean isDestroyed = false;
    private CreateRequest createRequest = new CreateRequest();
    private final PvaClientGetCache pvaClientGetCache = new PvaClientGetCache();
    private final PvaClientPutCache pvaClientPutCache = new PvaClientPutCache();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition waitForConnect = this.lock.newCondition();
    private volatile Channel channel = null;
    private volatile PvaClientChannelStateChangeRequester stateChangeRequester = null;

    static PvaClientChannel create(PvaClient pvaClient, String channelName, String providerName) {
        return new PvaClientChannel(pvaClient, channelName, providerName);
    }

    private PvaClientChannel(PvaClient pvaClient, String channelName, String providerName) {
        this.pvaClient = pvaClient;
        this.channelName = channelName;
        this.providerName = providerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelCreated(Status status, Channel channel) {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientChannel::channelCreated channel " + this.getChannelName() + " connectState " + (Object)((Object)this.connectState) + " isConnected " + channel.isConnected() + " status.isOK " + (status.isOK() ? "true" : "false"));
        }
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientChannel was destroyed");
        }
        this.channel = channel;
        if (this.connectState != ConnectState.connectActive) {
            String message = "PvaClientChannel::channelCreated channel " + this.getChannelName() + " why was this called when connectState!=ConnectState.connectActive";
            throw new RuntimeException(message);
        }
        if (channel.isConnected()) {
            this.lock.lock();
            try {
                this.connectState = ConnectState.connected;
                this.waitForConnect.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelStateChange(Channel channel, Channel.ConnectionState connectionState) {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientChannel::channelStateChange channel " + this.getChannelName() + " isConnected " + (connectionState == Channel.ConnectionState.CONNECTED ? "true" : "false"));
        }
        boolean waitingForConnect = false;
        if (this.isDestroyed) {
            return;
        }
        if (this.connectState == ConnectState.connectActive) {
            waitingForConnect = true;
        }
        if (connectionState != Channel.ConnectionState.CONNECTED) {
            String message = this.channelName + " connection state " + connectionState.name();
            this.message(message, MessageType.error);
            this.connectState = ConnectState.notConnected;
        } else {
            this.connectState = ConnectState.connected;
        }
        if (waitingForConnect) {
            this.lock.lock();
            try {
                this.waitForConnect.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
        if (this.stateChangeRequester != null) {
            boolean value = connectionState == Channel.ConnectionState.CONNECTED;
            this.stateChangeRequester.channelStateChange(this, value);
        }
    }

    public String getRequesterName() {
        return this.pvaClient.getRequesterName();
    }

    public void message(String message, MessageType messageType) {
        String mess = this.channelName + " " + message;
        this.pvaClient.message(mess, messageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientChannel::destroy() channel " + this.getChannelName());
        }
        PvaClientChannel pvaClientChannel = this;
        synchronized (pvaClientChannel) {
            if (this.isDestroyed) {
                return;
            }
            this.isDestroyed = true;
        }
        if (this.channel != null) {
            this.channel = null;
        }
        if (PvaClient.getDebug()) {
            this.showCache();
        }
        this.pvaClientGetCache.destroy();
        this.pvaClientPutCache.destroy();
    }

    public String getChannelName() {
        return this.channelName;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setStateChangeRequester(PvaClientChannelStateChangeRequester stateChangeRequester) {
        this.stateChangeRequester = stateChangeRequester;
        boolean isConnected = false;
        if (this.channel != null) {
            isConnected = this.channel.isConnected();
        }
        stateChangeRequester.channelStateChange(this, isConnected);
    }

    public void clearRequester() {
        this.stateChangeRequester = null;
    }

    public void connect() {
        this.connect(5.0);
    }

    public void connect(double timeout) {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientChannel::connect() channel " + this.getChannelName());
        }
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientChannel was destroyed");
        }
        this.issueConnect();
        Status status = this.waitConnect(timeout);
        if (status.isOK()) {
            return;
        }
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientChannel::waitConnect() failed");
        }
        String mess = "channel " + this.getChannelName() + " PvaClientChannel::connect " + status.getMessage();
        throw new RuntimeException(mess);
    }

    public void issueConnect() {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientChannel::issueConnect() channel " + this.getChannelName());
        }
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientChannel was destroyed");
        }
        if (this.connectState == ConnectState.connected) {
            return;
        }
        if (this.connectState != ConnectState.connectIdle) {
            throw new RuntimeException("pvaClientChannel already connected");
        }
        this.connectState = ConnectState.connectActive;
        ChannelProvider provider = ChannelProviderRegistryFactory.getChannelProviderRegistry().getProvider(this.providerName);
        if (provider == null) {
            String mess = this.getChannelName() + " provider " + this.providerName + " not registered";
            throw new RuntimeException(mess);
        }
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientChannel::issueConnect calling provider->createChannel");
        }
        this.channel = provider.createChannel(this.channelName, (ChannelRequester)this, (short)0);
        if (this.channel == null) {
            String mess = this.getChannelName() + " channelCreate failed ";
            throw new RuntimeException(mess);
        }
    }

    public Status waitConnect() {
        return this.waitConnect(5.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status waitConnect(double timeout) {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientChannel::waitConnect() channel " + this.getChannelName());
        }
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientChannel was destroyed");
        }
        if (this.channel == null) {
            throw new RuntimeException("pvaClientChannel::issueConnect was never called");
        }
        if (this.channel.isConnected()) {
            return statusCreate.getStatusOK();
        }
        this.lock.lock();
        try {
            try {
                if (timeout > 0.0) {
                    long nano = (long)(timeout * 1.0E9);
                    this.waitForConnect.awaitNanos(nano);
                } else {
                    this.waitForConnect.await();
                }
            }
            catch (InterruptedException e) {
                Status status;
                Status status2 = status = statusCreate.createStatus(Status.StatusType.ERROR, e.getMessage(), e.fillInStackTrace());
                this.lock.unlock();
                return status2;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.channel == null) {
            return statusCreate.createStatus(Status.StatusType.ERROR, "pvaClientChannel::waitConnect channel is null", null);
        }
        if (this.channel.isConnected()) {
            return statusCreate.getStatusOK();
        }
        return statusCreate.createStatus(Status.StatusType.ERROR, "channel not connected", null);
    }

    public PvaClientField createField() {
        return this.createField("");
    }

    public PvaClientField createField(String subField) {
        if (this.connectState != ConnectState.connected) {
            this.connect(5.0);
        }
        throw new RuntimeException("pvaClientChannel::createField not implemented");
    }

    public PvaClientProcess createProcess() {
        return this.createProcess("");
    }

    public PvaClientProcess createProcess(String request) {
        PVStructure pvRequest = this.createRequest.createRequest(request);
        if (pvRequest == null) {
            String mess = "channel " + this.getChannelName() + " PvaClientChannel::createProcess invalid pvRequest: " + this.createRequest.getMessage();
            throw new RuntimeException(mess);
        }
        return this.createProcess(pvRequest);
    }

    public PvaClientProcess createProcess(PVStructure pvRequest) {
        if (this.connectState != ConnectState.connected) {
            this.connect(5.0);
        }
        return PvaClientProcess.create(this.pvaClient, this.channel, pvRequest);
    }

    public PvaClientGet get() {
        return this.get("field(value,alarm,timeStamp)");
    }

    public PvaClientGet get(String request) {
        PvaClientGet pvaClientGet = this.pvaClientGetCache.getGet(request);
        if (pvaClientGet != null) {
            return pvaClientGet;
        }
        pvaClientGet = this.createGet(request);
        pvaClientGet.connect();
        this.pvaClientGetCache.addGet(request, pvaClientGet);
        return pvaClientGet;
    }

    public PvaClientGet createGet() {
        return this.createGet("field(value,alarm,timeStamp)");
    }

    public PvaClientGet createGet(String request) {
        PVStructure pvRequest = this.createRequest.createRequest(request);
        if (pvRequest == null) {
            String mess = "channel " + this.getChannelName() + " PvaClientChannel::createGet invalid pvRequest: " + this.createRequest.getMessage();
            throw new RuntimeException(mess);
        }
        return this.createGet(pvRequest);
    }

    public PvaClientGet createGet(PVStructure pvRequest) {
        if (this.connectState != ConnectState.connected) {
            this.connect(5.0);
        }
        return PvaClientGet.create(this.pvaClient, this.channel, pvRequest);
    }

    public PvaClientPut put() {
        return this.put("field(value)");
    }

    public PvaClientPut put(String request) {
        PvaClientPut pvaClientPut = this.pvaClientPutCache.getPut(request);
        if (pvaClientPut != null) {
            return pvaClientPut;
        }
        pvaClientPut = this.createPut(request);
        pvaClientPut.connect();
        pvaClientPut.get();
        this.pvaClientPutCache.addPut(request, pvaClientPut);
        return pvaClientPut;
    }

    public PvaClientPut createPut() {
        return this.createPut("field(value)");
    }

    public PvaClientPut createPut(String request) {
        PVStructure pvRequest = this.createRequest.createRequest(request);
        if (pvRequest == null) {
            String mess = "channel " + this.getChannelName() + " PvaClientChannel::createPut invalid pvRequest: " + this.createRequest.getMessage();
            throw new RuntimeException(mess);
        }
        return this.createPut(pvRequest);
    }

    public PvaClientPut createPut(PVStructure pvRequest) {
        if (this.connectState != ConnectState.connected) {
            this.connect(5.0);
        }
        return PvaClientPut.create(this.pvaClient, this.channel, pvRequest);
    }

    public PvaClientPutGet createPutGet() {
        return this.createPutGet("putField(argument)getField(result)");
    }

    public PvaClientPutGet createPutGet(String request) {
        PVStructure pvRequest = this.createRequest.createRequest(request);
        if (pvRequest == null) {
            String mess = "channel " + this.getChannelName() + " PvaClientChannel::createPutGet invalid pvRequest: " + this.createRequest.getMessage();
            throw new RuntimeException(mess);
        }
        return this.createPutGet(pvRequest);
    }

    public PvaClientPutGet createPutGet(PVStructure pvRequest) {
        if (this.connectState != ConnectState.connected) {
            this.connect(5.0);
        }
        return PvaClientPutGet.create(this.pvaClient, this.channel, pvRequest);
    }

    public PvaClientArray createArray() {
        return this.createArray("field(value)");
    }

    public PvaClientArray createArray(String request) {
        PVStructure pvRequest = this.createRequest.createRequest(request);
        if (pvRequest == null) {
            String mess = "channel " + this.getChannelName() + " PvaClientChannel::createArray invalid pvRequest: " + this.createRequest.getMessage();
            throw new RuntimeException(mess);
        }
        return this.createArray(pvRequest);
    }

    public PvaClientArray createArray(PVStructure pvRequest) {
        if (this.connectState != ConnectState.connected) {
            this.connect(5.0);
        }
        String message = this.channelName + " createArray is not implemented";
        throw new RuntimeException(message);
    }

    public PvaClientMonitor monitor() {
        return this.monitor("field(value,alarm,timeStamp)");
    }

    public PvaClientMonitor monitor(String request) {
        return this.monitor(request, null);
    }

    public PvaClientMonitor monitor(PvaClientMonitorRequester pvaClientMonitorRequester) {
        return this.monitor("field(value,alarm,timeStamp)", pvaClientMonitorRequester);
    }

    public PvaClientMonitor monitor(String request, PvaClientMonitorRequester pvaClientMonitorRequester) {
        return this.monitor(request, pvaClientMonitorRequester, null);
    }

    public PvaClientMonitor monitor(PvaClientMonitorRequester pvaClientMonitorRequester, PvaClientUnlistenRequester pvaClientListenerRequester) {
        return this.monitor("field(value,alarm,timeStamp)", pvaClientMonitorRequester, pvaClientListenerRequester);
    }

    public PvaClientMonitor monitor(String request, PvaClientMonitorRequester pvaClientMonitorRequester, PvaClientUnlistenRequester pvaClientListenerRequester) {
        PvaClientMonitor clientMonitor = this.createMonitor(request);
        clientMonitor.connect();
        clientMonitor.setRequester(pvaClientMonitorRequester);
        clientMonitor.setUnlistenRequester(pvaClientListenerRequester);
        clientMonitor.start();
        return clientMonitor;
    }

    public PvaClientMonitor createMonitor() {
        return this.createMonitor("field(value,alarm,timeStamp)");
    }

    public PvaClientMonitor createMonitor(String request) {
        PVStructure pvRequest = this.createRequest.createRequest(request);
        if (pvRequest == null) {
            String mess = "channel " + this.getChannelName() + " PvaClientChannel::createMonitor invalid pvRequest: " + this.createRequest.getMessage();
            throw new RuntimeException(mess);
        }
        return this.createMonitor(pvRequest);
    }

    public PvaClientMonitor createMonitor(PVStructure pvRequest) {
        if (this.connectState != ConnectState.connected) {
            this.connect(5.0);
        }
        return PvaClientMonitor.create(this.pvaClient, this.channel, pvRequest);
    }

    public PVStructure rpc(PVStructure pvRequest, PVStructure pvArgument) {
        PvaClientRPC rpc = this.createRPC(pvRequest);
        return rpc.request(pvArgument);
    }

    public PVStructure rpc(PVStructure pvArgument) {
        PvaClientRPC rpc = this.createRPC();
        return rpc.request(pvArgument);
    }

    public PvaClientRPC createRPC() {
        if (this.connectState != ConnectState.connected) {
            this.connect(5.0);
        }
        return PvaClientRPC.create(this.pvaClient, this.channel);
    }

    public PvaClientRPC createRPC(PVStructure pvRequest) {
        if (this.connectState != ConnectState.connected) {
            this.connect(5.0);
        }
        return PvaClientRPC.create(this.pvaClient, this.channel, pvRequest);
    }

    public String showCache() {
        return this.pvaClientGetCache.toString() + this.pvaClientPutCache.toString();
    }

    public int cacheSize() {
        return this.pvaClientGetCache.cacheSize() + this.pvaClientPutCache.cacheSize();
    }

    private static enum ConnectState {
        connectIdle,
        connectActive,
        notConnected,
        connected;

    }

    private static class PvaClientPutCache {
        private Map<String, PvaClientPut> pvaClientPutMap = new TreeMap<String, PvaClientPut>();

        void destroy() {
            this.pvaClientPutMap.clear();
        }

        PvaClientPut getPut(String request) {
            return this.pvaClientPutMap.get(request);
        }

        void addPut(String request, PvaClientPut pvaClientPut) {
            if (this.pvaClientPutMap.get(request) != null) {
                throw new RuntimeException("pvaClientPutCache::addPut pvaClientPut already cached");
            }
            this.pvaClientPutMap.put(request, pvaClientPut);
        }

        public String toString() {
            String result = "";
            Set<String> names = this.pvaClientPutMap.keySet();
            for (String name : names) {
                result = result + "      request " + name + "\n";
            }
            return result;
        }

        int cacheSize() {
            return this.pvaClientPutMap.size();
        }
    }

    private static class PvaClientGetCache {
        private Map<String, PvaClientGet> pvaClientGetMap = new TreeMap<String, PvaClientGet>();

        void destroy() {
            this.pvaClientGetMap.clear();
        }

        PvaClientGet getGet(String request) {
            return this.pvaClientGetMap.get(request);
        }

        void addGet(String request, PvaClientGet pvaClientGet) {
            if (this.pvaClientGetMap.get(request) != null) {
                throw new RuntimeException("pvaClientGetCache::addGet pvaClientGet already cached");
            }
            this.pvaClientGetMap.put(request, pvaClientGet);
        }

        public String toString() {
            String result = "";
            Set<String> names = this.pvaClientGetMap.keySet();
            for (String name : names) {
                result = result + "      request " + name + "\n";
            }
            return result;
        }

        int cacheSize() {
            return this.pvaClientGetMap.size();
        }
    }
}

