/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.epics.pvaClient.PvaClient;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelProcess;
import org.epics.pvaccess.client.ChannelProcessRequester;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;

public class PvaClientProcess
implements ChannelProcessRequester {
    private static final StatusCreate statusCreate = StatusFactory.getStatusCreate();
    private final PvaClient pvaClient;
    private final Channel channel;
    private final PVStructure pvRequest;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition waitForConnect = this.lock.newCondition();
    private final Condition waitForProcess = this.lock.newCondition();
    private volatile boolean isDestroyed = false;
    private volatile Status channelProcessConnectStatus = statusCreate.getStatusOK();
    private volatile Status channelProcessStatus = statusCreate.getStatusOK();
    private volatile ChannelProcess channelProcess = null;
    private volatile ProcessConnectState connectState = ProcessConnectState.connectIdle;
    private volatile ProcessState processState = ProcessState.processIdle;

    static PvaClientProcess create(PvaClient pvaClient, Channel channel, PVStructure pvRequest) {
        return new PvaClientProcess(pvaClient, channel, pvRequest);
    }

    private PvaClientProcess(PvaClient pvaClient, Channel channel, PVStructure pvRequest) {
        this.pvaClient = pvaClient;
        this.channel = channel;
        this.pvRequest = pvRequest;
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientProcess::PvaClientProcess()");
        }
    }

    public String getRequesterName() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientProcess was destroyed");
        }
        return this.pvaClient.getRequesterName();
    }

    public void message(String message, MessageType messageType) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientProcess was destroyed");
        }
        this.pvaClient.message(message, messageType);
    }

    public void channelProcessConnect(Status status, ChannelProcess channelProcess) {
        if (this.isDestroyed) {
            return;
        }
        this.lock.lock();
        try {
            this.channelProcessConnectStatus = status;
            this.connectState = ProcessConnectState.connected;
            this.channelProcess = channelProcess;
            this.waitForConnect.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void processDone(Status status, ChannelProcess channelProcess) {
        if (this.isDestroyed) {
            return;
        }
        this.lock.lock();
        try {
            this.channelProcessStatus = status;
            this.processState = ProcessState.processComplete;
            this.waitForProcess.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientProcess::destroy");
        }
        PvaClientProcess pvaClientProcess = this;
        synchronized (pvaClientProcess) {
            if (this.isDestroyed) {
                return;
            }
            this.isDestroyed = true;
        }
        if (this.channelProcess != null) {
            this.channelProcess.destroy();
        }
    }

    public void connect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientProcess was destroyed");
        }
        this.issueConnect();
        Status status = this.waitConnect();
        if (status.isOK()) {
            return;
        }
        String message = "channel " + this.channel.getChannelName() + " PvaClientProcess::connect " + status.getMessage();
        throw new RuntimeException(message);
    }

    public void issueConnect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientProcess was destroyed");
        }
        if (this.connectState != ProcessConnectState.connectIdle) {
            String message = "channel " + this.channel.getChannelName() + " pvaClientProcess already connected ";
            throw new RuntimeException(message);
        }
        this.connectState = ProcessConnectState.connectActive;
        this.channelProcess = this.channel.createChannelProcess((ChannelProcessRequester)this, this.pvRequest);
    }

    public Status waitConnect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientProcess was destroyed");
        }
        this.lock.lock();
        try {
            if (this.connectState == ProcessConnectState.connected) {
                if (!this.channelProcessConnectStatus.isOK()) {
                    this.connectState = ProcessConnectState.connectIdle;
                }
                Status status = this.channelProcessConnectStatus;
                return status;
            }
            if (this.connectState != ProcessConnectState.connectActive) {
                String message = "channel " + this.channel.getChannelName() + " pvaClientProcess illegal connect state ";
                throw new RuntimeException(message);
            }
            try {
                this.waitForConnect.await();
            }
            catch (InterruptedException e) {
                String message = "channel " + this.channel.getChannelName() + " InterruptedException " + e.getMessage();
                throw new RuntimeException(message);
            }
            if (!this.channelProcessConnectStatus.isOK()) {
                this.connectState = ProcessConnectState.connectIdle;
            }
            Status status = this.channelProcessConnectStatus;
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void process() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientProcess was destroyed");
        }
        this.issueProcess();
        Status status = this.waitProcess();
        if (status.isOK()) {
            return;
        }
        String message = "channel " + this.channel.getChannelName() + "PvaClientProcess::process " + status.getMessage();
        throw new RuntimeException(message);
    }

    public void issueProcess() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientProcess was destroyed");
        }
        if (this.connectState == ProcessConnectState.connectIdle) {
            this.connect();
        }
        if (this.processState != ProcessState.processIdle) {
            String message = "channel " + this.channel.getChannelName() + " PvaClientProcess::issueProcess process aleady active ";
            throw new RuntimeException(message);
        }
        this.processState = ProcessState.processActive;
        this.channelProcess.process();
    }

    public Status waitProcess() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientProcess was destroyed");
        }
        this.lock.lock();
        try {
            if (this.processState == ProcessState.processComplete) {
                this.processState = ProcessState.processIdle;
                Status status = this.channelProcessStatus;
                return status;
            }
            if (this.processState != ProcessState.processActive) {
                String message = "channel " + this.channel.getChannelName() + " PvaClientProcess::waitProcess llegal process state ";
                throw new RuntimeException(message);
            }
            try {
                this.waitForProcess.await();
            }
            catch (InterruptedException e) {
                String message = "channel " + this.channel.getChannelName() + " InterruptedException " + e.getMessage();
                throw new RuntimeException(message);
            }
            this.processState = ProcessState.processIdle;
            Status status = this.channelProcessStatus;
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static enum ProcessState {
        processIdle,
        processActive,
        processComplete;

    }

    private static enum ProcessConnectState {
        connectIdle,
        connectActive,
        connected;

    }
}

