/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.epics.pvaClient.PvaClient;
import org.epics.pvaClient.PvaClientRPCRequester;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelRPC;
import org.epics.pvaccess.client.ChannelRPCRequester;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;

public class PvaClientRPC
implements ChannelRPCRequester {
    private static final StatusCreate statusCreate = StatusFactory.getStatusCreate();
    private volatile RPCConnectState connectState = RPCConnectState.connectIdle;
    private volatile Status connectStatus = statusCreate.getStatusOK();
    private final PvaClient pvaClient;
    private final Channel channel;
    private final PVStructure pvRequest;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition waitForConnect = this.lock.newCondition();
    private final Condition waitForDone = this.lock.newCondition();
    private PvaClientRPCRequester pvaClientRPCRequester = null;
    private volatile boolean isDestroyed = false;
    private volatile ChannelRPC channelRPC = null;
    private PVStructure pvResponse = null;
    private volatile RPCState rpcState = RPCState.rpcIdle;
    private double responseTimeout = 0.0;

    static PvaClientRPC create(PvaClient pvaClient, Channel channel) {
        return PvaClientRPC.create(pvaClient, channel, null);
    }

    static PvaClientRPC create(PvaClient pvaClient, Channel channel, PVStructure pvRequest) {
        return new PvaClientRPC(pvaClient, channel, pvRequest);
    }

    private PvaClientRPC(PvaClient pvaClient, Channel channel, PVStructure pvRequest) {
        this.pvaClient = pvaClient;
        this.channel = channel;
        this.pvRequest = pvRequest;
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientRPC::PvaClientRPC");
        }
    }

    void checkRPCState() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientRPC was destroyed");
        }
        if (this.connectState == RPCConnectState.connectIdle) {
            this.connect();
        }
    }

    public String getRequesterName() {
        return this.pvaClient.getRequesterName();
    }

    public void message(String message, MessageType messageType) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientRPC was destroyed");
        }
        this.pvaClient.message(message, messageType);
    }

    public void channelRPCConnect(Status status, ChannelRPC channelRPC) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientRPC was destroyed");
        }
        this.lock.lock();
        try {
            if (PvaClient.getDebug()) {
                System.out.println("PvaClientRPC::channelRPCConnect() channel " + this.channel.getChannelName() + " status.isOK " + status.isOK());
            }
            this.connectStatus = status;
            this.connectState = RPCConnectState.connected;
            if (PvaClient.getDebug()) {
                System.out.println("PvaClientRPC::channelRPCConnect() calling waitForConnect.signal");
            }
            this.waitForConnect.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDone(Status status, ChannelRPC channelRPC, PVStructure pvResponse) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientRPC was destroyed");
        }
        this.lock.lock();
        try {
            if (PvaClient.getDebug()) {
                System.out.println("PvaClientRPC::requestDone() channel " + this.channel.getChannelName() + " status.isOK " + status.isOK());
            }
            if (this.rpcState != RPCState.rpcActive) {
                String message = "channel " + this.channel.getChannelName() + " PvaClientRPC::requestDone but not active ";
                throw new RuntimeException(message);
            }
            if (this.pvaClientRPCRequester != null && this.responseTimeout <= 0.0) {
                this.rpcState = RPCState.rpcIdle;
            } else {
                this.rpcState = RPCState.rpcComplete;
                if (this.pvaClientRPCRequester == null) {
                    this.pvResponse = pvResponse;
                }
                this.waitForDone.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.pvaClientRPCRequester != null) {
            this.pvaClientRPCRequester.requestDone(status, this, pvResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientRPC::destroy");
        }
        PvaClientRPC pvaClientRPC = this;
        synchronized (pvaClientRPC) {
            if (this.isDestroyed) {
                return;
            }
            this.isDestroyed = true;
        }
        if (this.channelRPC != null) {
            this.channelRPC.destroy();
        }
    }

    public void setResponseTimeout(double responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public double getResponseTimeout() {
        return this.responseTimeout;
    }

    public void connect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientRPC was destroyed");
        }
        this.issueConnect();
        Status status = this.waitConnect();
        if (status.isOK()) {
            return;
        }
        String message = "channel " + this.channel.getChannelName() + " PvaClientRPC::connect " + status.getMessage();
        throw new RuntimeException(message);
    }

    public void issueConnect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientRPC was destroyed");
        }
        if (this.connectState != RPCConnectState.connectIdle) {
            String message = "channel " + this.channel.getChannelName() + "  pvaClientRPC already connected";
            throw new RuntimeException(message);
        }
        this.connectState = RPCConnectState.connectActive;
        this.channelRPC = this.channel.createChannelRPC((ChannelRPCRequester)this, this.pvRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status waitConnect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientRPC was destroyed");
        }
        this.lock.lock();
        try {
            if (this.connectState == RPCConnectState.connected) {
                if (!this.connectStatus.isOK()) {
                    this.connectState = RPCConnectState.connectIdle;
                }
                Status status = this.connectStatus;
                return status;
            }
            if (this.connectState != RPCConnectState.connectActive) {
                String message = "channel " + this.channel.getChannelName() + " pvaClientRPC illegal connect state ";
                Status status = statusCreate.createStatus(Status.StatusType.ERROR, message, null);
                return status;
            }
            try {
                this.waitForConnect.await();
            }
            catch (InterruptedException e) {
                String message = "channel " + this.channel.getChannelName() + " InterruptedException " + e.getMessage();
                Status status = statusCreate.createStatus(Status.StatusType.ERROR, message, e.fillInStackTrace());
                this.lock.unlock();
                return status;
            }
            if (!this.connectStatus.isOK()) {
                this.connectState = RPCConnectState.connectIdle;
            }
            Status status = this.connectStatus;
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PVStructure request(PVStructure pvArgument) {
        this.checkRPCState();
        if (this.rpcState != RPCState.rpcIdle) {
            String message = "channel " + this.channel.getChannelName() + " PvaClientRPC::request request aleady active ";
            throw new RuntimeException(message);
        }
        this.rpcState = RPCState.rpcActive;
        this.channelRPC.request(pvArgument);
        this.lock.lock();
        try {
            if (this.rpcState != RPCState.rpcComplete) {
                try {
                    if (this.responseTimeout > 0.0) {
                        long nano = (long)(this.responseTimeout * 1.0E9);
                        long ret = this.waitForDone.awaitNanos(nano);
                        if (ret <= 0L) {
                            String message = "channel " + this.channel.getChannelName() + " request timeout";
                            throw new RuntimeException(message);
                        }
                    } else {
                        this.waitForDone.await();
                    }
                }
                catch (InterruptedException e) {
                    String message = "channel " + this.channel.getChannelName() + " InterruptedException " + e.getMessage();
                    if (this.pvaClientRPCRequester != null) {
                        Status status = statusCreate.createStatus(Status.StatusType.ERROR, message, null);
                        this.pvaClientRPCRequester.requestDone(status, this, null);
                    }
                    throw new RuntimeException(message);
                }
            }
            this.rpcState = RPCState.rpcIdle;
            PVStructure pVStructure = this.pvResponse;
            return pVStructure;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(PVStructure pvArgument, PvaClientRPCRequester pvaClientRPCRequester) {
        this.pvaClientRPCRequester = pvaClientRPCRequester;
        this.checkRPCState();
        if (this.responseTimeout <= 0.0) {
            this.lock.lock();
            try {
                if (this.rpcState != RPCState.rpcIdle) {
                    String message = "channel " + this.channel.getChannelName() + " PvaClientRPC::request request aleady active ";
                    throw new RuntimeException(message);
                }
                this.rpcState = RPCState.rpcActive;
            }
            finally {
                this.lock.unlock();
            }
            this.channelRPC.request(pvArgument);
            return;
        }
        this.request(pvArgument);
    }

    private static enum RPCState {
        rpcIdle,
        rpcActive,
        rpcComplete;

    }

    private static enum RPCConnectState {
        connectIdle,
        connectActive,
        connected;

    }
}

